/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui.recipe;

import java.util.Arrays;
import java.util.Objects;

public class RecipeCacheKey {
    private final String recipeId;
    private final byte[] inventoryHash;
    private final int playerLevel;
    private final double playerMoney;

    public RecipeCacheKey(String recipeId, byte[] inventoryHash, int playerLevel, double playerMoney) {
        this.recipeId = recipeId;
        this.inventoryHash = Arrays.copyOf(inventoryHash, inventoryHash.length);
        this.playerLevel = playerLevel;
        this.playerMoney = playerMoney;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecipeCacheKey)) {
            return false;
        }
        RecipeCacheKey that = (RecipeCacheKey)o;
        return this.playerLevel == that.playerLevel && Double.compare(that.playerMoney, this.playerMoney) == 0 && Objects.equals(this.recipeId, that.recipeId) && Arrays.equals(this.inventoryHash, that.inventoryHash);
    }

    public int hashCode() {
        int result = Objects.hash(this.recipeId, this.playerLevel, this.playerMoney);
        result = 31 * result + Arrays.hashCode(this.inventoryHash);
        return result;
    }
}

