/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class IngredientFingerprint {
    private final Material type;
    private final int customModelData;
    private final String displayName;
    private final List<String> lore;
    private final Map<Enchantment, Integer> enchantments;
    private final boolean unbreakable;
    private final int durability;

    public IngredientFingerprint(Material type, int customModelData, String displayName, List<String> lore, Map<Enchantment, Integer> enchantments, boolean unbreakable, int durability) {
        this.type = type;
        this.customModelData = customModelData;
        this.displayName = displayName == null ? "" : displayName;
        this.lore = lore == null ? Collections.emptyList() : new ArrayList<String>(lore);
        this.enchantments = enchantments == null ? Collections.emptyMap() : new HashMap<Enchantment, Integer>(enchantments);
        this.unbreakable = unbreakable;
        this.durability = durability;
    }

    public static IngredientFingerprint of(ItemStack is) {
        Material mat = is.getType();
        ItemMeta meta = is.getItemMeta();
        int cmd = 0;
        String name = "";
        List<String> loreList = Collections.emptyList();
        Map<Enchantment, Integer> enchantsMap = Collections.emptyMap();
        boolean unbreak = false;
        int dmg = 0;
        if (meta != null) {
            Map raw;
            if (meta.hasCustomModelData()) {
                cmd = meta.getCustomModelData();
            }
            if (meta.hasDisplayName()) {
                name = meta.getDisplayName();
            }
            if (meta.hasLore()) {
                loreList = new ArrayList<String>(Objects.requireNonNull(meta.getLore()));
            }
            if (!(raw = meta.getEnchants()).isEmpty()) {
                enchantsMap = new HashMap<Enchantment, Integer>(raw);
            }
            unbreak = meta.isUnbreakable();
            if (meta instanceof Damageable) {
                Damageable dmeta = (Damageable)meta;
                dmg = dmeta.getDamage();
            }
        }
        return new IngredientFingerprint(mat, cmd, name, loreList, enchantsMap, unbreak, dmg);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IngredientFingerprint)) {
            return false;
        }
        IngredientFingerprint that = (IngredientFingerprint)o;
        return this.customModelData == that.customModelData && this.unbreakable == that.unbreakable && this.durability == that.durability && this.type == that.type && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.lore, that.lore) && Objects.equals(this.enchantments, that.enchantments);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.customModelData, this.displayName, this.lore, this.enchantments, this.unbreakable, this.durability);
    }
}

