/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui.editors.professions.recipes;

import java.util.List;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.editors.EditorCriteria;
import studio.magemonkey.fusion.cfg.editors.EditorRegistry;
import studio.magemonkey.fusion.commands.FusionEditorCommand;
import studio.magemonkey.fusion.data.recipes.Recipe;
import studio.magemonkey.fusion.gui.editors.Editor;
import studio.magemonkey.fusion.gui.editors.professions.recipes.RecipeEditor;
import studio.magemonkey.fusion.gui.editors.professions.recipes.RecipeIconEditor;
import studio.magemonkey.fusion.util.InventoryUtils;

public class RecipeItemEditor
extends Editor
implements Listener {
    private final Player player;
    private final Recipe recipe;
    private RecipeIconEditor recipeIconEditor;

    public RecipeItemEditor(Editor parentEditor, Player player, Recipe recipe) {
        super(parentEditor, EditorRegistry.getRecipeEditorCfg().getSubTitle(recipe.getName()), 54);
        this.player = player;
        this.recipe = recipe;
        this.setIcons(EditorRegistry.getRecipeEditorCfg().getSubIcons(recipe));
        this.initialize();
        Fusion.registerListener(this);
    }

    public void initialize() {
        InventoryUtils.fillInventory(this.getInventory(), this.getIcons().get("fill"));
        this.setItem(4, this.getIcons().get("name"));
        this.setItem(10, this.getIcons().get("craftingTime"));
        this.setItem(11, this.getIcons().get("craftingLimit"));
        this.setItem(12, this.getIcons().get("craftingLimitCooldown"));
        this.setItem(15, this.getIcons().get("professionExp"));
        this.setItem(16, this.getIcons().get("vanillaExp"));
        this.setItem(19, this.getIcons().get("resultItem"));
        this.setItem(20, this.getIcons().get("hiding_noPermission"));
        this.setItem(21, this.getIcons().get("hiding_recipeLimitReached"));
        this.setItem(24, this.getIcons().get("commands"));
        this.setItem(25, this.getIcons().get("items"));
        this.setItem(37, this.getIcons().get("ingredients"));
        this.setItem(38, this.getIcons().get("moneyCost"));
        this.setItem(39, this.getIcons().get("expCost"));
        this.setItem(40, this.getIcons().get("professionLevel"));
        this.setItem(41, this.getIcons().get("mastery"));
        this.setItem(42, this.getIcons().get("permission"));
        this.setItem(43, this.getIcons().get("conditions"));
        this.setItem(49, this.getIcons().get("category"));
        this.setItem(53, this.getIcons().get("back"));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getClickedInventory() != this.getInventory()) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        boolean hasChanges = false;
        switch (event.getSlot()) {
            case 4: {
                FusionEditorCommand.suggestUsage(player, EditorCriteria.Profession_Recipe_Edit_Name, "/fusion-editor <newName>");
                break;
            }
            case 10: {
                int amount;
                int n = amount = event.isShiftClick() ? 10 : 1;
                if (event.isLeftClick()) {
                    this.recipe.setCraftingTime(this.recipe.getCraftingTime() + amount);
                    hasChanges = true;
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.recipe.getCraftingTime() == 0) {
                    return;
                }
                this.recipe.setCraftingTime(Math.max(this.recipe.getCraftingTime() - amount, 0));
                hasChanges = true;
                break;
            }
            case 11: {
                int amount;
                int n = amount = event.isShiftClick() ? 10 : 1;
                if (event.isLeftClick()) {
                    this.recipe.setCraftingLimit(this.recipe.getCraftingLimit() + amount);
                    hasChanges = true;
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.recipe.getCraftingLimit() == 0) {
                    return;
                }
                this.recipe.setCraftingLimit(Math.max(this.recipe.getCraftingLimit() - amount, 0));
                hasChanges = true;
                break;
            }
            case 12: {
                int amount;
                int n = amount = event.isShiftClick() ? 10 : 1;
                if (event.isLeftClick()) {
                    this.recipe.setCraftingLimitCooldown(this.recipe.getCraftingLimitCooldown() + amount);
                    hasChanges = true;
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.recipe.getCraftingLimitCooldown() == -1) {
                    return;
                }
                this.recipe.setCraftingLimitCooldown(Math.max(this.recipe.getCraftingLimitCooldown() - amount, -1));
                hasChanges = true;
                break;
            }
            case 15: {
                int amount;
                int n = amount = event.isShiftClick() ? 10 : 1;
                if (event.isLeftClick()) {
                    this.recipe.getResults().setProfessionExp(this.recipe.getResults().getProfessionExp() + (long)amount);
                    hasChanges = true;
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.recipe.getResults().getProfessionExp() == 0L) {
                    return;
                }
                this.recipe.getResults().setProfessionExp(Math.max(this.recipe.getResults().getProfessionExp() - (long)amount, 0L));
                hasChanges = true;
                break;
            }
            case 16: {
                int amount;
                int n = amount = event.isShiftClick() ? 10 : 1;
                if (event.isLeftClick()) {
                    this.recipe.getResults().setVanillaExp(this.recipe.getResults().getVanillaExp() + amount);
                    hasChanges = true;
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.recipe.getResults().getVanillaExp() == 0) {
                    return;
                }
                this.recipe.getResults().setVanillaExp(Math.max(this.recipe.getResults().getVanillaExp() - amount, 0));
                hasChanges = true;
                break;
            }
            case 19: {
                if (event.isLeftClick()) {
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.Profession_Recipe_Edit_ResultItem, "/fusion-editor " + this.getRecipeName() + " " + this.getRecipeAmount());
                    break;
                }
                if (!event.isRightClick()) break;
                this.recipeIconEditor = new RecipeIconEditor((Editor)this, player, this.recipe);
                this.recipeIconEditor.open(player);
                break;
            }
            case 20: {
                if (event.isLeftClick()) {
                    if (this.recipe.getSettings().getHideNoPermission() == null) {
                        this.recipe.getSettings().setHideNoPermission(true);
                    } else {
                        this.recipe.getSettings().setHideNoPermission(this.recipe.getSettings().getHideNoPermission() == false);
                    }
                } else if (event.isRightClick()) {
                    this.recipe.getSettings().setHideNoPermission(null);
                }
                hasChanges = true;
                break;
            }
            case 21: {
                if (event.isLeftClick()) {
                    if (this.recipe.getSettings().getHideRecipeLimitReached() == null) {
                        this.recipe.getSettings().setHideRecipeLimitReached(true);
                    } else {
                        this.recipe.getSettings().setHideRecipeLimitReached(this.recipe.getSettings().getHideRecipeLimitReached() == false);
                    }
                } else if (event.isRightClick()) {
                    this.recipe.getSettings().setHideRecipeLimitReached(null);
                }
                hasChanges = true;
                break;
            }
            case 24: {
                if (event.isLeftClick()) {
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.Profession_Recipe_Add_Commands, "/fusion-editor <caster> <delay> <command without />");
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.recipe.getResults().getCommands().isEmpty()) {
                    return;
                }
                hasChanges = true;
                this.recipe.getResults().getCommands().remove(this.recipe.getResults().getCommands().size() - 1);
                break;
            }
            case 25: {
                if (event.isLeftClick()) {
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.Profession_Recipe_Add_Items, "/fusion-editor <item> <mount>");
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.recipe.getResults().getItems().isEmpty()) {
                    return;
                }
                hasChanges = true;
                this.recipe.getResults().getItems().remove(this.recipe.getResults().getItems().size() - 1);
                break;
            }
            case 37: {
                if (event.isLeftClick()) {
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.Profession_Recipe_Add_Ingredients, "/fusion-editor <ingredient> <amount>");
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.recipe.getConditions().getRequiredItems().size() == 1) {
                    CodexEngine.get().getMessageUtil().sendMessage("editor.needMinimumOne", (CommandSender)player, new MessageData[0]);
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.Profession_Recipe_Edit_Ingredients, "/fusion-editor <ingredient> <amount>");
                    return;
                }
                hasChanges = true;
                this.recipe.getConditions().getRequiredItems().remove(this.recipe.getConditions().getRequiredItems().size() - 1);
                break;
            }
            case 38: {
                int amount;
                int n = amount = event.isShiftClick() ? 10 : 1;
                if (event.isLeftClick()) {
                    this.recipe.getConditions().setMoneyCost(this.recipe.getConditions().getMoneyCost() + (double)amount);
                    hasChanges = true;
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.recipe.getConditions().getMoneyCost() == 0.0) {
                    return;
                }
                this.recipe.getConditions().setMoneyCost(Math.max(this.recipe.getConditions().getMoneyCost() - (double)amount, 0.0));
                hasChanges = true;
                break;
            }
            case 39: {
                int amount;
                int n = amount = event.isShiftClick() ? 10 : 1;
                if (event.isLeftClick()) {
                    this.recipe.getConditions().setExpCost(this.recipe.getConditions().getExpCost() + amount);
                    hasChanges = true;
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.recipe.getConditions().getExpCost() == 0) {
                    return;
                }
                this.recipe.getConditions().setExpCost(Math.max(this.recipe.getConditions().getExpCost() - amount, 0));
                hasChanges = true;
                break;
            }
            case 40: {
                int amount;
                int n = amount = event.isShiftClick() ? 10 : 1;
                if (event.isLeftClick()) {
                    this.recipe.getConditions().setProfessionLevel(this.recipe.getConditions().getProfessionLevel() + amount);
                    hasChanges = true;
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.recipe.getConditions().getProfessionLevel() == 0) {
                    return;
                }
                this.recipe.getConditions().setProfessionLevel(Math.max(this.recipe.getConditions().getProfessionLevel() - amount, 0));
                hasChanges = true;
                break;
            }
            case 41: {
                this.recipe.getConditions().setMastery(!this.recipe.getConditions().isMastery());
                hasChanges = true;
                break;
            }
            case 42: {
                if (event.isLeftClick()) {
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.Profession_Recipe_Edit_Permission, "/fusion-editor <permission>");
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.recipe.getConditions().getPermission() == null) {
                    return;
                }
                this.recipe.getConditions().setPermission(null);
                hasChanges = true;
                break;
            }
            case 43: {
                if (event.isLeftClick()) {
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.Profession_Recipe_Add_Conditions, "/fusion-editor <conditionKey> <conditionValue> <level>");
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.recipe.getConditions().getFullConditions().isEmpty()) {
                    return;
                }
                this.recipe.getConditions().removeLastCondition();
                hasChanges = true;
                break;
            }
            case 49: {
                List<String> categories = ((RecipeEditor)this.getParentEditor()).getTable().getCategoryList();
                String currentCategory = this.recipe.getCategory();
                int currentIndex = categories.indexOf(currentCategory);
                if (event.isLeftClick()) {
                    if (currentIndex == categories.size() - 1) {
                        this.recipe.setCategory(categories.get(0));
                    } else {
                        this.recipe.setCategory(categories.get(currentIndex + 1));
                    }
                    hasChanges = true;
                    break;
                }
                if (!event.isRightClick()) break;
                if (currentIndex == 0) {
                    this.recipe.setCategory(categories.get(categories.size() - 1));
                } else {
                    this.recipe.setCategory(categories.get(currentIndex - 1));
                }
                hasChanges = true;
                break;
            }
            case 53: {
                this.reload(false);
                ((RecipeEditor)this.getParentEditor()).reload(true);
                return;
            }
        }
        if (hasChanges) {
            this.reload(true);
        }
    }

    public void reload(boolean open) {
        this.setIcons(EditorRegistry.getRecipeEditorCfg().getSubIcons(this.recipe));
        this.initialize();
        if (open) {
            this.open(this.player);
        }
    }

    public String getRecipeName() {
        return this.recipe.getSettings().getIconNamespace().split(":")[0];
    }

    public int getRecipeAmount() {
        return Integer.parseInt(this.recipe.getSettings().getIconNamespace().split(":")[1]);
    }

    @Generated
    public Recipe getRecipe() {
        return this.recipe;
    }

    @Generated
    public RecipeIconEditor getRecipeIconEditor() {
        return this.recipeIconEditor;
    }
}

