/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui.editors.professions.recipes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.editors.EditorCriteria;
import studio.magemonkey.fusion.cfg.editors.EditorRegistry;
import studio.magemonkey.fusion.commands.FusionEditorCommand;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.data.recipes.Recipe;
import studio.magemonkey.fusion.gui.editors.Editor;
import studio.magemonkey.fusion.gui.editors.professions.recipes.RecipeItemEditor;
import studio.magemonkey.fusion.util.InventoryUtils;

public class RecipeEditor
extends Editor
implements Listener {
    private final Player player;
    private final CraftingTable table;
    private RecipeItemEditor recipeItemEditor;
    private final HashMap<Inventory, HashMap<Integer, Recipe>> slots = new HashMap();

    public RecipeEditor(Editor parentEditor, Player player, CraftingTable table) {
        super(parentEditor, EditorRegistry.getRecipeEditorCfg().getTitle(), 54);
        this.player = player;
        this.table = table;
        this.setIcons(EditorRegistry.getRecipeEditorCfg().getIcons(table));
        this.initialize();
        Fusion.registerListener(this);
    }

    public void initialize() {
        this.slots.clear();
        this.getNestedInventories().clear();
        HashMap<Integer, Recipe> invSlots = new HashMap<Integer, Recipe>();
        ArrayList<Inventory> inventories = new ArrayList<Inventory>();
        Inventory inv = null;
        int invSlot = 0;
        Collection<Recipe> recipes = this.table.getRecipes().values();
        for (Recipe entry : recipes) {
            int invDex = invSlot % 36 + 9;
            if (invDex == 9) {
                if (inv != null) {
                    inventories.add(inv);
                }
                inv = InventoryUtils.createFilledInventory(null, EditorRegistry.getRecipeEditorCfg().getTitle(), 54, this.getIcons().get("fill"));
                inv.setItem(4, this.getIcons().get("add"));
                inv.setItem(48, this.getIcons().get("previous"));
                inv.setItem(50, this.getIcons().get("next"));
                inv.setItem(53, this.getIcons().get("back"));
                invSlots = new HashMap();
            }
            inv.setItem(invDex, EditorRegistry.getRecipeEditorCfg().getRecipeIcon(entry));
            invSlots.put(invDex, entry);
            this.slots.put(inv, invSlots);
            ++invSlot;
        }
        if (inv == null) {
            inv = InventoryUtils.createFilledInventory(null, EditorRegistry.getRecipeEditorCfg().getTitle(), 54, this.getIcons().get("fill"));
            inv.setItem(4, this.getIcons().get("add"));
            inv.setItem(48, this.getIcons().get("previous"));
            inv.setItem(50, this.getIcons().get("next"));
            inv.setItem(53, this.getIcons().get("back"));
        }
        inventories.add(inv);
        this.setNestedInventories(inventories);
    }

    @Override
    public void open(Player player) {
        this.open(player, 0);
    }

    public void open(Player player, int page) {
        player.openInventory(this.getNestedInventories().get(page) != null ? this.getNestedInventories().get(page) : this.getNestedInventories().get(page - 1));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int invdex = this.getNestedInventories().indexOf(event.getInventory());
        if (invdex < 0) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        int slot = event.getSlot();
        int size = this.getNestedInventories().size();
        boolean hasChanges = false;
        switch (event.getSlot()) {
            case 4: {
                FusionEditorCommand.suggestUsage(player, EditorCriteria.Profession_Recipe_Add, "/fusion-editor <recipeName> <resultItem> <amount>");
                break;
            }
            case 48: {
                this.open(player, (size + invdex - 1) % size);
                break;
            }
            case 50: {
                this.open(player, (invdex + 1) % size);
                break;
            }
            case 53: {
                this.openParent(player);
                break;
            }
            default: {
                if (!this.slots.containsKey(this.getNestedInventories().get(invdex)) || !this.slots.get(this.getNestedInventories().get(invdex)).containsKey(slot)) break;
                Recipe entry = this.slots.get(this.getNestedInventories().get(invdex)).get(slot);
                if (!event.isShiftClick()) {
                    if (event.isLeftClick()) {
                        this.recipeItemEditor = new RecipeItemEditor((Editor)this, player, entry);
                        this.recipeItemEditor.open(player);
                        break;
                    }
                    if (!event.isRightClick()) break;
                    this.table.getRecipes().remove(entry.getName());
                    hasChanges = true;
                    break;
                }
                Recipe recipe = this.table.getRecipes().get(entry.getName());
                if (event.isLeftClick()) {
                    this.table.moveEntry(recipe, -1);
                    hasChanges = true;
                    break;
                }
                if (!event.isRightClick()) break;
                this.table.moveEntry(recipe, 1);
                hasChanges = true;
            }
        }
        if (hasChanges) {
            this.reload(true);
        }
    }

    public void reload(boolean open) {
        this.setIcons(EditorRegistry.getRecipeEditorCfg().getIcons(this.table));
        this.initialize();
        if (open) {
            this.open(this.player);
        }
    }

    @Generated
    public CraftingTable getTable() {
        return this.table;
    }

    @Generated
    public RecipeItemEditor getRecipeItemEditor() {
        return this.recipeItemEditor;
    }
}

