/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui.editors.professions;

import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.cfg.editors.EditorCriteria;
import studio.magemonkey.fusion.cfg.editors.EditorRegistry;
import studio.magemonkey.fusion.commands.FusionEditorCommand;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.gui.editors.Editor;
import studio.magemonkey.fusion.gui.editors.pattern.PatternEditor;
import studio.magemonkey.fusion.gui.editors.pattern.PatternItemsEditor;
import studio.magemonkey.fusion.gui.editors.professions.CategoryEditor;
import studio.magemonkey.fusion.gui.editors.professions.recipes.RecipeEditor;
import studio.magemonkey.fusion.util.InventoryUtils;

public class ProfessionEditor
extends Editor
implements Listener {
    private final Player player;
    private final String profession;
    private final CraftingTable table;
    private PatternItemsEditor patternItemsEditor;
    private PatternEditor patternEditor;
    private PatternItemsEditor categoryPatternItemEditor;
    private PatternEditor categoryPatternEditor;
    private CategoryEditor categoryEditor;
    private RecipeEditor recipeEditor;

    public ProfessionEditor(Player player, String profession) {
        super(null, EditorRegistry.getProfessionEditorCfg().getTitle(profession), 45);
        this.player = player;
        this.profession = profession;
        this.table = CraftingTable.copy(ProfessionsCfg.getTable(profession));
        this.table.cleanUpRecipesForEditor();
        this.setIcons(EditorRegistry.getProfessionEditorCfg().getIcons(this.table));
        this.initialize();
        Fusion.registerListener(this);
    }

    private void initialize() {
        InventoryUtils.fillInventory(this.getInventory(), this.getIcons().get("fill"));
        this.setItem(10, this.getIcons().get("name"));
        this.setItem(11, this.getIcons().get("icon"));
        this.setItem(12, this.getIcons().get("masteryUnlock"));
        this.setItem(13, this.getIcons().get("masteryCost"));
        this.setItem(14, this.getIcons().get("maxLevel"));
        this.setItem(16, this.getIcons().get("recipes"));
        this.setItem(28, this.getIcons().get("useCategories"));
        this.setItem(29, this.getIcons().get("patternItems"));
        this.setItem(30, this.getIcons().get("pattern"));
        this.setItem(32, this.getIcons().get("categories"));
        this.setItem(33, this.getIcons().get("categoryPatternItems"));
        this.setItem(34, this.getIcons().get("categoryPattern"));
        this.setItem(36, this.getIcons().get("save"));
        this.setItem(44, this.getIcons().get("back"));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory() != this.getInventory()) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        boolean hasChanges = false;
        switch (event.getSlot()) {
            case 10: {
                FusionEditorCommand.suggestUsage(player, EditorCriteria.Profession_Edit_Name, "/fusion-editor " + this.table.getName());
                break;
            }
            case 11: {
                FusionEditorCommand.suggestUsage(player, EditorCriteria.Profession_Edit_Icon, "/fusion-editor DIVINITY_" + this.table.getIconItem().getID());
                break;
            }
            case 12: {
                int amount;
                int n = amount = event.isShiftClick() ? 10 : 1;
                if (event.isLeftClick()) {
                    this.table.setMasteryUnlock(this.table.getMasteryUnlock() + amount);
                    hasChanges = true;
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.table.getMasteryUnlock() == 0) {
                    return;
                }
                this.table.setMasteryUnlock(Math.max(this.table.getMasteryUnlock() - amount, 0));
                hasChanges = true;
                break;
            }
            case 13: {
                int amount;
                int n = amount = event.isShiftClick() ? 100 : 1;
                if (event.isLeftClick()) {
                    this.table.setMasteryFee(this.table.getMasteryFee() + amount);
                    hasChanges = true;
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.table.getMasteryFee() == 0) {
                    return;
                }
                this.table.setMasteryFee(Math.max(this.table.getMasteryFee() - amount, 0));
                hasChanges = true;
                break;
            }
            case 14: {
                int amount;
                int n = amount = event.isShiftClick() ? 10 : 1;
                if (event.isLeftClick()) {
                    this.table.setMaxLevel(this.table.getMaxLevel() + amount);
                    hasChanges = true;
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.table.getMaxLevel() == 0) {
                    return;
                }
                this.table.setMaxLevel(Math.max(this.table.getMaxLevel() - amount, 0));
                hasChanges = true;
                break;
            }
            case 16: {
                if (this.recipeEditor == null) {
                    this.recipeEditor = new RecipeEditor((Editor)this, player, this.table);
                }
                this.recipeEditor.open(player);
                break;
            }
            case 28: {
                this.table.setUseCategories(!this.table.getUseCategories());
                hasChanges = true;
                break;
            }
            case 29: {
                if (this.patternItemsEditor == null) {
                    this.patternItemsEditor = new PatternItemsEditor(this, player, this.table, false);
                }
                this.patternItemsEditor.open(player);
                break;
            }
            case 30: {
                if (this.patternEditor == null) {
                    this.patternEditor = new PatternEditor(this, player, this.table, false);
                }
                this.patternEditor.open(player);
                break;
            }
            case 32: {
                if (this.categoryEditor == null) {
                    this.categoryEditor = new CategoryEditor((Editor)this, player, this.table);
                }
                this.categoryEditor.open(player);
                break;
            }
            case 33: {
                if (this.categoryPatternItemEditor == null) {
                    this.categoryPatternItemEditor = new PatternItemsEditor(this, player, this.table, true);
                }
                this.categoryPatternItemEditor.open(player);
                break;
            }
            case 34: {
                if (event.isLeftClick()) {
                    if (this.categoryPatternEditor == null) {
                        this.categoryPatternEditor = new PatternEditor(this, player, this.table, true);
                    }
                    this.categoryPatternEditor.open(player);
                    break;
                }
                if (!event.isRightClick() || this.table.getCatPattern() == null) break;
                this.table.getCatPattern().clear();
                break;
            }
            case 36: {
                this.table.save(() -> {
                    player.closeInventory();
                    CodexEngine.get().getMessageUtil().sendMessage("editor.changesSaved", (CommandSender)player, new MessageData[]{new MessageData("file", (Object)ProfessionsCfg.getFiles().get(this.profession).getName())});
                    EditorRegistry.removeCurrentEditor(player);
                    FusionEditorCommand.removeEditorCriteria(player.getUniqueId());
                    ProfessionsCfg.init();
                });
                break;
            }
            case 44: {
                player.closeInventory();
                hasChanges = true;
            }
        }
        if (hasChanges) {
            this.reload(true);
        }
    }

    public void reload(boolean open) {
        this.setIcons(EditorRegistry.getProfessionEditorCfg().getIcons(this.table));
        this.initialize();
        if (open) {
            this.open(this.player);
        }
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public String getProfession() {
        return this.profession;
    }

    @Generated
    public CraftingTable getTable() {
        return this.table;
    }

    @Generated
    public PatternItemsEditor getPatternItemsEditor() {
        return this.patternItemsEditor;
    }

    @Generated
    public PatternEditor getPatternEditor() {
        return this.patternEditor;
    }

    @Generated
    public PatternItemsEditor getCategoryPatternItemEditor() {
        return this.categoryPatternItemEditor;
    }

    @Generated
    public PatternEditor getCategoryPatternEditor() {
        return this.categoryPatternEditor;
    }

    @Generated
    public CategoryEditor getCategoryEditor() {
        return this.categoryEditor;
    }

    @Generated
    public RecipeEditor getRecipeEditor() {
        return this.recipeEditor;
    }
}

