/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui.editors.pattern;

import java.util.ArrayList;
import lombok.Generated;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.codex.api.DelayedCommand;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.editors.EditorCriteria;
import studio.magemonkey.fusion.cfg.editors.EditorRegistry;
import studio.magemonkey.fusion.commands.FusionEditorCommand;
import studio.magemonkey.fusion.data.professions.pattern.InventoryPattern;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.gui.editors.Editor;
import studio.magemonkey.fusion.gui.editors.browse.BrowseEditor;
import studio.magemonkey.fusion.gui.editors.pattern.PatternItemsEditor;
import studio.magemonkey.fusion.util.InventoryUtils;

public class PatternItemEditor
extends Editor
implements Listener {
    private final Player player;
    private final InventoryPattern pattern;
    private final char c;
    private final CraftingTable table;
    private final boolean isCategoryPattern;
    private final BrowseEditor browseEditor;
    private ItemBuilder builder;

    public PatternItemEditor(Editor parentEditor, Player player, CraftingTable table, char c, boolean isCategoryPattern) {
        super(parentEditor, EditorRegistry.getPatternItemEditorCfg().getSubTitle(c), 45);
        this.player = player;
        this.table = table;
        this.c = c;
        this.isCategoryPattern = isCategoryPattern;
        this.pattern = isCategoryPattern ? table.getCatPattern() : table.getRecipePattern();
        this.browseEditor = null;
        ItemStack item = this.pattern.getItems().get(Character.valueOf(c));
        this.builder = ItemBuilder.newItem((ItemStack)item);
        this.setIcons(EditorRegistry.getPatternItemEditorCfg().getSubIcons(c, this.builder, this.pattern.getCommands(c)));
        this.initialize();
        Fusion.registerListener(this);
    }

    public PatternItemEditor(Editor editor, BrowseEditor browseEditor, Player player, char c) {
        super(editor, EditorRegistry.getPatternItemEditorCfg().getSubTitle(c), 45);
        this.player = player;
        this.browseEditor = browseEditor;
        this.c = c;
        this.table = null;
        this.isCategoryPattern = false;
        this.pattern = browseEditor.getBrowsePattern();
        ItemStack item = this.pattern.getItems().get(Character.valueOf(c));
        this.builder = ItemBuilder.newItem((ItemStack)item);
        this.setIcons(EditorRegistry.getPatternItemEditorCfg().getSubIcons(c, this.builder, this.pattern.getCommands(c)));
        this.initialize();
        Fusion.registerListener(this);
    }

    private void initialize() {
        InventoryUtils.fillInventory(this.getInventory(), this.getIcons().get("fill"));
        this.setItem(10, this.getIcons().get("name"));
        this.setItem(11, this.getIcons().get("lore"));
        this.setItem(13, this.getIcons().get("patternItem"));
        this.setItem(15, this.getIcons().get("glowing"));
        this.setItem(16, this.getIcons().get("commands"));
        this.setItem(29, this.getIcons().get("durability"));
        this.setItem(30, this.getIcons().get("unbreakable"));
        this.setItem(32, this.getIcons().get("enchants"));
        this.setItem(33, this.getIcons().get("flags"));
        this.setItem(44, this.getIcons().get("back"));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getClickedInventory() != this.getInventory()) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        boolean hasChanges = false;
        switch (event.getSlot()) {
            case 10: {
                FusionEditorCommand.suggestUsage(player, EditorCriteria.Pattern_Edit_Name, "/fusion-editor " + this.builder.getName());
                break;
            }
            case 11: {
                if (event.isLeftClick()) {
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.Pattern_Edit_Lore, "/fusion-editor <lore>");
                    break;
                }
                if (this.builder.getLore().isEmpty()) {
                    return;
                }
                this.builder.getLore().remove(this.builder.getLore().size() - 1);
                hasChanges = true;
                break;
            }
            case 13: {
                FusionEditorCommand.suggestUsage(player, EditorCriteria.Pattern_Edit_Pattern, "/fusion-editor " + this.builder.getMaterial().getNamespacedID() + " " + this.builder.getAmount());
                break;
            }
            case 15: {
                if (!this.builder.getEnchants().isEmpty()) {
                    this.builder.clearEnchants();
                    this.builder.clearFlags();
                } else {
                    this.builder.enchant(Enchantment.UNBREAKING, 1);
                    this.builder.flag(ItemFlag.HIDE_ENCHANTS);
                }
                hasChanges = true;
                break;
            }
            case 16: {
                if (event.isLeftClick()) {
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.Pattern_Add_Commands, "/fusion-editor <caster> <delay> <command without />");
                    break;
                }
                if (this.pattern.getCommands(this.c).isEmpty()) {
                    return;
                }
                DelayedCommand command = new ArrayList<DelayedCommand>(this.pattern.getCommands(this.c)).get(this.pattern.getCommands(this.c).size() - 1);
                this.pattern.getCommands(this.c).remove(command);
                hasChanges = true;
                break;
            }
            case 26: {
                this.reload(false);
                ((PatternItemsEditor)this.getParentEditor()).reload(true);
                return;
            }
            case 29: {
                int amount;
                int n = amount = event.isShiftClick() ? 25 : 1;
                if (event.isLeftClick()) {
                    this.builder.durability(this.builder.getDurability() + amount);
                    hasChanges = true;
                } else if (event.isRightClick()) {
                    if (this.builder.getDurability() == 0) {
                        return;
                    }
                    this.builder.durability(Math.max(this.builder.getDurability() - amount, 0));
                    hasChanges = true;
                }
                hasChanges = true;
                break;
            }
            case 30: {
                this.builder.unbreakable(!this.builder.isUnbreakable());
                hasChanges = true;
                break;
            }
            case 32: {
                if (event.isLeftClick()) {
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.Pattern_Add_Enchants, "/fusion-editor <enchantment> [level]");
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.builder.getEnchants().isEmpty()) {
                    return;
                }
                Enchantment lastEnchantment = (Enchantment)new ArrayList(this.builder.getEnchants().keySet()).get(this.builder.getEnchants().size() - 1);
                this.builder.unEnchant(lastEnchantment);
                hasChanges = true;
                break;
            }
            case 33: {
                if (event.isLeftClick()) {
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.Pattern_Add_Flags, "/fusion-editor <flag>");
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.builder.getFlags().isEmpty()) {
                    return;
                }
                this.builder.getFlags().remove(this.builder.getFlags().get(this.builder.getFlags().size() - 1));
                hasChanges = true;
                break;
            }
            case 44: {
                this.getParentEditor().open(player);
                return;
            }
        }
        if (hasChanges) {
            this.reload(true);
        }
    }

    public void reload(boolean open) {
        if (this.table != null) {
            if (this.isCategoryPattern) {
                this.table.getCatPattern().getItems().put(Character.valueOf(this.c), this.builder.build());
            } else {
                this.table.getRecipePattern().getItems().put(Character.valueOf(this.c), this.builder.build());
            }
        } else {
            this.browseEditor.getBrowsePattern().getItems().put(Character.valueOf(this.c), this.builder.build());
        }
        this.setIcons(EditorRegistry.getPatternItemEditorCfg().getSubIcons(this.c, this.builder, this.pattern.getCommands(this.c)));
        this.initialize();
        if (open) {
            this.open(this.player);
        }
    }

    public void addCommand(DelayedCommand command) {
        this.pattern.getCommands(this.c).add(command);
    }

    @Generated
    public ItemBuilder getBuilder() {
        return this.builder;
    }
}

