/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.data.recipes;

import java.util.LinkedHashMap;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.fusion.cfg.hooks.divinity.DivinityRecipeMeta;
import studio.magemonkey.fusion.data.recipes.RecipeItem;

public class RecipeCustomItem
implements RecipeItem {
    private final ItemType item;
    private final ItemBuilder builder;
    private final DivinityRecipeMeta meta;
    private final int amount;
    private final boolean simple;

    public RecipeCustomItem(@NotNull ItemType item, int amount, boolean simple) {
        this.item = item;
        this.builder = null;
        this.meta = null;
        this.amount = amount;
        this.simple = simple;
    }

    public RecipeCustomItem(@NotNull ItemBuilder item, int amount, boolean simple) {
        this.item = null;
        this.builder = item;
        this.meta = null;
        this.amount = amount;
        this.simple = simple;
    }

    public RecipeCustomItem(@NotNull DivinityRecipeMeta meta) {
        this.item = null;
        this.builder = null;
        this.meta = meta;
        this.amount = meta.getAmount();
        this.simple = false;
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack clone = null;
        clone = this.item != null ? this.item.create() : (this.builder != null ? this.builder.build() : this.meta.generateItem());
        clone.setAmount(clone.getAmount() * this.amount);
        return clone;
    }

    @Override
    public Object toConfig() {
        ItemMeta itemMeta;
        ItemStack it = null;
        it = this.item != null ? this.item.create() : (this.builder != null ? this.builder.build() : this.meta.generateItem());
        if (this.simple) {
            return "@ " + it.getType().name() + ":" + it.getDurability() + (String)(this.amount != 0 ? ":" + this.amount : "");
        }
        ItemBuilder builder = ItemBuilder.newItem((ItemStack)it);
        if (it.getType() == Material.ENCHANTED_BOOK && (itemMeta = it.getItemMeta()) instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta storage = (EnchantmentStorageMeta)itemMeta;
            builder.clearEnchants();
            LinkedHashMap enchants = new LinkedHashMap(storage.getStoredEnchants());
            builder.enchant(enchants);
        }
        return builder.serialize();
    }

    @Generated
    public String toString() {
        return "RecipeCustomItem(item=" + String.valueOf(this.item) + ", builder=" + String.valueOf(this.builder) + ", meta=" + String.valueOf(this.meta) + ", amount=" + this.getAmount() + ", simple=" + this.simple + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeCustomItem)) {
            return false;
        }
        RecipeCustomItem other = (RecipeCustomItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        if (this.simple != other.simple) {
            return false;
        }
        ItemType this$item = this.item;
        ItemType other$item = other.item;
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        ItemBuilder this$builder = this.builder;
        ItemBuilder other$builder = other.builder;
        if (this$builder == null ? other$builder != null : !this$builder.equals(other$builder)) {
            return false;
        }
        DivinityRecipeMeta this$meta = this.meta;
        DivinityRecipeMeta other$meta = other.meta;
        return !(this$meta == null ? other$meta != null : !this$meta.equals(other$meta));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RecipeCustomItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAmount();
        result = result * 59 + (this.simple ? 79 : 97);
        ItemType $item = this.item;
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        ItemBuilder $builder = this.builder;
        result = result * 59 + ($builder == null ? 43 : $builder.hashCode());
        DivinityRecipeMeta $meta = this.meta;
        result = result * 59 + ($meta == null ? 43 : $meta.hashCode());
        return result;
    }

    @Override
    @Generated
    public int getAmount() {
        return this.amount;
    }
}

