/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.data.recipes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.util.DeserializationWorker;
import studio.magemonkey.codex.util.SerializationBuilder;
import studio.magemonkey.fusion.cfg.Cfg;
import studio.magemonkey.fusion.cfg.hooks.divinity.DivinityRecipeMeta;
import studio.magemonkey.fusion.data.player.FusionPlayer;
import studio.magemonkey.fusion.data.player.PlayerLoader;
import studio.magemonkey.fusion.data.professions.ProfessionConditions;
import studio.magemonkey.fusion.data.professions.ProfessionResults;
import studio.magemonkey.fusion.data.professions.ProfessionSettings;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.data.recipes.RecipeItem;
import studio.magemonkey.fusion.util.Utils;

public class Recipe
implements ConfigurationSerializable {
    private final CraftingTable table;
    private String name;
    private int craftingTime;
    private int craftingLimit;
    private int craftingLimitCooldown = -1;
    private String category;
    private final ProfessionResults results;
    private final ProfessionConditions conditions;
    private final ProfessionSettings settings;
    private DivinityRecipeMeta divinityRecipeMeta;

    public Recipe(CraftingTable table, Map<String, Object> map) {
        this.table = table;
        DeserializationWorker dw = DeserializationWorker.start(map);
        this.name = dw.getString("name");
        this.category = dw.getString("category");
        this.craftingTime = dw.getInt("craftingTime");
        this.craftingLimit = dw.getInt("craftingLimit");
        this.craftingLimitCooldown = dw.getInt("craftingLimitCooldown");
        this.results = new ProfessionResults(this.name, dw);
        this.conditions = new ProfessionConditions(this.name, dw);
        this.settings = new ProfessionSettings(this.name, dw);
    }

    public Recipe(CraftingTable table, Map<String, Object> map, DivinityRecipeMeta meta) {
        this.table = table;
        DeserializationWorker dw = DeserializationWorker.start(map);
        this.name = dw.getString("name");
        this.category = dw.getString("category");
        this.craftingTime = dw.getInt("craftingTime");
        this.craftingLimit = dw.getInt("craftingLimit");
        this.craftingLimitCooldown = dw.getInt("craftingLimitCooldown");
        this.results = new ProfessionResults(this.name, dw);
        this.conditions = new ProfessionConditions(this.name, dw);
        this.settings = new ProfessionSettings(this.name, dw);
        if (meta != null) {
            this.divinityRecipeMeta = meta;
            this.settings.setRecipeItem(RecipeItem.fromDivinityRecipeMeta(meta));
        }
    }

    public Recipe(CraftingTable table, String name, String category, int craftingTime, int craftingLimit, int craftingLimitCooldown, ProfessionResults results, ProfessionConditions conditions, ProfessionSettings settings, DivinityRecipeMeta meta) {
        this.table = table;
        this.name = name;
        this.category = category;
        this.craftingTime = craftingTime;
        this.craftingLimit = craftingLimit;
        this.craftingLimitCooldown = craftingLimitCooldown;
        this.results = results;
        this.conditions = conditions;
        this.settings = settings;
        if (meta != null) {
            this.divinityRecipeMeta = meta;
            this.settings.setRecipeItem(RecipeItem.fromDivinityRecipeMeta(meta));
        }
    }

    public static List<Pair<ItemStack, Integer>> getItems(Collection<ItemStack> items) {
        ArrayList<Pair<ItemStack, Integer>> eqItems = new ArrayList<Pair<ItemStack, Integer>>(20);
        for (ItemStack item : items) {
            ItemStack finalItem = item.clone();
            finalItem.setAmount(1);
            int amount = item.getAmount();
            Pair pair = eqItems.stream().filter(p -> ((ItemStack)p.getLeft()).isSimilar(finalItem)).findFirst().orElse(null);
            if (pair != null) {
                eqItems.remove(pair);
                eqItems.add((Pair<ItemStack, Integer>)Pair.of((Object)((ItemStack)pair.getLeft()), (Object)((Integer)pair.getRight() + amount)));
                continue;
            }
            eqItems.add((Pair<ItemStack, Integer>)Pair.of((Object)finalItem, (Object)amount));
        }
        return eqItems;
    }

    public static List<Pair<ItemStack, Integer>> getPattern(Collection<RecipeItem> items) {
        ArrayList<Pair<ItemStack, Integer>> localPattern = new ArrayList<Pair<ItemStack, Integer>>(20);
        for (RecipeItem recipeItem : items) {
            ItemStack item = recipeItem.getItemStack();
            item.setAmount(1);
            int amount = recipeItem.getAmount();
            Pair pair = localPattern.stream().filter(p -> ((ItemStack)p.getLeft()).isSimilar(item)).findFirst().orElse(null);
            if (pair != null) {
                localPattern.remove(pair);
                localPattern.add((Pair<ItemStack, Integer>)Pair.of((Object)((ItemStack)pair.getLeft()), (Object)((Integer)pair.getRight() + amount)));
                continue;
            }
            localPattern.add((Pair<ItemStack, Integer>)Pair.of((Object)item, (Object)amount));
        }
        return localPattern;
    }

    public boolean isValid(Collection<ItemStack> items, Player p, CraftingTable craftingTable) {
        if (items.isEmpty()) {
            return false;
        }
        if (p != null) {
            if (!Utils.hasCraftingPermission((Permissible)p, this.getName())) {
                return false;
            }
            if (this.table.getLevelFunction().getLevel((OfflinePlayer)p) < this.conditions.getProfessionLevel()) {
                return false;
            }
            if (!this.conditions.isValid(PlayerLoader.getPlayer(p))) {
                return false;
            }
        }
        List<Pair<ItemStack, Integer>> eqItems = Recipe.getItems(items);
        List<Pair<ItemStack, Integer>> localPattern = Recipe.getPattern(this.conditions.getRequiredItems());
        Iterator<Pair<ItemStack, Integer>> iterator = localPattern.iterator();
        while (iterator.hasNext()) {
            int rest;
            Pair<ItemStack, Integer> patternEntry = iterator.next();
            int eqAmount = eqItems.stream().filter(e -> ((ItemStack)e.getLeft()).isSimilar((ItemStack)patternEntry.getKey())).mapToInt(Pair::getRight).findFirst().orElse(-1);
            if (eqAmount == -1) {
                return false;
            }
            ItemStack eqEntry = (ItemStack)patternEntry.getKey();
            int patternAmount = (Integer)patternEntry.getValue();
            if (eqAmount < patternAmount) {
                return false;
            }
            if (eqAmount == patternAmount) {
                eqItems.remove(patternEntry);
            }
            if ((rest = eqAmount - patternAmount) > 0) {
                eqItems.add((Pair<ItemStack, Integer>)Pair.of((Object)eqEntry, (Object)rest));
            }
            iterator.remove();
        }
        return localPattern.isEmpty();
    }

    public List<ItemStack> getItemsToTake() {
        return this.conditions.getRequiredItems().stream().map(RecipeItem::getItemStack).collect(Collectors.toList());
    }

    public double getMoneyCost() {
        return this.conditions.getMoneyCost();
    }

    public int getExpCost() {
        return this.conditions.getExpCost();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("name", (Object)this.name).append("costs.money", this.conditions.getMoneyCost()).append("costs.experience", this.conditions.getExpCost()).append("costs.items", this.conditions.getRequiredItemNames()).append("results.item", (Object)this.getSettings().getRecipeItem()).append("results.professionExp", this.getResults().getProfessionExp()).append("results.vanillaExp", this.getResults().getVanillaExp()).append("results.commands", this.getResults().getCommands()).append("craftingTime", this.craftingTime).append("craftingLimit", this.craftingLimit).append("craftingLimitCooldown", this.craftingLimitCooldown).toString();
    }

    @NotNull
    public Map<String, Object> serialize() {
        SerializationBuilder builder = SerializationBuilder.start((int)6).append("name", (Object)this.name).append("craftingTime", (Object)this.craftingTime).append("craftingLimit", (Object)this.craftingLimit).append("craftingLimitCooldown", (Object)this.craftingLimitCooldown);
        if (this.category != null) {
            builder.append("category", (Object)this.category);
        }
        for (Map.Entry<String, Object> entry : this.results.serialize().entrySet()) {
            builder.append(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.conditions.serialize().entrySet()) {
            builder.append(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.settings.serialize().entrySet()) {
            builder.append(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    public static Recipe copy(Recipe recipe) {
        return new Recipe(recipe.getTable(), recipe.getName(), recipe.getCategory(), recipe.getCraftingTime(), recipe.getCraftingLimit(), recipe.getCraftingLimitCooldown(), ProfessionResults.copy(recipe.getResults()), ProfessionConditions.copy(recipe.getConditions()), ProfessionSettings.copy(recipe.getSettings()), recipe.getDivinityRecipeMeta());
    }

    public boolean isHidden(Player player) {
        boolean isHidden = false;
        if (this.conditions.getPermission() != null) {
            if (Cfg.hideRecipesNoPermission && !player.hasPermission(this.conditions.getPermission())) {
                isHidden = true;
                if (this.settings.getHideNoPermission() != null) {
                    isHidden = this.settings.getHideNoPermission();
                }
            } else if (!Utils.hasCraftingPermission((Permissible)player, this.getName()) && this.settings.getHideNoPermission() != null) {
                isHidden = this.settings.getHideNoPermission();
            }
            if (isHidden) {
                return true;
            }
        }
        FusionPlayer fusionPlayer = PlayerLoader.getPlayer(player);
        if (Cfg.hideRecipesLimitReached && fusionPlayer.hasRecipeLimitReached(this)) {
            isHidden = true;
            if (this.settings.getHideRecipeLimitReached() != null) {
                isHidden = this.settings.getHideRecipeLimitReached();
            }
        } else if (fusionPlayer.hasRecipeLimitReached(this) && this.settings.getHideRecipeLimitReached() != null) {
            isHidden = this.settings.getHideRecipeLimitReached();
        }
        return isHidden;
    }

    public String getRecipePath() {
        String recipeName = this.name;
        if (recipeName.contains("::")) {
            recipeName = recipeName.split("::")[0];
        }
        return this.table.getName() + "." + this.category + "." + recipeName;
    }

    public void appendDivinityRecipeMeta(DivinityRecipeMeta meta) {
        this.divinityRecipeMeta = meta;
        this.settings.setRecipeItem(RecipeItem.fromDivinityRecipeMeta(meta));
    }

    @Generated
    public CraftingTable getTable() {
        return this.table;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getCraftingTime() {
        return this.craftingTime;
    }

    @Generated
    public int getCraftingLimit() {
        return this.craftingLimit;
    }

    @Generated
    public int getCraftingLimitCooldown() {
        return this.craftingLimitCooldown;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public ProfessionResults getResults() {
        return this.results;
    }

    @Generated
    public ProfessionConditions getConditions() {
        return this.conditions;
    }

    @Generated
    public ProfessionSettings getSettings() {
        return this.settings;
    }

    @Generated
    public DivinityRecipeMeta getDivinityRecipeMeta() {
        return this.divinityRecipeMeta;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Recipe)) {
            return false;
        }
        Recipe other = (Recipe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCraftingTime() != other.getCraftingTime()) {
            return false;
        }
        if (this.getCraftingLimit() != other.getCraftingLimit()) {
            return false;
        }
        if (this.getCraftingLimitCooldown() != other.getCraftingLimitCooldown()) {
            return false;
        }
        CraftingTable this$table = this.getTable();
        CraftingTable other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        ProfessionResults this$results = this.getResults();
        ProfessionResults other$results = other.getResults();
        if (this$results == null ? other$results != null : !this$results.equals(other$results)) {
            return false;
        }
        ProfessionConditions this$conditions = this.getConditions();
        ProfessionConditions other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !this$conditions.equals(other$conditions)) {
            return false;
        }
        ProfessionSettings this$settings = this.getSettings();
        ProfessionSettings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) {
            return false;
        }
        DivinityRecipeMeta this$divinityRecipeMeta = this.getDivinityRecipeMeta();
        DivinityRecipeMeta other$divinityRecipeMeta = other.getDivinityRecipeMeta();
        return !(this$divinityRecipeMeta == null ? other$divinityRecipeMeta != null : !this$divinityRecipeMeta.equals(other$divinityRecipeMeta));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Recipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCraftingTime();
        result = result * 59 + this.getCraftingLimit();
        result = result * 59 + this.getCraftingLimitCooldown();
        CraftingTable $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        ProfessionResults $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : $results.hashCode());
        ProfessionConditions $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : $conditions.hashCode());
        ProfessionSettings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        DivinityRecipeMeta $divinityRecipeMeta = this.getDivinityRecipeMeta();
        result = result * 59 + ($divinityRecipeMeta == null ? 43 : $divinityRecipeMeta.hashCode());
        return result;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setCraftingTime(int craftingTime) {
        this.craftingTime = craftingTime;
    }

    @Generated
    public void setCraftingLimit(int craftingLimit) {
        this.craftingLimit = craftingLimit;
    }

    @Generated
    public void setCraftingLimitCooldown(int craftingLimitCooldown) {
        this.craftingLimitCooldown = craftingLimitCooldown;
    }

    @Generated
    public void setCategory(String category) {
        this.category = category;
    }

    @Generated
    public void setDivinityRecipeMeta(DivinityRecipeMeta divinityRecipeMeta) {
        this.divinityRecipeMeta = divinityRecipeMeta;
    }
}

