/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.data.recipes;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.codex.api.items.exception.MissingItemException;
import studio.magemonkey.codex.api.items.exception.MissingProviderException;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.codex.util.DeserializationWorker;
import studio.magemonkey.codex.util.SerializationBuilder;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.ProfessionLevelCfg;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.cfg.hooks.ItemGenEntry;
import studio.magemonkey.fusion.cfg.hooks.divinity.DivinityRecipeMeta;
import studio.magemonkey.fusion.cfg.hooks.divinity.DivinityService;
import studio.magemonkey.fusion.data.professions.pattern.Category;
import studio.magemonkey.fusion.data.professions.pattern.InventoryPattern;
import studio.magemonkey.fusion.data.recipes.Recipe;

public class CraftingTable
implements ConfigurationSerializable {
    private String name;
    private String inventoryName;
    private InventoryPattern recipePattern;
    private InventoryPattern catPattern;
    private ItemStack fillItem;
    private Map<String, Recipe> recipes;
    private ItemType iconItem;
    private boolean useCategories = true;
    private LinkedHashMap<String, Category> categories = new LinkedHashMap();
    private ProfessionLevelCfg levelFunction;
    private int masteryUnlock;
    private int masteryFee;
    private int maxLevel = -1;
    private static Pattern levelPattern = Pattern.compile(".*~level:(\\d+).*");
    private static Pattern materialPattern = Pattern.compile(".*~material:(\\w+).*");

    public CraftingTable(String name, String inventoryName, ItemType iconItem, InventoryPattern recipePattern, InventoryPattern catPattern, boolean useCategories, ItemStack fillItem, int masteryUnlock, int masteryFee, Map<String, Recipe> recipes, Map<String, Category> categories) {
        this.name = name;
        this.inventoryName = inventoryName;
        this.iconItem = iconItem;
        this.recipePattern = recipePattern;
        this.catPattern = catPattern;
        this.useCategories = useCategories;
        this.recipes = recipes;
        this.fillItem = fillItem;
        this.masteryUnlock = masteryUnlock;
        this.masteryFee = masteryFee;
        this.categories = new LinkedHashMap<String, Category>(categories);
    }

    public CraftingTable(String name, String inventoryName, ItemType iconItem, InventoryPattern recipePattern, ItemStack fillItem, int masteryUnlock, int masteryFee) {
        this.name = name;
        this.inventoryName = inventoryName;
        this.iconItem = iconItem;
        this.recipePattern = recipePattern;
        this.catPattern = recipePattern;
        this.recipes = new LinkedHashMap<String, Recipe>(5);
        this.fillItem = fillItem;
        this.masteryUnlock = masteryUnlock;
        this.masteryFee = masteryFee;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CraftingTable(Map<String, Object> map) throws MissingProviderException, MissingItemException {
        long start = System.currentTimeMillis();
        this.recipes = new LinkedHashMap<String, Recipe>(5);
        DeserializationWorker dw = DeserializationWorker.start(map);
        this.name = dw.getString("name");
        this.inventoryName = dw.getString("inventoryName");
        this.recipePattern = new InventoryPattern(dw.getSection("recipePattern"));
        this.catPattern = dw.getSection("categoryPattern") != null && dw.getSection("categoryPattern").containsKey("pattern") ? new InventoryPattern(dw.getSection("categoryPattern")) : this.recipePattern;
        this.masteryUnlock = dw.getInt("masteryUnlock");
        this.masteryFee = dw.getInt("masteryFee");
        this.maxLevel = dw.getInt("maxLevel", -1);
        this.useCategories = dw.getBoolean("useCategories", true);
        this.iconItem = CodexEngine.get().getItemManager().getItemType(dw.getString("icon"));
        this.fillItem = dw.getSection("recipePattern.items.fillItem") != null ? new ItemBuilder(dw.getSection("recipePattern.items.fillItem")).build() : new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ArrayList categoriesList = new ArrayList();
        dw.deserializeCollection(categoriesList, "categories", Category.class);
        categoriesList.stream().filter(c -> c.getIconItem() != null).forEach(c -> {
            if (c.getPattern() == null) {
                c.setPattern(this.recipePattern);
            }
            this.categories.put(c.getName(), (Category)c);
        });
        List recipesSection = dw.getList("recipes", new ArrayList(2));
        long longest = 0L;
        String longestName = null;
        for (Map recipeData : recipesSection) {
            long rStart = System.currentTimeMillis();
            try {
                String categoryStr;
                Category category;
                Object delta;
                Map settings = (Map)recipeData.get("settings");
                Map iconSettings = (Map)settings.get("icon");
                String itemResult = (String)iconSettings.get("item");
                if (itemResult.startsWith("DIVINITY_item_generator")) {
                    this.buildDivinityResultItem(recipeData, itemResult);
                    continue;
                }
                Recipe recipe = new Recipe(this, recipeData);
                this.recipes.put(recipe.getName(), recipe);
                if (!recipeData.containsKey("category") || !((delta = recipeData.get("category")) instanceof String) || (category = this.categories.get(categoryStr = (String)delta)) == null) continue;
                category.getRecipes().add(recipe);
            }
            catch (Exception e) {
                Fusion.getInstance().error("Exception when reading config, Invalid entry in config of " + this.name + " crafting table. Value: " + String.valueOf(recipeData));
                e.printStackTrace();
            }
            finally {
                long rEnd = System.currentTimeMillis();
                long delta = rEnd - rStart;
                if (delta <= longest) continue;
                longest = delta;
                longestName = (String)recipeData.get("name");
            }
        }
        long end = System.currentTimeMillis();
        Fusion.getInstance().getLogger().info("Loaded " + this.recipes.size() + " recipes for " + this.name + " in " + (end - start) + "ms Longest recipe: " + longestName + " (" + longest + "ms)");
    }

    private void buildDivinityResultItem(Map<?, ?> recipeData, String itemResult) {
        Object obj;
        ItemGenEntry entry;
        String[] itemArgs;
        Matcher materialMatcher;
        int level = -1;
        int amount = 1;
        ItemType type = null;
        Matcher levelMatcher = levelPattern.matcher(itemResult);
        if (levelMatcher.matches()) {
            try {
                level = Integer.parseInt(levelMatcher.group(1));
            }
            catch (NumberFormatException ignored) {
                Fusion.getInstance().getLogger().warning("Failed to get level for Divinity item " + itemResult + ". Using -1 instead.");
            }
            itemResult = itemResult.replace("~level:" + levelMatcher.group(1), "");
        }
        if ((materialMatcher = materialPattern.matcher(itemResult)).matches()) {
            try {
                type = CodexEngine.get().getItemManager().getItemType(materialMatcher.group(1));
            }
            catch (MissingItemException | MissingProviderException ignored) {
                Fusion.getInstance().getLogger().warning("Failed to get material item for Divinity item " + itemResult + ". Using the item's configuration instead.");
            }
            itemResult = itemResult.replace("~material:" + materialMatcher.group(1), "");
        }
        if ((itemArgs = itemResult.split(":", 3)).length < 2) {
            Fusion.getInstance().error("Invalid entry in config of " + this.name + " (ItemGenerator entry) in crafting table. Value: " + String.valueOf(recipeData));
            return;
        }
        String itemId = itemArgs[1];
        if (!DivinityService.isCached(itemId) && !DivinityService.cache(itemId, null)) {
            Fusion.getInstance().error("Invalid entry in config of " + this.name + " (ItemGenerator entry) in crafting table. Value: " + String.valueOf(recipeData));
            return;
        }
        if (itemArgs.length >= 3) {
            amount = Integer.parseInt(itemArgs[2]);
        }
        if ((entry = DivinityService.itemGenResults.get(itemId)) == null) {
            Fusion.getInstance().error("Invalid entry in config of " + this.name + " (ItemGenerator entry) in crafting table. Value: " + String.valueOf(recipeData));
            return;
        }
        Map<ItemType, Set<String>> names = entry.loadNames(type, level);
        Category category = null;
        if (recipeData.containsKey("category") && (obj = recipeData.get("category")) instanceof String) {
            String categoryStr = (String)obj;
            category = this.categories.get(categoryStr);
        }
        String recipeName = (String)recipeData.get("name");
        int i = 0;
        for (Map.Entry<ItemType, Set<String>> nameEntry : names.entrySet()) {
            for (String name : nameEntry.getValue()) {
                DivinityRecipeMeta meta = new DivinityRecipeMeta(recipeName, entry, level, amount, nameEntry.getKey(), name);
                Recipe recipe = new Recipe(this, recipeData, meta);
                recipe.setName(recipe.getName() + "::" + i);
                this.recipes.put(recipe.getName(), recipe);
                if (category != null) {
                    category.getRecipes().add(recipe);
                }
                ++i;
            }
        }
    }

    public List<String> getCategoryList() {
        return new ArrayList<String>(this.categories.keySet());
    }

    public Recipe getRecipe(String str) {
        return this.recipes.get(str);
    }

    public void addRecipe(Recipe recipe) {
        this.recipes.put(recipe.getName(), recipe);
    }

    public boolean getUseCategories() {
        return this.useCategories;
    }

    public Collection<Recipe> getRecipes(Collection<ItemStack> items, Player p) {
        if (items.isEmpty()) {
            return new ArrayList<Recipe>(this.recipes.values());
        }
        return ((Stream)this.recipes.values().stream().unordered()).filter(r -> r.isValid(items, p, this)).collect(Collectors.toList());
    }

    public Category getCategory(String name) {
        return this.categories.get(name);
    }

    public void updateCategoryOrder() {
        LinkedHashMap newCategories = new LinkedHashMap();
        this.categories.values().stream().sorted(Comparator.comparingInt(Category::getOrder)).forEach(c -> newCategories.put(c.getName(), c));
        this.categories = newCategories;
    }

    public void moveEntry(Recipe recipe, int offset) {
        if (offset != -1 && offset != 1) {
            throw new IllegalArgumentException("Offset must be -1 or 1");
        }
        ArrayList<Map.Entry<String, Recipe>> entries = new ArrayList<Map.Entry<String, Recipe>>(this.recipes.entrySet());
        int index = -1;
        for (int i = 0; i < entries.size(); ++i) {
            if (!((String)((Map.Entry)entries.get(i)).getKey()).equals(recipe.getName())) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        int newIndex = index + offset;
        if (newIndex < 0 || newIndex >= entries.size()) {
            return;
        }
        Map.Entry entry = (Map.Entry)entries.remove(index);
        entries.add(newIndex, entry);
        this.recipes.clear();
        for (Map.Entry entry2 : entries) {
            this.recipes.put((String)entry2.getKey(), (Recipe)entry2.getValue());
        }
    }

    @NotNull
    public Map<String, Object> serialize() {
        return SerializationBuilder.start((int)4).append("name", (Object)this.name).append("icon", (Object)this.iconItem.getNamespacedID()).append("recipePattern", this.recipePattern.serialize()).append("categoryPattern", this.catPattern != null ? this.catPattern.serialize() : null).append("inventoryName", (Object)this.inventoryName).append("masteryUnlock", (Object)this.masteryUnlock).append("masteryFee", (Object)this.masteryFee).append("maxLevel", (Object)this.maxLevel).append("useCategories", (Object)this.useCategories).append("recipes", this.recipes.values().stream().map(Recipe::serialize).collect(Collectors.toList())).build();
    }

    public void save(Runnable runnable) {
        FileConfiguration config = ProfessionsCfg.getCfgs().get(this.name);
        File file = ProfessionsCfg.getFiles().get(this.name);
        Map<String, Object> map = this.serialize();
        Map recipePatterntemsMap = (Map)map.get("recipePattern");
        Map catPatterntemsMap = (Map)map.get("categoryPattern");
        recipePatterntemsMap.remove("f");
        recipePatterntemsMap.remove("q");
        recipePatterntemsMap.remove("o");
        if (this.catPattern != null) {
            catPatterntemsMap.remove("f");
            catPatterntemsMap.remove("q");
            catPatterntemsMap.remove("o");
        }
        config.set("name", map.get("name"));
        config.set("inventoryName", map.get("inventoryName"));
        config.set("icon", map.get("icon"));
        config.set("recipePattern", (Object)recipePatterntemsMap);
        config.set("categoryPattern", (Object)catPatterntemsMap);
        config.set("masteryUnlock", map.get("masteryUnlock"));
        config.set("masteryFee", map.get("masteryFee"));
        config.set("maxLevel", map.get("maxLevel"));
        config.set("useCategories", map.get("useCategories"));
        config.set("recipes", map.get("recipes"));
        try {
            config.save(file);
            if (runnable != null) {
                Bukkit.getScheduler().runTaskLater((Plugin)Fusion.getInstance(), runnable, 1L);
            }
        }
        catch (IOException e) {
            Fusion.getInstance().getLogger().warning("Can't load crafting table: " + e.getMessage());
        }
    }

    public static CraftingTable copy(CraftingTable source) {
        LinkedHashMap<String, Recipe> recipes = new LinkedHashMap<String, Recipe>();
        for (Recipe recipe : source.getRecipes().values()) {
            recipes.put(recipe.getName(), Recipe.copy(recipe));
        }
        LinkedHashMap<String, Category> categories = new LinkedHashMap<String, Category>();
        for (Category category : source.getCategories().values()) {
            categories.put(category.getName(), Category.copy(category));
        }
        return new CraftingTable(source.getName(), source.getInventoryName(), source.getIconItem(), InventoryPattern.copy(source.getRecipePattern()), InventoryPattern.copy(source.getCatPattern()), source.getUseCategories(), source.getFillItem(), source.getMasteryUnlock(), source.getMasteryFee(), recipes, categories);
    }

    public void cleanUpRecipesForEditor() {
        LinkedHashMap<String, Recipe> cleanedRecipes = new LinkedHashMap<String, Recipe>();
        HashSet<String> uniqueRecipes = new HashSet<String>();
        for (Recipe recipe : this.recipes.values()) {
            if (recipe.getName().contains("::")) {
                String recipeName = recipe.getName().split("::")[0];
                if (!uniqueRecipes.add(recipeName)) continue;
                Recipe copiedRecipe = Recipe.copy(recipe);
                copiedRecipe.setName(recipeName);
                cleanedRecipes.put(recipeName, copiedRecipe);
                continue;
            }
            cleanedRecipes.put(recipe.getName(), recipe);
        }
        this.recipes = cleanedRecipes;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getInventoryName() {
        return this.inventoryName;
    }

    @Generated
    public InventoryPattern getRecipePattern() {
        return this.recipePattern;
    }

    @Generated
    public InventoryPattern getCatPattern() {
        return this.catPattern;
    }

    @Generated
    public ItemStack getFillItem() {
        return this.fillItem;
    }

    @Generated
    public Map<String, Recipe> getRecipes() {
        return this.recipes;
    }

    @Generated
    public ItemType getIconItem() {
        return this.iconItem;
    }

    @Generated
    public ProfessionLevelCfg getLevelFunction() {
        return this.levelFunction;
    }

    @Generated
    public int getMasteryUnlock() {
        return this.masteryUnlock;
    }

    @Generated
    public int getMasteryFee() {
        return this.masteryFee;
    }

    @Generated
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setInventoryName(String inventoryName) {
        this.inventoryName = inventoryName;
    }

    @Generated
    public void setRecipePattern(InventoryPattern recipePattern) {
        this.recipePattern = recipePattern;
    }

    @Generated
    public void setCatPattern(InventoryPattern catPattern) {
        this.catPattern = catPattern;
    }

    @Generated
    public void setFillItem(ItemStack fillItem) {
        this.fillItem = fillItem;
    }

    @Generated
    public void setRecipes(Map<String, Recipe> recipes) {
        this.recipes = recipes;
    }

    @Generated
    public void setIconItem(ItemType iconItem) {
        this.iconItem = iconItem;
    }

    @Generated
    public void setUseCategories(boolean useCategories) {
        this.useCategories = useCategories;
    }

    @Generated
    public void setCategories(LinkedHashMap<String, Category> categories) {
        this.categories = categories;
    }

    @Generated
    public void setLevelFunction(ProfessionLevelCfg levelFunction) {
        this.levelFunction = levelFunction;
    }

    @Generated
    public void setMasteryUnlock(int masteryUnlock) {
        this.masteryUnlock = masteryUnlock;
    }

    @Generated
    public void setMasteryFee(int masteryFee) {
        this.masteryFee = masteryFee;
    }

    @Generated
    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    @Generated
    public LinkedHashMap<String, Category> getCategories() {
        return this.categories;
    }
}

