/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.data.queue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.api.FusionAPI;
import studio.magemonkey.fusion.cfg.Cfg;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.cfg.sql.SQLManager;
import studio.magemonkey.fusion.data.professions.pattern.Category;
import studio.magemonkey.fusion.data.queue.QueueItem;
import studio.magemonkey.fusion.data.recipes.Recipe;
import studio.magemonkey.fusion.data.recipes.RecipeItem;

public class CraftingQueue {
    private final Player player;
    private final String profession;
    private final Category category;
    private final List<QueueItem> queue = new ArrayList<QueueItem>();
    private final HashMap<Integer, QueueItem> queuedItems;
    private final BukkitTask queueTask;
    private int visualRemainingTotalTime = 0;

    public CraftingQueue(final Player player, String profession, Category category) {
        this.player = player;
        this.profession = profession;
        this.category = category;
        this.queuedItems = new HashMap(20);
        List<QueueItem> loaded = SQLManager.queues().getQueueItems(player.getUniqueId(), profession, category);
        this.queue.addAll(loaded);
        if (Cfg.updateQueueOffline && !this.queue.isEmpty()) {
            long now = System.currentTimeMillis();
            QueueItem current = this.queue.stream().filter(item -> !item.isDone()).findFirst().orElse(null);
            if (current != null) {
                int offlineSeconds = (int)((now - current.getTimestamp()) / 1000L);
                for (QueueItem item2 : this.queue) {
                    if (offlineSeconds <= 0) break;
                    if (item2.isDone()) continue;
                    int remaining = item2.getRecipe().getCraftingTime() - item2.getSavedSeconds();
                    int apply = Math.min(offlineSeconds, remaining);
                    item2.progressOffline(apply);
                    offlineSeconds -= apply;
                }
            }
            this.queue.forEach(item -> item.setTimestamp(now));
        }
        this.queue.forEach(entry -> {
            entry.setCraftinQueue(this);
            entry.updateIcon();
        });
        this.queueTask = new BukkitRunnable(){

            public void run() {
                if (!player.isOnline()) {
                    this.cancel();
                    return;
                }
                CraftingQueue.this.visualRemainingTotalTime = 0;
                CraftingQueue.this.queue.forEach(item -> {
                    if (!item.isDone()) {
                        CraftingQueue.this.visualRemainingTotalTime += item.getRecipe().getCraftingTime() - item.getSavedSeconds();
                        item.update();
                    }
                });
            }
        }.runTaskTimer((Plugin)Fusion.getInstance(), 0L, 20L);
    }

    public void addRecipe(Recipe recipe) {
        QueueItem item = new QueueItem(-1, this.profession, this.category, recipe, System.currentTimeMillis(), 0);
        FusionAPI.getEventServices().getQueueService().addQueueItem(this.player, ProfessionsCfg.getTable(this.profession), this, item);
    }

    public void finishAllRecipes() {
        for (QueueItem item : this.queue) {
            Bukkit.getScheduler().runTaskLater((Plugin)Fusion.getInstance(), () -> this.finishRecipe(item), 1L);
        }
    }

    public void finishRecipe(QueueItem item) {
        if (item.isDone()) {
            List<RecipeItem> resultItems = item.getRecipe().getResults().getItems();
            FusionAPI.getEventServices().getQueueService().finishQueueItem(this.player, ProfessionsCfg.getTable(this.profession), this, item, resultItems);
        }
    }

    public void removeRecipe(QueueItem item, boolean refund) {
        FusionAPI.getEventServices().getQueueService().cancelQueueItem(this.player, ProfessionsCfg.getTable(this.profession), this, item, !refund, refund, refund ? item.getRecipe().getItemsToTake() : List.of());
    }

    public void cancelTask() {
        this.queueTask.cancel();
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public String getProfession() {
        return this.profession;
    }

    @Generated
    public Category getCategory() {
        return this.category;
    }

    @Generated
    public List<QueueItem> getQueue() {
        return this.queue;
    }

    @Generated
    public HashMap<Integer, QueueItem> getQueuedItems() {
        return this.queuedItems;
    }

    @Generated
    public BukkitTask getQueueTask() {
        return this.queueTask;
    }

    @Generated
    public int getVisualRemainingTotalTime() {
        return this.visualRemainingTotalTime;
    }
}

