/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.data.professions.pattern;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.api.DelayedCommand;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.codex.util.DeserializationWorker;
import studio.magemonkey.codex.util.SerializationBuilder;
import studio.magemonkey.fusion.data.recipes.RecipeItem;

public class InventoryPattern
implements ConfigurationSerializable {
    private final String[] pattern;
    private HashMap<Character, ItemStack> items;
    private final HashMap<Character, List<DelayedCommand>> commands = new HashMap();
    private final List<Character> closeOnClickSlots = new ArrayList<Character>();

    public InventoryPattern(String[] pattern, HashMap<Character, ItemStack> items) {
        this.pattern = pattern;
        this.items = items;
        this.items.put(Character.valueOf('o'), null);
    }

    public InventoryPattern(Map<String, Object> map) {
        DeserializationWorker dw = DeserializationWorker.start(map);
        List temp = dw.getStringList("pattern");
        this.pattern = temp.toArray(new String[0]);
        this.items = new HashMap();
        DeserializationWorker itemsTemp = DeserializationWorker.start((Map)dw.getSection("items", new HashMap(2)));
        for (String entry : itemsTemp.getMap().keySet()) {
            if (entry.contains(".")) continue;
            Map section = itemsTemp.getSection(entry);
            this.items.put(Character.valueOf(entry.charAt(0)), RecipeItem.fromConfig(section).getItemStack());
            if (!section.containsKey("closeonclick") || !((Boolean)section.get("closeonclick")).booleanValue()) continue;
            this.closeOnClickSlots.add(Character.valueOf(entry.charAt(0)));
        }
        if (dw.getSection("items.queue-items.-") != null) {
            this.items.put(Character.valueOf('-'), RecipeItem.fromConfig(dw.getSection("items.queue-items.-")).getItemStack());
        }
        DeserializationWorker commandsTemp = DeserializationWorker.start((Map)dw.getSection("commands", new HashMap(2)));
        for (Map.Entry entry : commandsTemp.getMap().entrySet()) {
            ArrayList<DelayedCommand> commands = new ArrayList<DelayedCommand>();
            for (Object cmd : commandsTemp.getList((String)entry.getKey())) {
                commands.add(new DelayedCommand((Map)cmd));
            }
            this.commands.put(Character.valueOf(((String)entry.getKey()).charAt(0)), commands);
        }
        this.items.put(Character.valueOf('o'), null);
    }

    public List<DelayedCommand> getCommands(char c) {
        this.commands.putIfAbsent(Character.valueOf(c), new ArrayList());
        return this.commands.get(Character.valueOf(c));
    }

    public Character getSlot(int slot) {
        if (slot / 9 >= this.pattern.length) {
            return Character.valueOf(' ');
        }
        return Character.valueOf(this.pattern[slot / 9].charAt(slot % 9));
    }

    public void replaceSlot(int slot, char c) {
        if (slot / 9 >= this.pattern.length) {
            return;
        }
        StringBuilder sb = new StringBuilder(this.pattern[slot / 9]);
        sb.setCharAt(slot % 9, c);
        this.pattern[slot / 9] = sb.toString();
    }

    public Character getCycledCharacter(char c, boolean forward) {
        List<Map.Entry<Character, ItemStack>> entries = this.getItemsAsList();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            if (entries.get(i).getKey().charValue() != c) continue;
            if (forward) {
                return entries.get((i + 1) % size).getKey();
            }
            return entries.get((i - 1 + size) % size).getKey();
        }
        return forward ? entries.get(0).getKey() : entries.get(size - 1).getKey();
    }

    public int getInventorySize() {
        return this.pattern.length * 9;
    }

    public List<Map.Entry<Character, ItemStack>> getItemsAsList() {
        return this.items.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<Character, ItemStack>((Character)e.getKey(), (ItemStack)e.getValue())).collect(Collectors.toList());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("pattern", (Object[])this.pattern).append("items", this.items).toString();
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Map> itemsMap = new LinkedHashMap<String, Map>();
        LinkedHashMap<String, Map> queueItemsMap = new LinkedHashMap<String, Map>();
        if (this.items.containsKey(Character.valueOf('f'))) {
            itemsMap.put("fillItem", new AbstractMap.SimpleEntry<Character, ItemBuilder>(Character.valueOf('f'), ItemBuilder.newItem((ItemStack)this.items.get(Character.valueOf('f')))).getValue().serialize());
        }
        if (this.items.containsKey(Character.valueOf('<'))) {
            itemsMap.put("<", new AbstractMap.SimpleEntry<Character, ItemBuilder>(Character.valueOf('<'), ItemBuilder.newItem((ItemStack)this.items.get(Character.valueOf('<')))).getValue().serialize());
        }
        if (this.items.containsKey(Character.valueOf('>'))) {
            itemsMap.put(">", new AbstractMap.SimpleEntry<Character, ItemBuilder>(Character.valueOf('>'), ItemBuilder.newItem((ItemStack)this.items.get(Character.valueOf('>')))).getValue().serialize());
        }
        if (this.items.containsKey(Character.valueOf('{'))) {
            itemsMap.put("{", new AbstractMap.SimpleEntry<Character, ItemBuilder>(Character.valueOf('{'), ItemBuilder.newItem((ItemStack)this.items.get(Character.valueOf('{')))).getValue().serialize());
        }
        if (this.items.containsKey(Character.valueOf('}'))) {
            itemsMap.put("}", new AbstractMap.SimpleEntry<Character, ItemBuilder>(Character.valueOf('}'), ItemBuilder.newItem((ItemStack)this.items.get(Character.valueOf('}')))).getValue().serialize());
        }
        block3: for (Map.Entry<Character, ItemStack> entry : this.items.entrySet()) {
            switch (entry.getKey().charValue()) {
                case '-': 
                case '<': 
                case '>': 
                case 'f': 
                case 'o': 
                case 'q': 
                case '{': 
                case '}': {
                    continue block3;
                }
            }
            itemsMap.put(entry.getKey().toString(), ItemBuilder.newItem((ItemStack)entry.getValue()).serialize());
            itemsMap.put(entry.getKey().toString(), new AbstractMap.SimpleEntry<String, ItemBuilder>(entry.getKey().toString(), ItemBuilder.newItem((ItemStack)entry.getValue())).getValue().serialize());
        }
        if (this.items.containsKey(Character.valueOf('-'))) {
            queueItemsMap.put("-", ItemBuilder.newItem((ItemStack)this.items.get(Character.valueOf('-'))).serialize());
            itemsMap.put("queue-items", queueItemsMap);
        }
        LinkedHashMap commandMap = new LinkedHashMap();
        for (Map.Entry<Character, List<DelayedCommand>> entry : this.commands.entrySet()) {
            ArrayList<Map> commands = new ArrayList<Map>();
            for (DelayedCommand cmd : entry.getValue()) {
                commands.add(cmd.serialize());
            }
            commandMap.put(entry.getKey().toString(), commands);
        }
        return SerializationBuilder.start((int)2).append("pattern", (Object)this.pattern).appendMap("commands", commandMap).append("items", itemsMap).build();
    }

    public void clear() {
        for (int i = 0; i < this.pattern.length; ++i) {
            StringBuilder sb = new StringBuilder(this.pattern[i]);
            for (int j = 0; j < sb.length(); ++j) {
                char c = sb.charAt(j);
                if (c == 'o' || c == '-' || c == '<' || c == '>' || c == '{' || c == '}' || c == 'f') continue;
                sb.setCharAt(j, 'f');
            }
            this.pattern[i] = sb.toString();
        }
    }

    public boolean isUsed(char c) {
        for (String row : this.pattern) {
            for (char ch : row.toCharArray()) {
                if (ch != c) continue;
                return true;
            }
        }
        return false;
    }

    public static InventoryPattern copy(InventoryPattern pattern) {
        if (pattern == null) {
            return null;
        }
        String[] patternCopy = new String[pattern.pattern.length];
        System.arraycopy(pattern.pattern, 0, patternCopy, 0, pattern.pattern.length);
        HashMap<Character, ItemStack> itemsCopy = new HashMap<Character, ItemStack>();
        for (Map.Entry<Character, ItemStack> item : pattern.items.entrySet()) {
            if (item.getValue() == null) continue;
            itemsCopy.put(item.getKey(), item.getValue().clone());
        }
        InventoryPattern _pattern = new InventoryPattern(patternCopy, new HashMap<Character, ItemStack>(itemsCopy));
        _pattern.commands.putAll(pattern.commands);
        _pattern.closeOnClickSlots.addAll(pattern.closeOnClickSlots);
        return _pattern;
    }

    @Generated
    public String[] getPattern() {
        return this.pattern;
    }

    @Generated
    public HashMap<Character, ItemStack> getItems() {
        return this.items;
    }

    @Generated
    public void setItems(HashMap<Character, ItemStack> items) {
        this.items = items;
    }

    @Generated
    public List<Character> getCloseOnClickSlots() {
        return this.closeOnClickSlots;
    }
}

