/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.data.professions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Color;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.api.DelayedCommand;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.codex.util.DeserializationWorker;
import studio.magemonkey.codex.util.SerializationBuilder;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.data.recipes.RecipeCustomItem;
import studio.magemonkey.fusion.data.recipes.RecipeItem;

public class ProfessionSettings
implements ConfigurationSerializable {
    private final String profession;
    private RecipeItem recipeItem;
    private String iconNamespace;
    private boolean includeOriginalLore;
    private String name;
    private int customModelData = -1;
    private List<String> lore = new ArrayList<String>();
    private boolean unbreakable;
    private Map<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
    private Set<ItemFlag> flags = new HashSet<ItemFlag>();
    private String color;
    private boolean cancelDrop;
    private List<DelayedCommand> commandsOnClick = new LinkedList<DelayedCommand>();
    private Boolean hideNoPermission;
    private Boolean hideRecipeLimitReached;

    public ProfessionSettings(String profession, Boolean hideNoPermission, Boolean hideRecipeLimitReached, String iconNamespace, boolean includeOriginalLore, String name, int customModelData, List<String> lore, boolean unbreakable, Map<Enchantment, Integer> enchantments, Set<ItemFlag> flags, String color, boolean cancelDrop, List<DelayedCommand> commandsOnClick) {
        this.profession = profession;
        this.hideNoPermission = hideNoPermission;
        this.hideRecipeLimitReached = hideRecipeLimitReached;
        this.iconNamespace = iconNamespace;
        this.includeOriginalLore = includeOriginalLore;
        this.name = name;
        this.customModelData = customModelData;
        this.lore = lore;
        this.unbreakable = unbreakable;
        this.enchantments = enchantments;
        this.flags = flags;
        this.color = color;
        this.cancelDrop = cancelDrop;
        this.commandsOnClick = commandsOnClick;
        this.generateIcon(iconNamespace);
    }

    public ProfessionSettings(String profession, ConfigurationSection config) {
        this.profession = profession;
        this.hideNoPermission = config.getBoolean("settings.hiding.hideNoPermission");
        this.hideRecipeLimitReached = config.getBoolean("settings.hiding.hideRecipeLimitReached");
        String iconNamespace = config.getString("settings.icon.item");
        this.includeOriginalLore = config.getBoolean("settings.icon.includeOriginalLore", true);
        if (config.isSet("settings.icon.optionals") && !config.getConfigurationSection("settings.icon.optionals").getKeys(false).isEmpty()) {
            List flagsList;
            this.name = config.getString("settings.icon.optionals.name");
            this.customModelData = config.getInt("settings.icon.optionals.customModelData", -1);
            this.lore = config.getStringList("settings.icon.optionals.lore");
            this.unbreakable = config.getBoolean("settings.icon.optionals.unbreakable");
            ConfigurationSection enchantmentsSection = config.getConfigurationSection("settings.icon.optionals.enchantments");
            if (enchantmentsSection != null) {
                this.enchantments = new HashMap<Enchantment, Integer>();
                for (String enchantment : enchantmentsSection.getKeys(false)) {
                    this.enchantments.put(Enchantment.getByName((String)enchantment), enchantmentsSection.getInt(enchantment));
                }
            }
            if (!(flagsList = config.getStringList("settings.icon.optionals.flags")).isEmpty()) {
                this.flags = new HashSet<ItemFlag>();
                if (flagsList.contains("*")) {
                    this.flags.addAll(Arrays.asList(ItemFlag.values()));
                } else {
                    for (String flag : flagsList) {
                        this.flags.add(ItemFlag.valueOf((String)flag));
                    }
                }
            }
            this.color = config.getString("settings.icon.optionals.color");
            this.cancelDrop = config.getBoolean("settings.icon.optionals.cancelDrop");
            this.commandsOnClick = config.getList("settings.icon.optionals.commandsOnClick", new LinkedList()).stream().map(entry -> new DelayedCommand()).collect(Collectors.toList());
        }
        this.generateIcon(iconNamespace);
    }

    public ProfessionSettings(String profession, DeserializationWorker dw) {
        this.profession = profession;
        Map settingsSection = dw.getSection("settings");
        if (settingsSection == null) {
            this.hideNoPermission = null;
            this.hideRecipeLimitReached = null;
        } else {
            Map hidingSettings = (Map)settingsSection.get("hiding");
            this.hideNoPermission = hidingSettings != null && hidingSettings.get("noPermission") != null ? Boolean.valueOf((Boolean)hidingSettings.get("noPermission")) : null;
            this.hideRecipeLimitReached = hidingSettings != null && hidingSettings.get("recipeLimitReached") != null ? Boolean.valueOf((Boolean)hidingSettings.get("recipeLimitReached")) : null;
            Map iconSettings = (Map)settingsSection.get("icon");
            if (iconSettings == null) {
                Fusion.getInstance().getLogger().warning("Icon settings not found for in " + profession + " on recipe load.");
                return;
            }
            String iconNamespace = (String)iconSettings.get("item");
            this.includeOriginalLore = iconSettings.get("includeOriginalLore") != null && (Boolean)iconSettings.get("includeOriginalLore") != false;
            Map optionalIconSettings = (Map)iconSettings.get("optionals");
            if (optionalIconSettings != null && !optionalIconSettings.isEmpty()) {
                List commands;
                if (optionalIconSettings.get("name") != null) {
                    this.name = (String)optionalIconSettings.get("name");
                }
                if (optionalIconSettings.get("customModelData") != null) {
                    this.customModelData = (Integer)optionalIconSettings.get("customModelData");
                }
                if (optionalIconSettings.get("lore") != null) {
                    this.lore = (List)optionalIconSettings.get("lore");
                }
                if (optionalIconSettings.get("unbreakable") != null) {
                    this.unbreakable = (Boolean)optionalIconSettings.get("unbreakable");
                }
                if (optionalIconSettings.get("enchantments") != null) {
                    this.enchantments = new HashMap<Enchantment, Integer>();
                    Map enchantmentsSection = (Map)optionalIconSettings.get("enchantments");
                    if (enchantmentsSection != null) {
                        for (Map.Entry enchantment : enchantmentsSection.entrySet()) {
                            this.enchantments.put(Enchantment.getByName((String)((String)enchantment.getKey()).toLowerCase()), (Integer)enchantment.getValue());
                        }
                    }
                }
                if (optionalIconSettings.get("flags") != null) {
                    this.flags = new HashSet<ItemFlag>();
                    List flagsList = (List)optionalIconSettings.get("flags");
                    if (flagsList.contains("*")) {
                        this.flags.addAll(Arrays.asList(ItemFlag.values()));
                    } else {
                        for (String flag : flagsList) {
                            this.flags.add(ItemFlag.valueOf((String)flag));
                        }
                    }
                }
                if (optionalIconSettings.get("color") != null) {
                    this.color = (String)optionalIconSettings.get("color");
                }
                if (optionalIconSettings.get("cancelDrop") != null) {
                    this.cancelDrop = (Boolean)optionalIconSettings.get("cancelDrop");
                }
                if ((commands = (List)optionalIconSettings.getOrDefault("commandsOnClick", new ArrayList())) != null) {
                    for (Map command : commands) {
                        this.commandsOnClick.add(new DelayedCommand(command));
                    }
                }
            }
            this.generateIcon(iconNamespace);
        }
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap settingsMap = new HashMap();
        HashMap<String, Boolean> hiding = new HashMap<String, Boolean>(3);
        if (this.hideNoPermission != null) {
            hiding.put("noPermission", this.hideNoPermission);
        }
        if (this.hideRecipeLimitReached != null) {
            hiding.put("recipeLimitReached", this.hideRecipeLimitReached);
        }
        if (!hiding.isEmpty()) {
            settingsMap.put("hiding", hiding);
        }
        HashMap<String, Object> iconSettings = new HashMap<String, Object>(3);
        iconSettings.put("item", this.iconNamespace);
        iconSettings.put("includeOriginalLore", this.includeOriginalLore);
        HashMap<String, Object> optionalIconSettings = new HashMap<String, Object>(10);
        if (this.name != null) {
            optionalIconSettings.put("name", this.name);
        }
        if (this.customModelData >= 0) {
            optionalIconSettings.put("customModelData", this.customModelData);
        }
        if (this.lore != null && !this.lore.isEmpty()) {
            optionalIconSettings.put("lore", this.lore);
        }
        if (this.unbreakable) {
            optionalIconSettings.put("unbreakable", this.unbreakable);
        }
        if (this.enchantments != null && !this.enchantments.isEmpty()) {
            HashMap<String, Integer> enchantmentsSection = new HashMap<String, Integer>(this.enchantments.size());
            for (Map.Entry<Enchantment, Integer> enchantment : this.enchantments.entrySet()) {
                enchantmentsSection.put(enchantment.getKey().getName(), enchantment.getValue());
            }
            optionalIconSettings.put("enchantments", enchantmentsSection);
        }
        if (this.flags != null && !this.flags.isEmpty()) {
            ArrayList<String> flagsList = new ArrayList<String>(this.flags.size());
            for (ItemFlag flag : this.flags) {
                flagsList.add(flag.name());
            }
            optionalIconSettings.put("flags", flagsList);
        }
        if (this.color != null) {
            optionalIconSettings.put("color", this.color);
        }
        if (this.cancelDrop) {
            optionalIconSettings.put("cancelDrop", this.cancelDrop);
        }
        if (this.commandsOnClick != null && !this.commandsOnClick.isEmpty()) {
            optionalIconSettings.put("commandsOnClick", new ArrayList(this.commandsOnClick.stream().map(DelayedCommand::serialize).collect(Collectors.toList())));
        }
        if (!optionalIconSettings.isEmpty()) {
            iconSettings.put("optionals", optionalIconSettings);
        }
        settingsMap.put("icon", iconSettings);
        return SerializationBuilder.start((int)4).append("settings", settingsMap).build();
    }

    public static ProfessionSettings copy(ProfessionSettings results) {
        return new ProfessionSettings(results.profession, results.hideNoPermission, results.hideRecipeLimitReached, results.iconNamespace, results.includeOriginalLore, results.name, results.customModelData, results.lore, results.unbreakable, results.enchantments, results.flags, results.color, results.cancelDrop, results.commandsOnClick);
    }

    private void generateIcon(String namespace) {
        this.iconNamespace = namespace;
        RecipeItem recipeItem = RecipeItem.fromConfig(namespace);
        ItemStack iconReference = recipeItem.getItemStack();
        if (!this.hasAnyOptionalFields()) {
            this.recipeItem = recipeItem;
        } else {
            List existingLore;
            ItemBuilder builder = ItemBuilder.newItem((ItemStack)iconReference);
            ItemMeta meta = iconReference.getItemMeta();
            if (this.name != null) {
                builder.name(this.name);
            }
            if (this.customModelData >= 0) {
                meta.setCustomModelData(Integer.valueOf(this.customModelData));
            }
            if (this.includeOriginalLore && (existingLore = meta.getLore()) != null) {
                if (this.lore == null) {
                    this.lore = new ArrayList<String>();
                }
                this.lore.addAll(0, existingLore);
            }
            if (this.lore != null) {
                builder = builder.lore(this.lore);
            }
            if (this.enchantments != null) {
                builder = builder.enchant(this.enchantments);
            }
            if (this.flags != null) {
                builder = builder.flag(this.flags.toArray(new ItemFlag[0]));
            }
            if (this.color != null && meta instanceof LeatherArmorMeta) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)meta;
                String[] colorData = this.color.split(",");
                try {
                    leatherArmorMeta.setColor(Color.fromRGB((int)Integer.parseInt(colorData[0]), (int)Integer.parseInt(colorData[1]), (int)Integer.parseInt(colorData[2])));
                }
                catch (IllegalArgumentException e) {
                    Fusion.getInstance().getLogger().warning("Invalid color data for profession icon: " + this.color + " for profession " + this.profession + ". Using white instead.");
                    leatherArmorMeta.setColor(Color.fromRGB((int)255, (int)255, (int)255));
                }
                meta = leatherArmorMeta;
            } else if (this.color != null && meta instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)meta;
                String[] colorData = this.color.split(",");
                try {
                    potionMeta.setColor(Color.fromRGB((int)Integer.parseInt(colorData[0]), (int)Integer.parseInt(colorData[1]), (int)Integer.parseInt(colorData[2])));
                }
                catch (IllegalArgumentException e) {
                    Fusion.getInstance().getLogger().warning("Invalid color data for profession icon: " + this.color + " for profession " + this.profession + ". Using white instead.");
                    potionMeta.setColor(Color.fromRGB((int)255, (int)255, (int)255));
                }
                meta = potionMeta;
            }
            builder = builder.data(meta);
            this.recipeItem = new RecipeCustomItem(builder, 1, false);
        }
    }

    private boolean hasAnyOptionalFields() {
        return this.name != null || this.customModelData >= 0 || this.lore != null && !this.lore.isEmpty() || this.enchantments != null && !this.enchantments.isEmpty() || this.flags != null && !this.flags.isEmpty() || this.color != null;
    }

    @Generated
    public String getProfession() {
        return this.profession;
    }

    @Generated
    public RecipeItem getRecipeItem() {
        return this.recipeItem;
    }

    @Generated
    public String getIconNamespace() {
        return this.iconNamespace;
    }

    @Generated
    public boolean isIncludeOriginalLore() {
        return this.includeOriginalLore;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getCustomModelData() {
        return this.customModelData;
    }

    @Generated
    public List<String> getLore() {
        return this.lore;
    }

    @Generated
    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    @Generated
    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Generated
    public Set<ItemFlag> getFlags() {
        return this.flags;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public boolean isCancelDrop() {
        return this.cancelDrop;
    }

    @Generated
    public List<DelayedCommand> getCommandsOnClick() {
        return this.commandsOnClick;
    }

    @Generated
    public Boolean getHideNoPermission() {
        return this.hideNoPermission;
    }

    @Generated
    public Boolean getHideRecipeLimitReached() {
        return this.hideRecipeLimitReached;
    }

    @Generated
    public void setRecipeItem(RecipeItem recipeItem) {
        this.recipeItem = recipeItem;
    }

    @Generated
    public void setIconNamespace(String iconNamespace) {
        this.iconNamespace = iconNamespace;
    }

    @Generated
    public void setIncludeOriginalLore(boolean includeOriginalLore) {
        this.includeOriginalLore = includeOriginalLore;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setCustomModelData(int customModelData) {
        this.customModelData = customModelData;
    }

    @Generated
    public void setLore(List<String> lore) {
        this.lore = lore;
    }

    @Generated
    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    @Generated
    public void setEnchantments(Map<Enchantment, Integer> enchantments) {
        this.enchantments = enchantments;
    }

    @Generated
    public void setFlags(Set<ItemFlag> flags) {
        this.flags = flags;
    }

    @Generated
    public void setColor(String color) {
        this.color = color;
    }

    @Generated
    public void setCancelDrop(boolean cancelDrop) {
        this.cancelDrop = cancelDrop;
    }

    @Generated
    public void setCommandsOnClick(List<DelayedCommand> commandsOnClick) {
        this.commandsOnClick = commandsOnClick;
    }

    @Generated
    public void setHideNoPermission(Boolean hideNoPermission) {
        this.hideNoPermission = hideNoPermission;
    }

    @Generated
    public void setHideRecipeLimitReached(Boolean hideRecipeLimitReached) {
        this.hideRecipeLimitReached = hideRecipeLimitReached;
    }
}

