/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.data.professions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.api.DelayedCommand;
import studio.magemonkey.codex.util.DeserializationWorker;
import studio.magemonkey.codex.util.SerializationBuilder;
import studio.magemonkey.fusion.data.recipes.RecipeItem;

public class ProfessionResults
implements ConfigurationSerializable {
    private final String profession;
    private long professionExp;
    private int vanillaExp;
    private List<RecipeItem> items = new LinkedList<RecipeItem>();
    private List<String> itemNames = new LinkedList<String>();
    private List<DelayedCommand> commands = new LinkedList<DelayedCommand>();

    public ProfessionResults(String profession, long professionExp, int vanillaExp, List<String> itemNames, List<DelayedCommand> commands) {
        this.profession = profession;
        this.professionExp = professionExp;
        this.vanillaExp = vanillaExp;
        this.itemNames = itemNames;
        this.commands = commands;
        for (String itemName : itemNames) {
            this.items.add(RecipeItem.fromConfig(itemName));
        }
    }

    public ProfessionResults(String profession, ConfigurationSection config) {
        this.profession = profession;
        this.professionExp = config.getLong("rewards.professionExp");
        this.vanillaExp = config.getInt("rewards.vanillaExp");
        this.commands = config.getList("rewards.commands", new LinkedList()).stream().map(entry -> new DelayedCommand()).collect(Collectors.toList());
        this.itemNames = config.getList("rewards.items", new LinkedList()).stream().map(Object::toString).collect(Collectors.toList());
        for (String itemName : this.itemNames) {
            this.items.add(RecipeItem.fromConfig(itemName));
        }
    }

    public ProfessionResults(String profession, DeserializationWorker dw) {
        this.profession = profession;
        Map resultsSection = dw.getSection("results");
        if (resultsSection != null) {
            List items;
            Integer professionExpObj = resultsSection.getOrDefault("professionExp", 0);
            this.professionExp = professionExpObj instanceof Number ? ((Number)professionExpObj).longValue() : 0L;
            Integer vanillaExpObj = resultsSection.getOrDefault("vanillaExp", 0);
            this.vanillaExp = vanillaExpObj instanceof Number ? ((Number)vanillaExpObj).intValue() : 0;
            List commands = resultsSection.getOrDefault("commands", new ArrayList());
            if (commands != null) {
                for (Map command : commands) {
                    this.commands.add(new DelayedCommand(command));
                }
            }
            if ((items = (List)resultsSection.getOrDefault("items", new ArrayList())) != null) {
                items.forEach(item -> {
                    this.itemNames.add(item.toString());
                    this.items.add(RecipeItem.fromConfig(item));
                });
            }
        }
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        resultMap.put("professionExp", Long.valueOf(this.professionExp));
        resultMap.put("vanillaExp", Integer.valueOf(this.vanillaExp));
        resultMap.put("commands", new ArrayList(this.commands.stream().map(DelayedCommand::serialize).collect(Collectors.toList())));
        resultMap.put("items", new ArrayList<String>(this.itemNames));
        return SerializationBuilder.start((int)4).append("results", resultMap).build();
    }

    public static ProfessionResults copy(ProfessionResults results) {
        ArrayList<DelayedCommand> cmds = new ArrayList<DelayedCommand>();
        for (DelayedCommand cmd : results.getCommands()) {
            cmds.add(new DelayedCommand(cmd.getAs(), cmd.getCmd(), cmd.getDelay()));
        }
        return new ProfessionResults(results.getProfession(), results.getProfessionExp(), results.getVanillaExp(), new ArrayList<String>(results.getItemNames()), cmds);
    }

    public boolean hasCommandsOrItems() {
        return this.professionExp > 0L || this.vanillaExp > 0 || !this.commands.isEmpty() || !this.itemNames.isEmpty();
    }

    @Generated
    public String getProfession() {
        return this.profession;
    }

    @Generated
    public long getProfessionExp() {
        return this.professionExp;
    }

    @Generated
    public int getVanillaExp() {
        return this.vanillaExp;
    }

    @Generated
    public List<RecipeItem> getItems() {
        return this.items;
    }

    @Generated
    public List<String> getItemNames() {
        return this.itemNames;
    }

    @Generated
    public List<DelayedCommand> getCommands() {
        return this.commands;
    }

    @Generated
    public void setProfessionExp(long professionExp) {
        this.professionExp = professionExp;
    }

    @Generated
    public void setVanillaExp(int vanillaExp) {
        this.vanillaExp = vanillaExp;
    }

    @Generated
    public void setItems(List<RecipeItem> items) {
        this.items = items;
    }

    @Generated
    public void setItemNames(List<String> itemNames) {
        this.itemNames = itemNames;
    }

    @Generated
    public void setCommands(List<DelayedCommand> commands) {
        this.commands = commands;
    }
}

