/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.data.professions;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.JobProgression;
import com.gmail.nossr50.api.ExperienceAPI;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.user.SkillsUser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.util.DeserializationWorker;
import studio.magemonkey.codex.util.SerializationBuilder;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.classes.FabledClass;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.BrowseConfig;
import studio.magemonkey.fusion.cfg.CraftingRequirementsCfg;
import studio.magemonkey.fusion.cfg.hooks.HookType;
import studio.magemonkey.fusion.data.player.FusionPlayer;
import studio.magemonkey.fusion.data.player.PlayerLoader;
import studio.magemonkey.fusion.data.professions.Profession;
import studio.magemonkey.fusion.data.recipes.RecipeItem;
import studio.magemonkey.fusion.util.ExperienceManager;
import studio.magemonkey.fusion.util.PlayerUtil;

public class ProfessionConditions
implements ConfigurationSerializable {
    private final String profession;
    private double moneyCost;
    private int expCost;
    protected LinkedList<RecipeItem> requiredItems = new LinkedList();
    private int professionLevel;
    private boolean isMastery;
    private String permission;
    private final Map<String, Integer> professionConditions = new LinkedHashMap<String, Integer>();
    private final Map<String, Integer> fabledClassConditions = new LinkedHashMap<String, Integer>();
    private final Map<String, Integer> mcMMOConditions = new LinkedHashMap<String, Integer>();
    private final Map<String, Integer> jobsConditions = new LinkedHashMap<String, Integer>();
    private final Map<String, Integer> auraAbilityConditions = new LinkedHashMap<String, Integer>();
    private final Map<String, Integer> auraManaAbilityConditions = new LinkedHashMap<String, Integer>();
    private final Map<String, Integer> auraSkillsConditions = new LinkedHashMap<String, Integer>();
    private final Map<String, Integer> auraStatsConditions = new LinkedHashMap<String, Integer>();
    protected List<Object> requiredItemNames = new LinkedList<Object>();

    public ProfessionConditions(String profession, double moneyCost, int expCost, LinkedList<Object> requiredItemNames, int professionLevel, boolean isMastery, String permission, Map<String, Integer> professionConditions, Map<String, Integer> fabledClassConditions, Map<String, Integer> mcMMOConditions, Map<String, Integer> jobsConditions, Map<String, Integer> auraAbilityConditions, Map<String, Integer> auraManaAbilityConditions, Map<String, Integer> auraSkillsConditions, Map<String, Integer> auraStatsConditions) {
        this.profession = profession;
        this.moneyCost = moneyCost;
        this.expCost = expCost;
        this.requiredItemNames = requiredItemNames;
        this.requiredItems = requiredItemNames.stream().map(RecipeItem::fromConfig).collect(Collectors.toCollection(LinkedList::new));
        this.professionLevel = professionLevel;
        this.isMastery = isMastery;
        this.permission = permission;
        this.professionConditions.putAll(professionConditions);
        this.fabledClassConditions.putAll(fabledClassConditions);
        this.mcMMOConditions.putAll(mcMMOConditions);
        this.jobsConditions.putAll(jobsConditions);
        this.auraAbilityConditions.putAll(auraAbilityConditions);
        this.auraManaAbilityConditions.putAll(auraManaAbilityConditions);
        this.auraSkillsConditions.putAll(auraSkillsConditions);
        this.auraStatsConditions.putAll(auraStatsConditions);
    }

    public ProfessionConditions(String profession, ConfigurationSection config) {
        this.profession = profession;
        this.moneyCost = config.getDouble("costs.money", 0.0);
        this.expCost = config.getInt("costs.exp", 0);
        this.requiredItems = config.getStringList("costs.items").stream().map(RecipeItem::fromConfig).collect(Collectors.toCollection(LinkedList::new));
        this.requiredItemNames = config.getList("costs.items");
        this.professionLevel = config.getInt("conditions.professionLevel", 0);
        this.isMastery = config.getBoolean("conditions.mastery", false);
        this.permission = config.getString("conditions.permission");
        if (config.isSet("conditions.professions")) {
            for (String key : Objects.requireNonNull(config.getConfigurationSection("conditions.professions")).getKeys(false)) {
                this.professionConditions.put(key, config.getInt("conditions.professions." + key));
            }
        }
        if (config.isSet("conditions.fabled") && Fusion.getHookManager().isHooked(HookType.Fabled)) {
            for (String key : Objects.requireNonNull(config.getConfigurationSection("conditions.fabled")).getKeys(false)) {
                this.fabledClassConditions.put(key, config.getInt("conditions.fabled." + key));
            }
        }
        if (Fusion.getHookManager().isHooked(HookType.mcMMO) && config.isSet("conditions.mcmmo")) {
            for (String key : Objects.requireNonNull(config.getConfigurationSection("conditions.mcmmo")).getKeys(false)) {
                this.mcMMOConditions.put(key, config.getInt("conditions.mcmmo." + key));
            }
        }
        if (Fusion.getHookManager().isHooked(HookType.Jobs) && config.isSet("conditions.jobs")) {
            for (String key : Objects.requireNonNull(config.getConfigurationSection("conditions.jobs")).getKeys(false)) {
                this.jobsConditions.put(key, config.getInt("conditions.jobs." + key));
            }
        }
        if (Fusion.getHookManager().isHooked(HookType.AuraSkills)) {
            if (config.isSet("conditions.aura_abilities")) {
                for (String key : Objects.requireNonNull(config.getConfigurationSection("conditions.aura_abilities")).getKeys(false)) {
                    this.auraAbilityConditions.put(key, config.getInt("conditions.aura_abilities." + key));
                }
            }
            if (config.isSet("conditions.aura_mana_abilities")) {
                for (String key : Objects.requireNonNull(config.getConfigurationSection("conditions.aura_mana_abilities")).getKeys(false)) {
                    this.auraAbilityConditions.put(key, config.getInt("conditions.aura_mana_abilities." + key));
                }
            }
            if (config.isSet("conditions.aura_skills")) {
                for (String key : Objects.requireNonNull(config.getConfigurationSection("conditions.aura_skills")).getKeys(false)) {
                    this.auraSkillsConditions.put(key, config.getInt("conditions.aura_skills." + key));
                }
            }
            if (config.isSet("conditions.aura_stats")) {
                for (String key : Objects.requireNonNull(config.getConfigurationSection("conditions.aura_stats")).getKeys(false)) {
                    this.auraSkillsConditions.put(key, config.getInt("conditions.aura_stats." + key));
                }
            }
        }
    }

    public ProfessionConditions(String profession, DeserializationWorker dw) {
        Map conditionsSection;
        this.profession = profession;
        this.professionLevel = 0;
        this.moneyCost = 0.0;
        this.expCost = 0;
        Map costsSection = dw.getSection("costs");
        if (costsSection != null) {
            this.moneyCost = costsSection.getOrDefault("money", 0.0);
            this.expCost = costsSection.getOrDefault("exp", 0);
            this.requiredItems = ((List)costsSection.get("items")).stream().map(RecipeItem::fromConfig).collect(Collectors.toCollection(LinkedList::new));
            this.requiredItemNames = (List)costsSection.get("items");
        }
        if ((conditionsSection = dw.getSection("conditions")) != null) {
            this.professionLevel = conditionsSection.getOrDefault("professionLevel", 0);
            this.isMastery = conditionsSection.getOrDefault("mastery", false);
            this.permission = conditionsSection.getOrDefault("permission", null);
            Map conditions = (Map)conditionsSection.get("professions");
            if (conditions != null) {
                for (Map.Entry entry : conditions.entrySet()) {
                    this.professionConditions.put((String)entry.getKey(), (int)((Integer)entry.getValue()));
                }
            }
            conditions = (Map)conditionsSection.get("fabled");
            if (Fusion.getHookManager().isHooked(HookType.Fabled) && conditions != null) {
                for (Map.Entry entry : conditions.entrySet()) {
                    this.fabledClassConditions.put((String)entry.getKey(), (int)((Integer)entry.getValue()));
                }
            }
            conditions = (Map)conditionsSection.get("mcmmo");
            if (Fusion.getHookManager().isHooked(HookType.mcMMO) && conditions != null) {
                for (Map.Entry entry : conditions.entrySet()) {
                    this.mcMMOConditions.put((String)entry.getKey(), (int)((Integer)entry.getValue()));
                }
            }
            conditions = (Map)conditionsSection.get("jobs");
            if (Fusion.getHookManager().isHooked(HookType.Jobs) && conditions != null) {
                for (Map.Entry entry : conditions.entrySet()) {
                    this.jobsConditions.put((String)entry.getKey(), (int)((Integer)entry.getValue()));
                }
            }
            if (Fusion.getHookManager().isHooked(HookType.AuraSkills)) {
                conditions = (Map)conditionsSection.get("aura_abilities");
                if (conditions != null) {
                    for (Map.Entry entry : conditions.entrySet()) {
                        this.auraAbilityConditions.put((String)entry.getKey(), (int)((Integer)entry.getValue()));
                    }
                }
                if ((conditions = (Map)conditionsSection.get("aura_mana_abilities")) != null) {
                    for (Map.Entry entry : conditions.entrySet()) {
                        this.auraManaAbilityConditions.put((String)entry.getKey(), (int)((Integer)entry.getValue()));
                    }
                }
                if ((conditions = (Map)conditionsSection.get("aura_skills")) != null) {
                    for (Map.Entry entry : conditions.entrySet()) {
                        this.auraSkillsConditions.put((String)entry.getKey(), (int)((Integer)entry.getValue()));
                    }
                }
                if ((conditions = (Map)conditionsSection.get("aura_stats")) != null) {
                    for (Map.Entry entry : conditions.entrySet()) {
                        this.auraStatsConditions.put((String)entry.getKey(), (int)((Integer)entry.getValue()));
                    }
                }
            }
        }
    }

    public boolean isValid(FusionPlayer player) {
        int level;
        Player _player = player.getPlayer();
        int unlocked = player.getJoinedProfessions().size();
        int allowed = PlayerUtil.getPermOption(_player, "fusion.limit");
        MessageData[] data = new MessageData[]{new MessageData("profession", (Object)this.profession), new MessageData("unlocked", (Object)unlocked), new MessageData("limit", (Object)allowed), new MessageData("bal", (Object)(CodexEngine.get().getVault() == null ? 0.0 : CodexEngine.get().getVault().getBalance((OfflinePlayer)_player))), new MessageData("costs.money", (Object)this.moneyCost), new MessageData("costs.exp", (Object)this.expCost), new MessageData("conditions.professionLevel", (Object)this.professionLevel), new MessageData("conditions.mastery", (Object)this.isMastery), new MessageData("condition.level", null), new MessageData("condition.name", null)};
        if (player.hasProfession(this.profession) && player.hasJoined(this.profession)) {
            _player.playSound(_player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
            CodexEngine.get().getMessageUtil().sendMessage("fusion.browse.alreadyUnlocked", (CommandSender)_player, data);
            return false;
        }
        if (unlocked >= allowed) {
            _player.playSound(_player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
            CodexEngine.get().getMessageUtil().sendMessage("fusion.error.limitReached", (CommandSender)_player, data);
            return false;
        }
        if (this.moneyCost > 0.0 && !CodexEngine.get().getVault().canPay((OfflinePlayer)_player, this.moneyCost)) {
            _player.playSound(_player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
            CodexEngine.get().getMessageUtil().sendMessage("fusion.browse.noFundsMoney", (CommandSender)_player, data);
            return false;
        }
        if (this.expCost > 0 && ExperienceManager.getTotalExperience(_player) < this.expCost) {
            _player.playSound(_player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
            CodexEngine.get().getMessageUtil().sendMessage("fusion.browse.noFundsExperience", (CommandSender)_player, data);
            return false;
        }
        if (this.professionLevel > 0 && player.getProfession(this.profession).getLevel() < this.professionLevel) {
            _player.playSound(_player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
            CodexEngine.get().getMessageUtil().sendMessage("fusion.error.noLevel", (CommandSender)_player, data);
            return false;
        }
        if (this.isMastery && !player.getProfession(this.profession).isMastered()) {
            _player.playSound(_player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
            CodexEngine.get().getMessageUtil().sendMessage("fusion.error.noMastery", (CommandSender)_player, data);
            return false;
        }
        if (this.permission != null && !player.getPlayer().hasPermission(this.permission)) {
            _player.playSound(_player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
            CodexEngine.get().getMessageUtil().sendMessage("fusion.gui.professions.permission", (CommandSender)player.getPlayer(), new MessageData[0]);
            return false;
        }
        for (Map.Entry<String, Integer> entry : this.professionConditions.entrySet()) {
            if (!BrowseConfig.getProfessions().contains(entry.getKey())) {
                Fusion.getInstance().getLogger().warning("Invalid profession-condition in browse.yml: " + entry.getKey());
                continue;
            }
            if (player.getProfession(entry.getKey()).getLevel() >= entry.getValue()) continue;
            _player.playSound(_player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
            data[data.length - 2] = new MessageData("condition.level", (Object)entry.getValue());
            data[data.length - 1] = new MessageData("condition.name", (Object)CodexEngine.get().getMessageUtil().getMessageAsString("fusion.conditionFormatting.profession", entry.getKey(), new MessageData[]{new MessageData("profession", (Object)entry.getKey())}));
            CodexEngine.get().getMessageUtil().sendMessage("fusion.browse.noConditionLevel", (CommandSender)_player, data);
            return false;
        }
        if (Fusion.getHookManager().isHooked(HookType.Fabled)) {
            for (Map.Entry<String, Integer> entry : this.fabledClassConditions.entrySet()) {
                if (!Fabled.getClasses().containsKey(entry.getKey())) {
                    Fusion.getInstance().getLogger().warning("Invalid fabled-class condition in browse.yml: " + entry.getKey());
                    continue;
                }
                int level2 = Fabled.getPlayerAccounts((OfflinePlayer)_player).getActiveData().getClass(entry.getKey()).getLevel();
                if (level2 >= entry.getValue()) continue;
                _player.playSound(_player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
                data[data.length - 2] = new MessageData("condition.level", (Object)entry.getValue());
                data[data.length - 1] = new MessageData("condition.name", (Object)CodexEngine.get().getMessageUtil().getMessageAsString("fusion.conditionFormatting.fabled", entry.getKey(), new MessageData[]{new MessageData("class", (Object)((FabledClass)Fabled.getClasses().get(entry.getKey())).getName())}));
                CodexEngine.get().getMessageUtil().sendMessage("fusion.browse.noConditionLevel", (CommandSender)_player, data);
                return false;
            }
        }
        if (Fusion.getHookManager().isHooked(HookType.mcMMO)) {
            for (Map.Entry<String, Integer> entry : this.mcMMOConditions.entrySet()) {
                PrimarySkillType skill = PrimarySkillType.getSkill((String)entry.getKey().toUpperCase());
                if (skill == null) {
                    Fusion.getInstance().getLogger().warning("Invalid mcmmo-skill condition in browse.yml: " + entry.getKey());
                    continue;
                }
                int level3 = ExperienceAPI.getLevel((Player)_player, (PrimarySkillType)skill);
                if (level3 >= entry.getValue()) continue;
                _player.playSound(_player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
                data[data.length - 2] = new MessageData("condition.level", (Object)entry.getValue());
                data[data.length - 1] = new MessageData("condition.name", (Object)CodexEngine.get().getMessageUtil().getMessageAsString("fusion.conditionFormatting.mcmmo", entry.getKey(), new MessageData[]{new MessageData("skill", (Object)skill.getName())}));
                CodexEngine.get().getMessageUtil().sendMessage("fusion.browse.noConditionLevel", (CommandSender)_player, data);
                return false;
            }
        }
        if (Fusion.getHookManager().isHooked(HookType.Jobs)) {
            for (Map.Entry<String, Integer> entry : this.jobsConditions.entrySet()) {
                Job job = Jobs.getJob((String)entry.getKey());
                if (job == null) {
                    Fusion.getInstance().getLogger().warning("Invalid job condition in browse.yml: " + entry.getKey());
                    continue;
                }
                JobProgression progression = Jobs.getPlayerManager().getJobsPlayer(_player).getJobProgression(job);
                level = progression != null ? progression.getLevel() : 0;
                if (level >= entry.getValue()) continue;
                _player.playSound(_player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
                data[data.length - 2] = new MessageData("condition.level", (Object)entry.getValue());
                data[data.length - 1] = new MessageData("condition.name", (Object)CodexEngine.get().getMessageUtil().getMessageAsString("fusion.conditionFormatting.jobs", entry.getKey(), new MessageData[]{new MessageData("job", (Object)job.getDisplayName())}));
                CodexEngine.get().getMessageUtil().sendMessage("fusion.browse.noConditionLevel", (CommandSender)_player, data);
                return false;
            }
        }
        if (Fusion.getHookManager().isHooked(HookType.AuraSkills)) {
            SkillsUser user = AuraSkillsApi.get().getUser(_player.getUniqueId());
            for (Map.Entry<String, Integer> entry : this.auraAbilityConditions.entrySet()) {
                Ability ability = AuraSkillsApi.get().getGlobalRegistry().getAbility(NamespacedId.fromString((String)entry.getKey()));
                if (ability == null) {
                    Fusion.getInstance().getLogger().warning("Invalid aura-ability condition in browse.yml: " + entry.getKey());
                    continue;
                }
                level = user.getAbilityLevel(ability);
                if (level >= entry.getValue()) continue;
                _player.playSound(_player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
                data[data.length - 2] = new MessageData("condition.level", (Object)entry.getValue());
                data[data.length - 1] = new MessageData("condition.name", (Object)CodexEngine.get().getMessageUtil().getMessageAsString("fusion.conditionFormatting.auraAbility", entry.getKey(), new MessageData[]{new MessageData("ability", (Object)ability.getDisplayName(Locale.ENGLISH))}));
                CodexEngine.get().getMessageUtil().sendMessage("fusion.browse.noConditionLevel", (CommandSender)_player, data);
                return false;
            }
            for (Map.Entry<String, Integer> entry : this.auraManaAbilityConditions.entrySet()) {
                ManaAbility ability = AuraSkillsApi.get().getGlobalRegistry().getManaAbility(NamespacedId.fromString((String)entry.getKey()));
                if (ability == null) {
                    Fusion.getInstance().getLogger().warning("Invalid aura-mana-ability condition in browse.yml: " + entry.getKey());
                    continue;
                }
                level = user.getManaAbilityLevel(ability);
                if (level >= entry.getValue()) continue;
                _player.playSound(_player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
                data[data.length - 2] = new MessageData("condition.level", (Object)entry.getValue());
                data[data.length - 1] = new MessageData("condition.name", (Object)CodexEngine.get().getMessageUtil().getMessageAsString("fusion.conditionFormatting.auraManaAbility", entry.getKey(), new MessageData[]{new MessageData("ability", (Object)ability.getDisplayName(Locale.ENGLISH))}));
                CodexEngine.get().getMessageUtil().sendMessage("fusion.browse.noConditionLevel", (CommandSender)_player, data);
                return false;
            }
            for (Map.Entry<String, Integer> entry : this.auraSkillsConditions.entrySet()) {
                Skill skill = AuraSkillsApi.get().getGlobalRegistry().getSkill(NamespacedId.fromString((String)entry.getKey()));
                if (skill == null) {
                    Fusion.getInstance().getLogger().warning("Invalid aura-skill condition in browse.yml: " + entry.getKey());
                    continue;
                }
                level = user.getSkillLevel(skill);
                if (level >= entry.getValue()) continue;
                _player.playSound(_player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
                data[data.length - 2] = new MessageData("condition.level", (Object)entry.getValue());
                data[data.length - 1] = new MessageData("condition.name", (Object)CodexEngine.get().getMessageUtil().getMessageAsString("fusion.conditionFormatting.auraSkill", entry.getKey(), new MessageData[]{new MessageData("skill", (Object)skill.getDisplayName(Locale.ENGLISH))}));
                CodexEngine.get().getMessageUtil().sendMessage("fusion.browse.noConditionLevel", (CommandSender)_player, data);
                return false;
            }
            for (Map.Entry<String, Integer> entry : this.auraStatsConditions.entrySet()) {
                Stat stat = AuraSkillsApi.get().getGlobalRegistry().getStat(NamespacedId.fromString((String)entry.getKey()));
                if (stat == null) {
                    Fusion.getInstance().getLogger().warning("Invalid aura-stat condition in browse.yml: " + entry.getKey());
                    continue;
                }
                double level4 = user.getStatLevel(stat);
                if (!(level4 < (double)entry.getValue().intValue())) continue;
                _player.playSound(_player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
                data[data.length - 2] = new MessageData("condition.level", (Object)entry.getValue());
                data[data.length - 1] = new MessageData("condition.name", (Object)CodexEngine.get().getMessageUtil().getMessageAsString("fusion.conditionFormatting.auraSkill", entry.getKey(), new MessageData[]{new MessageData("skill", (Object)stat.name())}));
                CodexEngine.get().getMessageUtil().sendMessage("fusion.browse.noConditionLevel", (CommandSender)_player, data);
                return false;
            }
        }
        return true;
    }

    public Map<String, Map<String, Integer>> getFullConditions() {
        TreeMap<String, Map<String, Integer>> conditions = new TreeMap<String, Map<String, Integer>>();
        conditions.put("profession", this.professionConditions);
        conditions.put("fabled", this.fabledClassConditions);
        conditions.put("mcmmo", this.mcMMOConditions);
        conditions.put("jobs", this.jobsConditions);
        conditions.put("auraAbility", this.auraAbilityConditions);
        conditions.put("auraManaAbility", this.auraManaAbilityConditions);
        conditions.put("auraSkill", this.auraSkillsConditions);
        conditions.put("auraStats", this.auraStatsConditions);
        return conditions;
    }

    public List<Map.Entry<Boolean, String>> getConditionLines(Player player) {
        boolean condition;
        FusionPlayer fusionPlayer = PlayerLoader.getPlayer(player.getUniqueId());
        ArrayList<Map.Entry<Boolean, String>> lines = new ArrayList<Map.Entry<Boolean, String>>();
        for (Map.Entry<String, Integer> entry : this.professionConditions.entrySet()) {
            Profession profession = fusionPlayer.getProfession(entry.getKey());
            condition = profession != null && profession.getLevel() >= entry.getValue();
            lines.add(Map.entry(condition, CraftingRequirementsCfg.getConditionLine("recipes", "profession", entry.getKey(), profession != null ? profession.getLevel() : 0, entry.getValue())));
        }
        if (Fusion.getHookManager().isHooked(HookType.Fabled)) {
            for (Map.Entry<String, Integer> entry : this.fabledClassConditions.entrySet()) {
                boolean condition2 = Fabled.getPlayerAccounts((OfflinePlayer)player).getActiveData().getClass(entry.getKey()).getLevel() >= entry.getValue();
                lines.add(Map.entry(condition2, CraftingRequirementsCfg.getConditionLine("recipes", "fabled", entry.getKey(), Fabled.getPlayerAccounts((OfflinePlayer)player).getActiveData().getClass(entry.getKey()).getLevel(), entry.getValue())));
            }
        }
        if (Fusion.getHookManager().isHooked(HookType.mcMMO)) {
            for (Map.Entry<String, Integer> entry : this.mcMMOConditions.entrySet()) {
                PrimarySkillType skill = PrimarySkillType.getSkill((String)entry.getKey().toUpperCase());
                condition = ExperienceAPI.getLevel((Player)player, (PrimarySkillType)skill) >= entry.getValue();
                lines.add(Map.entry(condition, CraftingRequirementsCfg.getConditionLine("recipes", "mcmmo", entry.getKey(), ExperienceAPI.getLevel((Player)player, (PrimarySkillType)skill), entry.getValue())));
            }
        }
        if (Fusion.getHookManager().isHooked(HookType.Jobs)) {
            for (Map.Entry<String, Integer> entry : this.jobsConditions.entrySet()) {
                Job job = Jobs.getJob((String)entry.getKey());
                JobProgression progression = Jobs.getPlayerManager().getJobsPlayer(player).getJobProgression(job);
                boolean condition3 = progression != null && Jobs.getPlayerManager().getJobsPlayer(player).getJobProgression(job).getLevel() >= entry.getValue();
                lines.add(Map.entry(condition3, CraftingRequirementsCfg.getConditionLine("recipes", "jobs", entry.getKey(), progression != null ? progression.getLevel() : 0, entry.getValue())));
            }
        }
        if (Fusion.getHookManager().isHooked(HookType.AuraSkills)) {
            for (Map.Entry<String, Integer> entry : this.auraAbilityConditions.entrySet()) {
                Ability ability = AuraSkillsApi.get().getGlobalRegistry().getAbility(NamespacedId.fromString((String)entry.getKey()));
                if (ability == null) continue;
                boolean condition4 = AuraSkillsApi.get().getUser(player.getUniqueId()).getAbilityLevel(ability) >= entry.getValue();
                lines.add(Map.entry(condition4, CraftingRequirementsCfg.getConditionLine("recipes", "auraAbility", entry.getKey(), AuraSkillsApi.get().getUser(player.getUniqueId()).getAbilityLevel(ability), entry.getValue())));
            }
            for (Map.Entry<String, Integer> entry : this.auraManaAbilityConditions.entrySet()) {
                ManaAbility ability = AuraSkillsApi.get().getGlobalRegistry().getManaAbility(NamespacedId.fromString((String)entry.getKey()));
                if (ability == null) continue;
                boolean condition5 = AuraSkillsApi.get().getUser(player.getUniqueId()).getManaAbilityLevel(ability) >= entry.getValue();
                lines.add(Map.entry(condition5, CraftingRequirementsCfg.getConditionLine("recipes", "auraManaAbility", entry.getKey(), AuraSkillsApi.get().getUser(player.getUniqueId()).getManaAbilityLevel(ability), entry.getValue())));
            }
            for (Map.Entry<String, Integer> entry : this.auraSkillsConditions.entrySet()) {
                Skill skill = AuraSkillsApi.get().getGlobalRegistry().getSkill(NamespacedId.fromString((String)entry.getKey()));
                if (skill == null) continue;
                boolean condition6 = AuraSkillsApi.get().getUser(player.getUniqueId()).getSkillLevel(skill) >= entry.getValue();
                lines.add(Map.entry(condition6, CraftingRequirementsCfg.getConditionLine("recipes", "auraSkill", entry.getKey(), AuraSkillsApi.get().getUser(player.getUniqueId()).getSkillLevel(skill), entry.getValue())));
            }
            for (Map.Entry<String, Integer> entry : this.auraStatsConditions.entrySet()) {
                Stat stat = AuraSkillsApi.get().getGlobalRegistry().getStat(NamespacedId.fromString((String)entry.getKey()));
                if (stat == null) continue;
                boolean condition7 = AuraSkillsApi.get().getUser(player.getUniqueId()).getStatLevel(stat) >= (double)entry.getValue().intValue();
                lines.add(Map.entry(condition7, CraftingRequirementsCfg.getConditionLine("recipes", "auraStat", entry.getKey(), (int)AuraSkillsApi.get().getUser(player.getUniqueId()).getStatLevel(stat), entry.getValue())));
            }
        }
        return lines;
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> costsMap = new LinkedHashMap<String, Object>();
        costsMap.put("money", this.moneyCost);
        costsMap.put("exp", this.expCost);
        costsMap.put("items", this.requiredItemNames);
        LinkedHashMap<String, Object> conditionsMap = new LinkedHashMap<String, Object>();
        conditionsMap.put("professionLevel", this.professionLevel);
        conditionsMap.put("mastery", this.isMastery);
        conditionsMap.put("permission", this.permission);
        if (!this.professionConditions.isEmpty()) {
            conditionsMap.put("professions", this.professionConditions);
        }
        if (!this.fabledClassConditions.isEmpty()) {
            conditionsMap.put("fabled", this.fabledClassConditions);
        }
        if (!this.mcMMOConditions.isEmpty()) {
            conditionsMap.put("mcmmo", this.mcMMOConditions);
        }
        if (!this.jobsConditions.isEmpty()) {
            conditionsMap.put("jobs", this.jobsConditions);
        }
        if (!this.auraAbilityConditions.isEmpty()) {
            conditionsMap.put("aura_abilities", this.auraAbilityConditions);
        }
        if (!this.auraManaAbilityConditions.isEmpty()) {
            conditionsMap.put("aura_mana_abilities", this.auraManaAbilityConditions);
        }
        if (!this.auraSkillsConditions.isEmpty()) {
            conditionsMap.put("aura_skills", this.auraSkillsConditions);
        }
        if (!this.auraStatsConditions.isEmpty()) {
            conditionsMap.put("aura_stats", this.auraStatsConditions);
        }
        SerializationBuilder builder = SerializationBuilder.start((int)4).append("costs", costsMap).append("conditions", conditionsMap);
        return builder.build();
    }

    public void removeLastCondition() {
        if (this.checkRemoveFromMap(this.auraStatsConditions)) {
            return;
        }
        if (this.checkRemoveFromMap(this.auraSkillsConditions)) {
            return;
        }
        if (this.checkRemoveFromMap(this.auraManaAbilityConditions)) {
            return;
        }
        if (this.checkRemoveFromMap(this.auraAbilityConditions)) {
            return;
        }
        if (this.checkRemoveFromMap(this.jobsConditions)) {
            return;
        }
        if (this.checkRemoveFromMap(this.mcMMOConditions)) {
            return;
        }
        if (this.checkRemoveFromMap(this.fabledClassConditions)) {
            return;
        }
        this.checkRemoveFromMap(this.professionConditions);
    }

    private boolean checkRemoveFromMap(Map<String, Integer> map) {
        Map.Entry<String, Integer> lastEntry = null;
        Iterator<Map.Entry<String, Integer>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> _entry;
            lastEntry = _entry = iterator.next();
        }
        if (lastEntry != null) {
            map.remove(lastEntry.getKey());
            return true;
        }
        return false;
    }

    public static ProfessionConditions copy(ProfessionConditions conditions) {
        LinkedHashMap<String, Integer> professionConditions = new LinkedHashMap<String, Integer>(conditions.getProfessionConditions());
        LinkedHashMap<String, Integer> fabledClassConditions = new LinkedHashMap<String, Integer>(conditions.getFabledClassConditions());
        LinkedHashMap<String, Integer> mcMMOConditions = new LinkedHashMap<String, Integer>(conditions.getMcMMOConditions());
        LinkedHashMap<String, Integer> jobsConditions = new LinkedHashMap<String, Integer>(conditions.getJobsConditions());
        LinkedHashMap<String, Integer> auraAbilityConditions = new LinkedHashMap<String, Integer>(conditions.getAuraAbilityConditions());
        LinkedHashMap<String, Integer> auraManaAbilityConditions = new LinkedHashMap<String, Integer>(conditions.getAuraManaAbilityConditions());
        LinkedHashMap<String, Integer> auraSkillsConditions = new LinkedHashMap<String, Integer>(conditions.getAuraSkillsConditions());
        LinkedHashMap<String, Integer> auraStatsConditions = new LinkedHashMap<String, Integer>(conditions.getAuraStatsConditions());
        return new ProfessionConditions(conditions.getProfession(), conditions.getMoneyCost(), conditions.getExpCost(), new LinkedList<Object>(conditions.getRequiredItemNames() != null ? conditions.getRequiredItemNames() : new LinkedList()), conditions.getProfessionLevel(), conditions.isMastery(), conditions.getPermission(), professionConditions, fabledClassConditions, mcMMOConditions, jobsConditions, auraAbilityConditions, auraManaAbilityConditions, auraSkillsConditions, auraStatsConditions);
    }

    @Generated
    public String getProfession() {
        return this.profession;
    }

    @Generated
    public double getMoneyCost() {
        return this.moneyCost;
    }

    @Generated
    public int getExpCost() {
        return this.expCost;
    }

    @Generated
    public LinkedList<RecipeItem> getRequiredItems() {
        return this.requiredItems;
    }

    @Generated
    public int getProfessionLevel() {
        return this.professionLevel;
    }

    @Generated
    public boolean isMastery() {
        return this.isMastery;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public Map<String, Integer> getProfessionConditions() {
        return this.professionConditions;
    }

    @Generated
    public Map<String, Integer> getFabledClassConditions() {
        return this.fabledClassConditions;
    }

    @Generated
    public Map<String, Integer> getMcMMOConditions() {
        return this.mcMMOConditions;
    }

    @Generated
    public Map<String, Integer> getJobsConditions() {
        return this.jobsConditions;
    }

    @Generated
    public Map<String, Integer> getAuraAbilityConditions() {
        return this.auraAbilityConditions;
    }

    @Generated
    public Map<String, Integer> getAuraManaAbilityConditions() {
        return this.auraManaAbilityConditions;
    }

    @Generated
    public Map<String, Integer> getAuraSkillsConditions() {
        return this.auraSkillsConditions;
    }

    @Generated
    public Map<String, Integer> getAuraStatsConditions() {
        return this.auraStatsConditions;
    }

    @Generated
    public void setMoneyCost(double moneyCost) {
        this.moneyCost = moneyCost;
    }

    @Generated
    public void setExpCost(int expCost) {
        this.expCost = expCost;
    }

    @Generated
    public void setProfessionLevel(int professionLevel) {
        this.professionLevel = professionLevel;
    }

    @Generated
    public void setMastery(boolean isMastery) {
        this.isMastery = isMastery;
    }

    @Generated
    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Generated
    public List<Object> getRequiredItemNames() {
        return this.requiredItemNames;
    }
}

