/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.data.player;

import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.bukkit.entity.Player;
import studio.magemonkey.fusion.cfg.sql.SQLManager;
import studio.magemonkey.fusion.data.player.FusionPlayer;

public class PlayerLoader {
    private static final Map<UUID, FusionPlayer> cachedPlayers = new TreeMap<UUID, FusionPlayer>();

    public static FusionPlayer getPlayer(UUID uuid) {
        if (!cachedPlayers.containsKey(uuid)) {
            cachedPlayers.put(uuid, new FusionPlayer(uuid));
        }
        return cachedPlayers.get(uuid);
    }

    public static FusionPlayer getPlayer(Player player) {
        return PlayerLoader.getPlayer(player.getUniqueId());
    }

    public static FusionPlayer getPlayerIfReady(UUID uuid) {
        FusionPlayer fp = PlayerLoader.getPlayer(uuid);
        if (fp == null) {
            return null;
        }
        if (fp.isLocked()) {
            return null;
        }
        return fp;
    }

    public static FusionPlayer getPlayerIfReady(Player player) {
        return PlayerLoader.getPlayerIfReady(player.getUniqueId());
    }

    public static FusionPlayer getPlayerBlocking(UUID uuid, long timeoutMs) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeoutMs) {
            boolean locked = SQLManager.players().isLocked(uuid);
            if (!locked) {
                return PlayerLoader.getPlayer(uuid);
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        return null;
    }

    public static FusionPlayer getPlayerBlocking(Player player, long timeoutMs) {
        return PlayerLoader.getPlayerBlocking(player.getUniqueId(), timeoutMs);
    }

    public static void loadPlayer(Player player) {
        cachedPlayers.put(player.getUniqueId(), new FusionPlayer(player.getUniqueId()));
    }

    public static void unloadPlayer(Player player) {
        if (cachedPlayers.containsKey(player.getUniqueId())) {
            FusionPlayer fusionPlayer = cachedPlayers.get(player.getUniqueId());
            fusionPlayer.save(true);
            cachedPlayers.remove(player.getUniqueId());
        }
    }

    public static void clearCache() {
        for (FusionPlayer fusionPlayer : cachedPlayers.values()) {
            fusionPlayer.save(true);
        }
        cachedPlayers.clear();
    }
}

