/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.commands.CommandMechanics;
import studio.magemonkey.fusion.data.player.PlayerLoader;
import studio.magemonkey.fusion.data.professions.Profession;

public class Commands
implements CommandExecutor,
TabCompleter {
    private final Map<String, ConfirmationAction> confirmation = new HashMap<String, ConfirmationAction>();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (args.length == 0) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.help", sender, new MessageData[]{new MessageData("sender", (Object)sender), new MessageData("text", (Object)(label + " " + StringUtils.join((Object[])args, (char)' ')))});
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "auto": {
                CommandMechanics.toggleAutoCrafting(sender);
                break;
            }
            case "browse": {
                CommandMechanics.openBrowseGui(sender);
                break;
            }
            case "confirm": {
                CommandMechanics.confirmAction(sender, this.confirmation);
                break;
            }
            case "exp": {
                if (args.length != 5) break;
                CommandMechanics.setProfessionExp(sender, args);
                break;
            }
            case "forget": {
                if (args.length != 2) break;
                CommandMechanics.forgetProfession(sender, args, this.confirmation);
                break;
            }
            case "join": {
                if (args.length != 2) break;
                CommandMechanics.joinProfession(sender, args);
                break;
            }
            case "level": {
                if (args.length != 5) break;
                CommandMechanics.setProfessionLevel(sender, args);
                break;
            }
            case "reload": {
                CommandMechanics.reloadPlugin(sender);
                break;
            }
            case "master": {
                if (args.length == 2) {
                    CommandMechanics.masterProfession(sender, args);
                }
                return true;
            }
            case "show": {
                CommandMechanics.openIngredientGui(sender);
                break;
            }
            case "stats": {
                CommandMechanics.showStats(sender);
                break;
            }
            case "storage": {
                if (args.length == 2) {
                    CommandMechanics.setStorage(sender, args);
                }
                return true;
            }
            case "use": {
                if (args.length < 2) break;
                CommandMechanics.useProfession(sender, args);
                return true;
            }
            case "forcejoin": {
                if (args.length == 3) {
                    CommandMechanics.forceJoinProfession(sender, args);
                }
                return true;
            }
            case "forceleave": {
                if (args.length == 3) {
                    CommandMechanics.forceLeaveProfession(sender, args);
                }
                return true;
            }
            case "forcestats": {
                if (args.length == 2) {
                    CommandMechanics.forceStats(sender, args);
                }
                return true;
            }
            case "forcemaster": {
                if (args.length == 3) {
                    CommandMechanics.forceMaster(sender, args);
                }
                return true;
            }
            case "forceshow": {
                if (args.length == 2) {
                    CommandMechanics.forceShow(sender, args);
                }
                return true;
            }
            default: {
                CodexEngine.get().getMessageUtil().sendMessage("fusion.help", sender, new MessageData[]{new MessageData("sender", (Object)sender), new MessageData("text", (Object)(label + " " + StringUtils.join((Object[])args, (char)' ')))});
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        ArrayList<String> entries;
        block35: {
            block43: {
                block45: {
                    ArrayList<Profession> professions;
                    block44: {
                        block36: {
                            block42: {
                                block41: {
                                    block40: {
                                        block39: {
                                            block38: {
                                                block37: {
                                                    block34: {
                                                        if (!(sender instanceof Player)) {
                                                            return List.of();
                                                        }
                                                        Player player = (Player)sender;
                                                        entries = new ArrayList<String>();
                                                        professions = new ArrayList<Profession>(PlayerLoader.getPlayer(player.getUniqueId()).getProfessions());
                                                        if (args.length != 1) break block34;
                                                        if (sender.hasPermission("fusion.browse") && "browse".startsWith(args[0])) {
                                                            entries.add("browse");
                                                        }
                                                        if (this.confirmation.containsKey(player.getUniqueId().toString()) && "confirm".startsWith(args[0])) {
                                                            entries.add("confirm");
                                                        }
                                                        if ("stats".startsWith(args[0])) {
                                                            entries.add("stats");
                                                        }
                                                        if ("use".startsWith(args[0])) {
                                                            entries.add("use");
                                                        }
                                                        if (sender.hasPermission("fusion.master") && "master".startsWith(args[0])) {
                                                            entries.add("master");
                                                        }
                                                        if ("forget".startsWith(args[0])) {
                                                            entries.add("forget");
                                                        }
                                                        if ("join".startsWith(args[0])) {
                                                            entries.add("join");
                                                        }
                                                        if (sender.hasPermission("fusion.admin.use") && "storage".startsWith(args[0])) {
                                                            entries.add("storage");
                                                        }
                                                        if (sender.hasPermission("fusion.auto") && "auto".startsWith(args[0])) {
                                                            entries.add("auto");
                                                        }
                                                        if (sender.hasPermission("fusion.reload") && "reload".startsWith(args[0])) {
                                                            entries.add("reload");
                                                        }
                                                        if (sender.hasPermission("fusion.show") && "show".startsWith(args[0])) {
                                                            entries.add("show");
                                                        }
                                                        if (sender.hasPermission("fusion.admin") && "exp".startsWith(args[0])) {
                                                            entries.add("exp");
                                                        }
                                                        if (sender.hasPermission("fusion.admin") && "level".startsWith(args[0])) {
                                                            entries.add("level");
                                                        }
                                                        if (!sender.hasPermission("fusion.admin.force")) break block35;
                                                        if ("forcejoin".startsWith(args[0])) {
                                                            entries.add("forcejoin");
                                                        }
                                                        if ("forceleave".startsWith(args[0])) {
                                                            entries.add("forceleave");
                                                        }
                                                        if ("forcestats".startsWith(args[0])) {
                                                            entries.add("forcestats");
                                                        }
                                                        if ("forcemaster".startsWith(args[0])) {
                                                            entries.add("forcemaster");
                                                        }
                                                        if ("forceshow".startsWith(args[0])) {
                                                            entries.add("forceshow");
                                                        }
                                                        break block35;
                                                    }
                                                    if (args.length != 2) break block36;
                                                    if (!args[0].equalsIgnoreCase("use")) break block37;
                                                    for (String string : professions.stream().map(Profession::getName).toList()) {
                                                        if (!ProfessionsCfg.getGuiMap().containsKey(string) || !string.startsWith(args[1])) continue;
                                                        entries.add(string);
                                                    }
                                                    if (!sender.hasPermission("fusion.craft.use.categories") || !args[1].contains(":")) break block35;
                                                    String profession = args[1].split(":")[0];
                                                    if (ProfessionsCfg.getGuiMap().containsKey(profession)) {
                                                        for (String category : ProfessionsCfg.getTable(profession).getCategories().keySet()) {
                                                            if (!(profession + ":" + category).startsWith(args[1])) continue;
                                                            entries.add(profession + ":" + category);
                                                        }
                                                    }
                                                    break block35;
                                                }
                                                if (!args[0].equalsIgnoreCase("master")) break block38;
                                                for (String string : professions.stream().filter(Profession::isMastered).map(Profession::getName).toList()) {
                                                    if (!string.startsWith(args[1])) continue;
                                                    entries.add(string);
                                                }
                                                break block35;
                                            }
                                            if (!args[0].equalsIgnoreCase("forget")) break block39;
                                            for (String string : ProfessionsCfg.getMap().keySet()) {
                                                if (!string.startsWith(args[1])) continue;
                                                entries.add(string);
                                            }
                                            break block35;
                                        }
                                        if (!args[0].equalsIgnoreCase("join")) break block40;
                                        for (String string : ProfessionsCfg.getGuiMap().keySet()) {
                                            if (professions.stream().map(Profession::getName).toList().contains(string) || !string.startsWith(args[1])) continue;
                                            entries.add(string);
                                        }
                                        break block35;
                                    }
                                    if (!args[0].equalsIgnoreCase("storage") || !sender.hasPermission("fusion.admin")) break block41;
                                    if ("local".startsWith(args[1])) {
                                        entries.add("local");
                                    }
                                    if (!"sql".startsWith(args[1])) break block35;
                                    entries.add("sql");
                                    break block35;
                                }
                                if (!args[0].equalsIgnoreCase("exp") && !args[0].equalsIgnoreCase("level") || !sender.hasPermission("fusion.admin")) break block42;
                                if ("add".startsWith(args[1].toLowerCase())) {
                                    entries.add("add");
                                }
                                if ("set".startsWith(args[1].toLowerCase())) {
                                    entries.add("set");
                                }
                                if (!"take".startsWith(args[1].toLowerCase())) break block35;
                                entries.add("take");
                                break block35;
                            }
                            if (!sender.hasPermission("fusion.admin.force") || !args[0].equalsIgnoreCase("forcejoin") && !args[0].equalsIgnoreCase("forceleave") && !args[0].equalsIgnoreCase("forcestats") && !args[0].equalsIgnoreCase("forcemaster") && !args[0].equalsIgnoreCase("forceshow")) break block35;
                            for (Player player : Bukkit.getOnlinePlayers()) {
                                if (!player.getName().startsWith(args[1])) continue;
                                entries.add(player.getName());
                            }
                            break block35;
                        }
                        if (args.length != 3) break block43;
                        if (!sender.hasPermission("fusion.admin.use") || !args[0].equalsIgnoreCase("use")) break block44;
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            if (!player.getName().startsWith(args[2])) continue;
                            entries.add(player.getName());
                        }
                        break block35;
                    }
                    if (!args[0].equalsIgnoreCase("exp") && !args[0].equalsIgnoreCase("level") || !sender.hasPermission("fusion.admin")) break block45;
                    for (String string : professions.stream().map(Profession::getName).toList()) {
                        if (!string.startsWith(args[2])) continue;
                        entries.add(string);
                    }
                    break block35;
                }
                if (!sender.hasPermission("fusion.admin.force") || !args[0].equalsIgnoreCase("forcejoin") && !args[0].equalsIgnoreCase("forceleave") && !args[0].equalsIgnoreCase("forcemaster")) break block35;
                for (String string : ProfessionsCfg.getGuiMap().keySet()) {
                    if (!string.startsWith(args[2])) continue;
                    entries.add(string);
                }
                break block35;
            }
            if (args.length == 4 && (args[0].equalsIgnoreCase("exp") || args[0].equalsIgnoreCase("level")) && sender.hasPermission("fusion.admin")) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getName().startsWith(args[3])) continue;
                    entries.add(player.getName());
                }
            }
        }
        return entries;
    }

    public static interface ConfirmationAction {
        public void doAction();
    }
}

