/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.sql.SQLManager;
import studio.magemonkey.fusion.data.player.PlayerRecipeLimit;

public class FusionRecipeLimitsSQL {
    private final String Table = "fusion_limits";

    public FusionRecipeLimitsSQL() {
        try (PreparedStatement create = SQLManager.connection().prepareStatement("CREATE TABLE IF NOT EXISTS fusion_limits(" + SQLManager.getIdColumn() + " UUID varchar(36), RecipePath varchar(100),Amount numeric,Timestamp BIGINT)");){
            create.execute();
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionRecipeLimitsSQL:FusionRecipeLimitsSQL] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    public Map<String, PlayerRecipeLimit> getRecipeLimits(UUID uuid) {
        HashMap<String, PlayerRecipeLimit> limits = new HashMap<String, PlayerRecipeLimit>();
        try (PreparedStatement select = SQLManager.connection().prepareStatement("SELECT * FROM fusion_limits WHERE UUID = ?");){
            select.setString(1, uuid.toString());
            ResultSet result = select.executeQuery();
            while (result.next()) {
                String recipePath = result.getString("RecipePath");
                int amount = result.getInt("Amount");
                long timestamp = result.getLong("Timestamp");
                limits.put(recipePath, new PlayerRecipeLimit(recipePath, amount, timestamp));
            }
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionRecipeLimitsSQL:getRecipeLimits] Something went wrong with the sql-connection: " + e.getMessage());
        }
        return limits;
    }

    public void saveRecipeLimits(UUID uuid, Map<String, PlayerRecipeLimit> recipeLimits) {
        Map<String, PlayerRecipeLimit> currentLimits = this.getRecipeLimits(uuid);
        for (String string : currentLimits.keySet()) {
            PlayerRecipeLimit limit;
            if (recipeLimits.containsKey(string) || (limit = currentLimits.get(string)).getCooldownTimestamp() == -1L) continue;
            try {
                PreparedStatement delete = SQLManager.connection().prepareStatement("DELETE FROM fusion_limits WHERE UUID = ? AND RecipePath = ?");
                try {
                    delete.setString(1, uuid.toString());
                    delete.setString(2, string);
                    delete.execute();
                }
                finally {
                    if (delete == null) continue;
                    delete.close();
                }
            }
            catch (SQLException e) {
                Fusion.getInstance().getLogger().warning("[SQL:FusionRecipeLimitsSQL:saveRecipeLimits] Error at deletion: " + e.getMessage());
            }
        }
        for (Map.Entry entry : recipeLimits.entrySet()) {
            String recipePath = (String)entry.getKey();
            PlayerRecipeLimit limit = (PlayerRecipeLimit)entry.getValue();
            if (limit.getLimit() <= 0) {
                if (limit.getCooldownTimestamp() == -1L) continue;
                try (PreparedStatement delete = SQLManager.connection().prepareStatement("DELETE FROM fusion_limits WHERE UUID = ? AND RecipePath = ?");){
                    delete.setString(1, uuid.toString());
                    delete.setString(2, recipePath);
                    delete.execute();
                }
                catch (SQLException e) {
                    Fusion.getInstance().getLogger().warning("[SQL:FusionRecipeLimitsSQL:saveRecipeLimits] Error at deletion: " + e.getMessage());
                }
                continue;
            }
            if (currentLimits.containsKey(recipePath)) {
                try (PreparedStatement update = SQLManager.connection().prepareStatement("UPDATE fusion_limits SET Amount = ?, Timestamp = ? WHERE UUID = ? AND RecipePath = ?");){
                    update.setInt(1, limit.getLimit());
                    update.setLong(2, limit.getCooldownTimestamp());
                    update.setString(3, uuid.toString());
                    update.setString(4, recipePath);
                    update.execute();
                }
                catch (SQLException e) {
                    Fusion.getInstance().getLogger().warning("[SQL:FusionRecipeLimitsSQL:saveRecipeLimits] Error at update: " + e.getMessage());
                }
                continue;
            }
            try {
                PreparedStatement insert = SQLManager.connection().prepareStatement("INSERT INTO fusion_limits(UUID, RecipePath, Amount, Timestamp) VALUES(?,?,?,?)");
                try {
                    insert.setString(1, uuid.toString());
                    insert.setString(2, recipePath);
                    insert.setInt(3, limit.getLimit());
                    insert.setLong(4, limit.getCooldownTimestamp());
                    insert.execute();
                }
                finally {
                    if (insert == null) continue;
                    insert.close();
                }
            }
            catch (SQLException e) {
                Fusion.getInstance().getLogger().warning("[SQL:FusionRecipeLimitsSQL:saveRecipeLimits] Error at insert: " + e.getMessage());
            }
        }
    }
}

