/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.sql.SQLManager;
import studio.magemonkey.fusion.data.professions.Profession;

public class FusionProfessionsSQL {
    private final String Table = "fusion_professions";

    public FusionProfessionsSQL() {
        try (PreparedStatement create = SQLManager.connection().prepareStatement("CREATE TABLE IF NOT EXISTS fusion_professions(" + SQLManager.getIdColumn() + " UUID varchar(36), Profession varchar(100),Experience numeric,Mastered boolean,Joined boolean)");){
            create.execute();
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionProfessionsSQL:FusionProfessionsSQL] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    public void setProfession(UUID uuid, Profession profession) {
        if (this.hasProfession(uuid, profession.getName())) {
            this.updateProfession(profession);
        } else {
            this.addProfession(profession);
        }
    }

    public void addProfession(Profession profession) {
        try (PreparedStatement insert = SQLManager.connection().prepareStatement("INSERT INTO fusion_professions(UUID, Profession, Experience, Mastered, Joined) VALUES(?,?,?,?,?)");){
            insert.setString(1, profession.getUuid().toString());
            insert.setString(2, profession.getName());
            insert.setDouble(3, profession.getExp());
            insert.setBoolean(4, profession.isMastered());
            insert.setBoolean(5, profession.isJoined());
            insert.execute();
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionProfessionsSQL:addProfession] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    public void updateProfession(Profession profession) {
        try (PreparedStatement update = SQLManager.connection().prepareStatement("UPDATE fusion_professions SET Experience=?, Mastered=?, Joined=? WHERE Id=?");){
            update.setDouble(1, profession.getExp());
            update.setBoolean(2, profession.isMastered());
            update.setBoolean(3, profession.isJoined());
            update.setLong(4, profession.getId());
            update.execute();
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionProfessionsSQL:updateProfession] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    public boolean hasProfession(UUID uuid, String profession) {
        boolean bl;
        block8: {
            PreparedStatement select = SQLManager.connection().prepareStatement("SELECT * FROM fusion_professions WHERE UUID=? AND Profession=?");
            try {
                select.setString(1, uuid.toString());
                select.setString(2, profession);
                bl = select.executeQuery().next();
                if (select == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (select != null) {
                        try {
                            select.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    Fusion.getInstance().getLogger().warning("[SQL:FusionProfessionsSQL:hasProfession] Something went wrong with the sql-connection: " + e.getMessage());
                    return false;
                }
            }
            select.close();
        }
        return bl;
    }

    public void removeProfession(String uuid, String profession) {
        try (PreparedStatement delete = SQLManager.connection().prepareStatement("DELETE FROM fusion_professions WHERE UUID=? AND Profession=?");){
            delete.setString(1, uuid);
            delete.setString(2, profession);
            delete.execute();
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionProfessionsSQL:removeProfession] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    public List<Profession> getProfessions(UUID uuid) {
        ArrayList<Profession> entries = new ArrayList<Profession>();
        entries.addAll(this.getProfessions(uuid, true));
        entries.addAll(this.getProfessions(uuid, false));
        return entries;
    }

    public List<Profession> getProfessions(UUID uuid, boolean joined) {
        ArrayList<Profession> arrayList;
        block9: {
            ArrayList<Profession> entries = new ArrayList<Profession>();
            PreparedStatement select = SQLManager.connection().prepareStatement("SELECT * FROM fusion_professions WHERE UUID=? AND Joined=?");
            try {
                select.setString(1, uuid.toString());
                select.setBoolean(2, joined);
                ResultSet result = select.executeQuery();
                while (result.next()) {
                    long id = result.getLong("Id");
                    String profession = result.getString("Profession");
                    long exp = result.getLong("Experience");
                    boolean mastered = result.getBoolean("Mastered");
                    boolean joined1 = result.getBoolean("Joined");
                    entries.add(new Profession(id, uuid, profession, exp, mastered, joined1));
                }
                arrayList = entries;
                if (select == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (select != null) {
                        try {
                            select.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    Fusion.getInstance().getLogger().warning("[SQL:FusionProfessionsSQL:getProfessions] Something went wrong with the sql-connection: " + e.getMessage());
                    return entries;
                }
            }
            select.close();
        }
        return arrayList;
    }
}

