/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.sql.DatabaseType;
import studio.magemonkey.fusion.cfg.sql.SQLManager;

public class FusionPlayersSQL {
    private static final String Table = "fusion_players";

    public FusionPlayersSQL() {
        try (PreparedStatement create = SQLManager.connection().prepareStatement("CREATE TABLE IF NOT EXISTS fusion_players(UUID varchar(36) PRIMARY KEY, AutoCrafting boolean DEFAULT false, Locked boolean DEFAULT false)");){
            create.execute();
            boolean lockedColumnAdded = this.alterIfLockedNotExistent();
            if (lockedColumnAdded) {
                Fusion.getInstance().getLogger().info("[SQL:FusionPlayersSQL:FusionPlayersSQL] Added 'Locked' column to 'fusion_players' table.");
            }
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionPlayersSQL:FusionPlayersSQL] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    public void setAutoCrafting(UUID uuid, boolean autoCrafting) {
        this.addPlayer(uuid);
        try (PreparedStatement update = SQLManager.connection().prepareStatement("UPDATE fusion_players SET AutoCrafting=? WHERE UUID=?");){
            update.setBoolean(1, autoCrafting);
            update.setString(2, uuid.toString());
            update.execute();
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionPlayersSQL:setAutoCrafting] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    public void setLocked(UUID uuid, boolean locked) {
        this.addPlayer(uuid);
        try (PreparedStatement update = SQLManager.connection().prepareStatement("UPDATE fusion_players SET Locked=? WHERE UUID=?");){
            update.setBoolean(1, locked);
            update.setString(2, uuid.toString());
            update.execute();
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionPlayersSQL:setLocked] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    public void clearAllLocks() {
        try (PreparedStatement update = SQLManager.connection().prepareStatement("UPDATE fusion_players SET Locked=?");){
            update.setBoolean(1, false);
            update.execute();
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionPlayersSQL:clearAllLocks] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isLocked(UUID uuid) {
        try (PreparedStatement select = SQLManager.connection().prepareStatement("SELECT Locked FROM fusion_players WHERE UUID=?");){
            select.setString(1, uuid.toString());
            ResultSet result = select.executeQuery();
            if (!result.next()) return false;
            boolean bl = result.getBoolean("Locked");
            return bl;
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionPlayersSQL:isLocked] Something went wrong with the sql-connection: " + e.getMessage());
        }
        return false;
    }

    public void addPlayer(UUID uuid) {
        DatabaseType dbType = SQLManager.getDatabaseType();
        String sql = dbType == DatabaseType.LOCAL ? "INSERT OR IGNORE INTO fusion_players(UUID, AutoCrafting, Locked) VALUES(?,?,?)" : "INSERT INTO fusion_players(UUID, AutoCrafting, Locked) VALUES(?,?,?) ON DUPLICATE KEY UPDATE UUID=UUID";
        try (PreparedStatement insert = SQLManager.connection().prepareStatement(sql);){
            insert.setString(1, uuid.toString());
            insert.setBoolean(2, false);
            insert.setBoolean(3, false);
            insert.execute();
        }
        catch (SQLException e) {
            if (e.getSQLState() != null && (e.getSQLState().startsWith("23") || e.getMessage().toLowerCase().contains("duplicate"))) {
                return;
            }
            Fusion.getInstance().getLogger().warning("[SQL:FusionPlayersSQL:addPlayer] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasPlayer(UUID uuid) {
        try (PreparedStatement select = SQLManager.connection().prepareStatement("SELECT * FROM fusion_players WHERE UUID=?");){
            select.setString(1, uuid.toString());
            ResultSet result = select.executeQuery();
            if (!result.next()) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionPlayersSQL:hasPlayer] Something went wrong with the sql-connection: " + e.getMessage());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAutoCrafting(UUID uuid) {
        try (PreparedStatement select = SQLManager.connection().prepareStatement("SELECT AutoCrafting FROM fusion_players WHERE UUID=?");){
            select.setString(1, uuid.toString());
            ResultSet result = select.executeQuery();
            if (!result.next()) return false;
            boolean bl = result.getBoolean("AutoCrafting");
            return bl;
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionPlayersSQL:isAutoCrafting] Something went wrong with the sql-connection: " + e.getMessage());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean alterIfLockedNotExistent() {
        try (PreparedStatement select = SQLManager.connection().prepareStatement("SELECT Locked FROM fusion_players LIMIT 1");){
            ResultSet result = select.executeQuery();
            if (!result.next()) return false;
            boolean throwable = false;
            return throwable;
        }
        catch (SQLException e) {
            try (PreparedStatement alter = SQLManager.connection().prepareStatement("ALTER TABLE fusion_players ADD COLUMN Locked boolean DEFAULT false");){
                alter.execute();
                boolean throwable = true;
                return throwable;
            }
            catch (SQLException ex) {
                Fusion.getInstance().getLogger().warning("[SQL:FusionPlayersSQL:alterIfLockedNotExistent] Something went wrong with the sql-connection: " + ex.getMessage());
            }
        }
        return false;
    }
}

