/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.sql;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.Cfg;
import studio.magemonkey.fusion.cfg.sql.DatabaseType;
import studio.magemonkey.fusion.cfg.sql.tables.FusionPlayersSQL;
import studio.magemonkey.fusion.cfg.sql.tables.FusionProfessionsSQL;
import studio.magemonkey.fusion.cfg.sql.tables.FusionQueuesSQL;
import studio.magemonkey.fusion.cfg.sql.tables.FusionRecipeLimitsSQL;

public class SQLManager {
    private static volatile Connection connection;
    private static FusionPlayersSQL fusionPlayersSQL;
    private static FusionProfessionsSQL fusionProfessionsSQL;
    private static FusionQueuesSQL fusionQueuesSQL;
    private static FusionRecipeLimitsSQL fusionRecipeLimitsSQL;
    private static String host;
    private static int port;
    private static String database;
    private static String user;
    private static String password;
    private static DatabaseType currentType;

    public static void init() {
        FileConfiguration cfg = Cfg.getConfig();
        DatabaseType type = DatabaseType.valueOf(cfg.getString("storage.type", "LOCAL").toUpperCase());
        host = cfg.getString("storage.host", "localhost");
        port = cfg.getInt("storage.port", 3306);
        database = cfg.getString("storage.database", "fusion");
        user = cfg.getString("storage.user", "root");
        password = cfg.getString("storage.password", "password");
        currentType = type;
        Fusion.getInstance().getLogger().info("Initializing SQLManager with type: " + String.valueOf((Object)type));
        switch (type) {
            case LOCAL: {
                connection = SQLManager.getSQLiteConnection();
                break;
            }
            case MYSQL: {
                connection = SQLManager.getMySQLConnection(host, port, database, user, password);
                break;
            }
            case MARIADB: {
                connection = SQLManager.getMariaDBConnection(host, port, database, user, password);
            }
        }
        if (connection == null) {
            Fusion.getInstance().getLogger().severe("Failed to initialize the Connection.");
        } else {
            fusionPlayersSQL = new FusionPlayersSQL();
            fusionPlayersSQL.clearAllLocks();
            fusionProfessionsSQL = new FusionProfessionsSQL();
            fusionQueuesSQL = new FusionQueuesSQL();
            fusionRecipeLimitsSQL = new FusionRecipeLimitsSQL();
            Fusion.getInstance().getLogger().info("Connection initialized successfully.");
        }
    }

    private static Connection getSQLiteConnection() {
        File databaseFile = new File(Fusion.getInstance().getDataFolder(), "database.db");
        databaseFile.getParentFile().mkdirs();
        try {
            String url = "jdbc:sqlite:" + databaseFile.getAbsolutePath();
            Connection conn = DriverManager.getConnection(url);
            Fusion.getInstance().getLogger().info("SQLite connection created at: " + databaseFile.getAbsolutePath());
            return conn;
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().severe("Error creating SQLite connection: " + e.getMessage());
            return null;
        }
    }

    private static Connection getMySQLConnection(String host, int port, String database, String user, String password) {
        try {
            String url = "jdbc:mysql://" + host + ":" + port + "/" + database;
            Connection conn = DriverManager.getConnection(url, user, password);
            Fusion.getInstance().getLogger().info("MySQL connection created for database: " + database);
            return conn;
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().severe("Error creating MySQL connection: " + e.getMessage());
            return null;
        }
    }

    private static Connection getMariaDBConnection(String host, int port, String database, String user, String password) {
        try {
            String url = "jdbc:mariadb://" + host + ":" + port + "/" + database;
            Connection conn = DriverManager.getConnection(url, user, password);
            Fusion.getInstance().getLogger().info("MariaDB connection created for database: " + database);
            return conn;
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().severe("Error creating MariaDB connection: " + e.getMessage());
            return null;
        }
    }

    public static Connection connection() throws SQLException {
        if (connection == null || connection.isClosed()) {
            SQLManager.init();
        }
        if (connection != null) {
            return connection;
        }
        Fusion.getInstance().getLogger().severe("Connection is still null after initialization attempt.");
        return null;
    }

    public static FusionPlayersSQL players() {
        if (fusionPlayersSQL == null) {
            fusionPlayersSQL = new FusionPlayersSQL();
        }
        return fusionPlayersSQL;
    }

    public static FusionProfessionsSQL professions() {
        if (fusionProfessionsSQL == null) {
            fusionProfessionsSQL = new FusionProfessionsSQL();
        }
        return fusionProfessionsSQL;
    }

    public static FusionQueuesSQL queues() {
        if (fusionQueuesSQL == null) {
            fusionQueuesSQL = new FusionQueuesSQL();
        }
        return fusionQueuesSQL;
    }

    public static FusionRecipeLimitsSQL recipeLimits() {
        if (fusionRecipeLimitsSQL == null) {
            fusionRecipeLimitsSQL = new FusionRecipeLimitsSQL();
        }
        return fusionRecipeLimitsSQL;
    }

    public static void swapToLocal() {
        Statement statement;
        try (Connection sqliteConnection = SQLManager.getSQLiteConnection();){
            statement = sqliteConnection.createStatement();
            try {
                statement.execute("DROP TABLE IF EXISTS fusion_players");
                statement.execute("DROP TABLE IF EXISTS fusion_professions");
                statement.execute("DROP TABLE IF EXISTS fusion_queues");
                statement.execute("CREATE TABLE IF NOT EXISTS fusion_players(UUID varchar(36) PRIMARY KEY, AutoCrafting boolean DEFAULT false, Locked boolean DEFAULT false)");
                statement.execute("CREATE TABLE IF NOT EXISTS fusion_professions(" + SQLManager.getIdColumn(DatabaseType.LOCAL) + " UUID varchar(36), Profession varchar(100), Experience numeric, Mastered boolean, Joined boolean)");
                statement.execute("CREATE TABLE IF NOT EXISTS fusion_queues(" + SQLManager.getIdColumn(DatabaseType.LOCAL) + " UUID varchar(36), RecipePath varchar(100), Timestamp BIGINT, CraftingTime numeric, SavedSeconds numeric)");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().severe("Error while dropping tables: " + e.getMessage());
            return;
        }
        try {
            Connection currentConnection = SQLManager.connection();
            try {
                PreparedStatement insertStatement;
                Connection sqliteConnection;
                statement = currentConnection.createStatement();
                try (ResultSet resultPlayers2 = statement.executeQuery("SELECT * FROM fusion_players");){
                    try {
                        sqliteConnection = SQLManager.getSQLiteConnection();
                        try {
                            insertStatement = sqliteConnection.prepareStatement("INSERT INTO fusion_players (UUID, AutoCrafting, Locked) VALUES (?, ?, ?)");
                            try {
                                while (resultPlayers2.next()) {
                                    insertStatement.setString(1, resultPlayers2.getString("UUID"));
                                    insertStatement.setBoolean(2, resultPlayers2.getBoolean("AutoCrafting"));
                                    try {
                                        insertStatement.setBoolean(3, resultPlayers2.getBoolean("Locked"));
                                    }
                                    catch (SQLException ignored) {
                                        insertStatement.setBoolean(3, false);
                                    }
                                    insertStatement.executeUpdate();
                                }
                            }
                            finally {
                                if (insertStatement != null) {
                                    insertStatement.close();
                                }
                            }
                        }
                        finally {
                            if (sqliteConnection != null) {
                                sqliteConnection.close();
                            }
                        }
                    }
                    catch (SQLException e) {
                        Fusion.getInstance().getLogger().severe("Error while inserting data into locale database: " + e.getMessage());
                        if (resultPlayers2 != null) {
                            resultPlayers2.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (currentConnection != null) {
                            currentConnection.close();
                        }
                        return;
                    }
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable e) {
                            Throwable resultPlayers2;
                            resultPlayers2.addSuppressed(e);
                        }
                    }
                }
                statement = currentConnection.createStatement();
                try (ResultSet resultProfessions2 = statement.executeQuery("SELECT * FROM fusion_professions");){
                    try {
                        sqliteConnection = SQLManager.getSQLiteConnection();
                        try {
                            insertStatement = sqliteConnection.prepareStatement("INSERT INTO fusion_professions (Id, UUID, Profession, Experience, Mastered, Joined) VALUES (?, ?, ?, ?, ?, ?)");
                            try {
                                SQLManager.insertProfession(resultProfessions2, insertStatement);
                            }
                            finally {
                                if (insertStatement != null) {
                                    insertStatement.close();
                                }
                            }
                        }
                        finally {
                            if (sqliteConnection != null) {
                                sqliteConnection.close();
                            }
                        }
                    }
                    catch (SQLException e) {
                        Fusion.getInstance().getLogger().severe("Error while inserting data into locale database: " + e.getMessage());
                        if (resultProfessions2 != null) {
                            resultProfessions2.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (currentConnection != null) {
                            currentConnection.close();
                        }
                        return;
                    }
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable e) {
                            Throwable resultProfessions2;
                            resultProfessions2.addSuppressed(e);
                        }
                    }
                }
                statement = currentConnection.createStatement();
                try (ResultSet resultQueues = statement.executeQuery("SELECT * FROM fusion_queues");){
                    try {
                        sqliteConnection = SQLManager.getSQLiteConnection();
                        try {
                            insertStatement = sqliteConnection.prepareStatement("INSERT INTO fusion_queues (Id, UUID, RecipePath, Timestamp, CraftingTime, SavedSeconds) VALUES (?, ?, ?, ?, ?, ?)");
                            try {
                                SQLManager.insertQueue(resultQueues, insertStatement);
                            }
                            finally {
                                if (insertStatement != null) {
                                    insertStatement.close();
                                }
                            }
                        }
                        finally {
                            if (sqliteConnection != null) {
                                sqliteConnection.close();
                            }
                        }
                    }
                    catch (SQLException e) {
                        Fusion.getInstance().getLogger().severe("Error while inserting data into locale database: " + e.getMessage());
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (currentConnection != null) {
                    try {
                        currentConnection.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().severe("Error while retrieving data from current database: " + e.getMessage());
            return;
        }
        if (Cfg.setDatabaseType(DatabaseType.LOCAL)) {
            Bukkit.getScheduler().runTaskLater((Plugin)Fusion.getInstance(), SQLManager::init, 30L);
        }
        Fusion.getInstance().getLogger().info("Swapped to LOCALE database successfully.");
    }

    public static void swapToSql() {
        try {
            Connection sqlConnection = SQLManager.getMySQLConnection(host, port, database, user, password);
            try (Statement sqlStatement = sqlConnection.createStatement();){
                sqlStatement.execute("DROP TABLE IF EXISTS fusion_players, fusion_professions, fusion_queues");
                sqlStatement.execute("CREATE TABLE IF NOT EXISTS fusion_players(UUID varchar(36) PRIMARY KEY, AutoCrafting boolean DEFAULT false, Locked boolean DEFAULT false)");
                sqlStatement.execute("CREATE TABLE IF NOT EXISTS fusion_professions(" + SQLManager.getIdColumn(DatabaseType.MYSQL) + " UUID varchar(36), Profession varchar(100), Experience numeric, Mastered boolean, Joined boolean)");
                sqlStatement.execute("CREATE TABLE IF NOT EXISTS fusion_queues(" + SQLManager.getIdColumn(DatabaseType.MYSQL) + " UUID varchar(36), RecipePath varchar(100), Timestamp BIGINT, CraftingTime numeric, SavedSeconds numeric)");
                try (Connection sqliteConnection = SQLManager.getSQLiteConnection();
                     Statement localStatement = sqliteConnection.createStatement();){
                    ResultSet resultPlayers = localStatement.executeQuery("SELECT * FROM fusion_players");
                    try (PreparedStatement insert = sqlConnection.prepareStatement("INSERT INTO fusion_players (UUID, AutoCrafting, Locked) VALUES (?, ?, ?)");){
                        while (resultPlayers.next()) {
                            insert.setString(1, resultPlayers.getString("UUID"));
                            insert.setBoolean(2, resultPlayers.getBoolean("AutoCrafting"));
                            try {
                                insert.setBoolean(3, resultPlayers.getBoolean("Locked"));
                            }
                            catch (SQLException ignored) {
                                insert.setBoolean(3, false);
                            }
                            insert.executeUpdate();
                        }
                    }
                    ResultSet resultProfessions = localStatement.executeQuery("SELECT * FROM fusion_professions");
                    SQLManager.insertProfessions(sqlConnection, resultProfessions);
                    ResultSet resultQueues = localStatement.executeQuery("SELECT * FROM fusion_queues");
                    SQLManager.insertQueues(sqlConnection, resultQueues);
                }
                catch (SQLException e) {
                    Fusion.getInstance().getLogger().severe("Error while retrieving data from local database: " + e.getMessage());
                    if (sqlStatement != null) {
                        sqlStatement.close();
                    }
                    if (sqlConnection != null) {
                        sqlConnection.close();
                    }
                    return;
                }
            }
            finally {
                if (sqlConnection != null) {
                    try {
                        sqlConnection.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().severe("Error while managing SQL connection or executing statements: " + e.getMessage());
            return;
        }
        if (Cfg.setDatabaseType(DatabaseType.MYSQL)) {
            Bukkit.getScheduler().runTaskLater((Plugin)Fusion.getInstance(), SQLManager::init, 30L);
        }
        Fusion.getInstance().getLogger().info("Swapped to SQL database successfully.");
    }

    private static void insertPlayers(Connection connection, ResultSet resultSet) throws SQLException {
        String insertQuery = "INSERT INTO fusion_players (UUID, AutoCrafting, Locked) VALUES (?, ?, ?)";
        try (PreparedStatement preparedStatement = connection.prepareStatement(insertQuery);){
            while (resultSet.next()) {
                preparedStatement.setString(1, resultSet.getString("UUID"));
                preparedStatement.setBoolean(2, resultSet.getBoolean("AutoCrafting"));
                try {
                    preparedStatement.setBoolean(3, resultSet.getBoolean("Locked"));
                }
                catch (SQLException ignored) {
                    preparedStatement.setBoolean(3, false);
                }
                preparedStatement.executeUpdate();
            }
        }
    }

    private static void insertProfessions(Connection connection, ResultSet resultSet) throws SQLException {
        String insertQuery = "INSERT INTO fusion_professions (Id, UUID, Profession, Experience, Mastered, Joined) VALUES (?, ?, ?, ?, ?, ?)";
        try (PreparedStatement preparedStatement = connection.prepareStatement(insertQuery);){
            SQLManager.insertProfession(resultSet, preparedStatement);
        }
    }

    private static void insertQueues(Connection connection, ResultSet resultSet) throws SQLException {
        String insertQuery = "INSERT INTO fusion_queues (Id, UUID, RecipePath, Timestamp, CraftingTime, SavedSeconds) VALUES (?, ?, ?, ?, ?, ?)";
        try (PreparedStatement preparedStatement = connection.prepareStatement(insertQuery);){
            SQLManager.insertQueue(resultSet, preparedStatement);
        }
    }

    private static void insertQueue(ResultSet resultQueues, PreparedStatement insertStatement) throws SQLException {
        while (resultQueues.next()) {
            insertStatement.setLong(1, resultQueues.getLong("Id"));
            insertStatement.setString(2, resultQueues.getString("UUID"));
            insertStatement.setString(3, resultQueues.getString("RecipePath"));
            insertStatement.setLong(4, resultQueues.getLong("Timestamp"));
            insertStatement.setDouble(5, resultQueues.getDouble("CraftingTime"));
            insertStatement.setDouble(6, resultQueues.getDouble("SavedSeconds"));
            insertStatement.executeUpdate();
        }
    }

    private static void insertProfession(ResultSet resultProfessions, PreparedStatement insertStatement) throws SQLException {
        while (resultProfessions.next()) {
            insertStatement.setLong(1, resultProfessions.getLong("Id"));
            insertStatement.setString(2, resultProfessions.getString("UUID"));
            insertStatement.setString(3, resultProfessions.getString("Profession"));
            insertStatement.setDouble(4, resultProfessions.getDouble("Experience"));
            insertStatement.setBoolean(5, resultProfessions.getBoolean("Mastered"));
            insertStatement.setBoolean(6, resultProfessions.getBoolean("Joined"));
            insertStatement.executeUpdate();
        }
    }

    public static String getIdColumn(DatabaseType type) {
        if (type == DatabaseType.LOCAL) {
            return "Id INTEGER PRIMARY KEY AUTOINCREMENT,";
        }
        return "Id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,";
    }

    public static String getIdColumn() {
        return SQLManager.getIdColumn(currentType == null ? DatabaseType.MYSQL : currentType);
    }

    public static DatabaseType getDatabaseType() {
        return currentType;
    }

    @Generated
    public static Connection getConnection() {
        return connection;
    }
}

