/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.hooks.divinity;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.hooks.ItemGenEntry;
import studio.magemonkey.fusion.cfg.hooks.divinity.DivinityCfg;

public class DivinityService {
    public static DivinityCfg divinityCfg;
    public static Map<String, ItemGenEntry> itemGenResults;

    public static boolean isCached(String itemId) {
        return itemGenResults.containsKey(itemId);
    }

    public static boolean cache(String itemId, Consumer<ItemGenEntry> callback) {
        ItemGeneratorManager.GeneratorItem item = (ItemGeneratorManager.GeneratorItem)Divinity.getInstance().getModuleCache().getTierManager().getItemById(itemId);
        if (item == null) {
            Fusion.getInstance().getLogger().warning("Failed to cache item " + itemId + " from Divinity as it does not exist.");
            return false;
        }
        itemGenResults.put(itemId, new ItemGenEntry(item));
        if (callback != null) {
            callback.accept(itemGenResults.get(itemId));
        }
        return true;
    }

    public static void init() {
        itemGenResults.clear();
        divinityCfg = new DivinityCfg();
        Fusion.getInstance().getLogger().info("Divinity Service loaded.");
    }

    static {
        itemGenResults = new HashMap<String, ItemGenEntry>();
    }
}

