/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.hooks.divinity;

import lombok.Generated;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.fusion.cfg.hooks.ItemGenEntry;
import studio.magemonkey.fusion.cfg.hooks.divinity.DivinityService;
import studio.magemonkey.fusion.util.ChatUT;

public class DivinityRecipeMeta {
    private final String originalRecipeName;
    private final ItemGenEntry entry;
    private final int level;
    private final int amount;
    private final ItemType type;
    private final String itemName;
    private ItemStack icon;

    public DivinityRecipeMeta(String originalRecipeName, ItemGenEntry entry, int level, int amount, ItemType type, String itemName) {
        this.originalRecipeName = originalRecipeName;
        this.entry = entry;
        this.level = level;
        this.amount = amount;
        this.type = type;
        this.itemName = itemName;
    }

    public ItemStack generateItem() {
        ItemStack item = this.entry.getReference().create(this.level, -1, this.type);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatUT.hexString(this.itemName));
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack getIcon() {
        if (this.icon == null) {
            this.icon = DivinityService.divinityCfg.getRecipeIcon(this.entry, this.itemName, this.type, this.level);
        }
        return this.icon;
    }

    @Generated
    public String getOriginalRecipeName() {
        return this.originalRecipeName;
    }

    @Generated
    public ItemGenEntry getEntry() {
        return this.entry;
    }

    @Generated
    public int getLevel() {
        return this.level;
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }

    @Generated
    public ItemType getType() {
        return this.type;
    }

    @Generated
    public String getItemName() {
        return this.itemName;
    }
}

