/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.hooks.divinity;

import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.codex.util.messages.MessageUtil;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.YamlParser;
import studio.magemonkey.fusion.cfg.hooks.ItemGenEntry;
import studio.magemonkey.fusion.util.ChatUT;

public class DivinityCfg {
    private final YamlParser config = YamlParser.loadOrExtract((JavaPlugin)Fusion.getInstance(), "Hooks/Divinity.yml");

    public ItemStack getRecipeIcon(ItemGenEntry entry, String name, ItemType type, int level) {
        Material material = Material.valueOf((String)this.config.getString("ItemGenerator.RecipeIcon.material", "$<material>").replace(MessageUtil.getReplacement((String)"material"), type.create().getType().toString()));
        String itemName = ChatUT.hexString(this.config.getString("ItemGenerator.RecipeIcon.name", "$<name>").replace(MessageUtil.getReplacement((String)"name"), name));
        int customModelData = -1;
        if (entry.getReference().create(level, -1, type).getItemMeta().hasCustomModelData()) {
            customModelData = entry.getReference().create(level, -1, type).getItemMeta().getCustomModelData();
        }
        List<String> lore = this.config.getStringList("ItemGenerator.RecipeIcon.lore");
        this.replaceLore(entry, level, lore);
        ItemStack item = ItemBuilder.newItem((Material)material).name(itemName).lore(lore).build();
        if (customModelData > 0) {
            ItemMeta meta = item.getItemMeta();
            meta.setCustomModelData(Integer.valueOf(customModelData));
            item.setItemMeta(meta);
        }
        return item;
    }

    protected void replaceLore(ItemGenEntry entry, int level, List<String> lore) {
        String chanceLevels = level < 0 ? this.getValueFormat("levels", entry.getMinLevel(), entry.getMaxLevel()) : this.getSingleValueFormat("levels", level);
        String chanceEnchants = this.getValueFormat("enchants", entry.getMinEnchantments(), entry.getMaxEnchantments());
        String chanceDamageTypes = this.getValueFormat("damage_types", entry.getMinDamageTypes(), entry.getMaxDamageTypes());
        String chanceDefenseTypes = this.getValueFormat("defense_types", entry.getMinDefenseTypes(), entry.getMaxDefenseTypes());
        String chanceItemStats = this.getValueFormat("item_stats", entry.getMinItemStats(), entry.getMaxItemStats());
        String chanceGemSockets = this.getValueFormat("gem_sockets", entry.getMinGems(), entry.getMaxGems());
        String chanceEssenceSockets = this.getValueFormat("essence_sockets", entry.getMinEssences(), entry.getMaxEssences());
        String chanceRuneSockets = this.getValueFormat("rune_sockets", entry.getMinRunes(), entry.getMaxRunes());
        String chanceFabledAttributes = this.getValueFormat("fabled_attributes", entry.getMinFabledAttributes(), entry.getMaxFabledAttributes());
        String chanceSkills = this.getValueFormat("skills", entry.getMinSkill(), entry.getMaxSkill());
        for (int i = 0; i < lore.size(); ++i) {
            String loreEntry;
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"lore"))) {
                lore.remove(i);
                for (String line : entry.getReference().getLore()) {
                    Pattern pattern = Pattern.compile("%[a-zA-Z0-9_]+%");
                    if (line.isEmpty() || pattern.matcher(line).find()) continue;
                    lore.add(i++, ChatUT.hexString(line));
                }
                --i;
                continue;
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"levels"))) {
                loreEntry = lore.get(i);
                if (chanceLevels == null) {
                    lore.remove(i);
                    --i;
                    continue;
                }
                lore.set(i, loreEntry.replace(MessageUtil.getReplacement((String)"levels"), ChatUT.hexString(chanceLevels)));
                continue;
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"enchants"))) {
                loreEntry = lore.get(i);
                if (chanceEnchants == null) {
                    lore.remove(i);
                    --i;
                    continue;
                }
                lore.set(i, loreEntry.replace(MessageUtil.getReplacement((String)"enchants"), ChatUT.hexString(chanceEnchants)));
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"damage_types"))) {
                loreEntry = lore.get(i);
                if (chanceDamageTypes == null) {
                    lore.remove(i);
                    --i;
                    continue;
                }
                lore.set(i, loreEntry.replace(MessageUtil.getReplacement((String)"damage_types"), ChatUT.hexString(chanceDamageTypes)));
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"defense_types"))) {
                loreEntry = lore.get(i);
                if (chanceDefenseTypes == null) {
                    lore.remove(i);
                    --i;
                    continue;
                }
                lore.set(i, loreEntry.replace(MessageUtil.getReplacement((String)"defense_types"), ChatUT.hexString(chanceDefenseTypes)));
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"item_stats"))) {
                loreEntry = lore.get(i);
                if (chanceItemStats == null) {
                    lore.remove(i);
                    --i;
                    continue;
                }
                lore.set(i, loreEntry.replace(MessageUtil.getReplacement((String)"item_stats"), ChatUT.hexString(chanceItemStats)));
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"gem_sockets"))) {
                loreEntry = lore.get(i);
                if (chanceGemSockets == null) {
                    lore.remove(i);
                    --i;
                    continue;
                }
                lore.set(i, loreEntry.replace(MessageUtil.getReplacement((String)"gem_sockets"), ChatUT.hexString(chanceGemSockets)));
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"essence_sockets"))) {
                loreEntry = lore.get(i);
                if (chanceEssenceSockets == null) {
                    lore.remove(i);
                    --i;
                    continue;
                }
                lore.set(i, loreEntry.replace(MessageUtil.getReplacement((String)"essence_sockets"), ChatUT.hexString(chanceEssenceSockets)));
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"rune_sockets"))) {
                loreEntry = lore.get(i);
                if (chanceRuneSockets == null) {
                    lore.remove(i);
                    --i;
                    continue;
                }
                lore.set(i, loreEntry.replace(MessageUtil.getReplacement((String)"rune_sockets"), ChatUT.hexString(chanceRuneSockets)));
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"fabled_attributes"))) {
                loreEntry = lore.get(i);
                if (chanceFabledAttributes == null) {
                    lore.remove(i);
                    --i;
                    continue;
                }
                lore.set(i, loreEntry.replace(MessageUtil.getReplacement((String)"fabled_attributes"), ChatUT.hexString(chanceFabledAttributes)));
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"skills"))) {
                loreEntry = lore.get(i);
                if (chanceSkills == null) {
                    lore.remove(i);
                    --i;
                    continue;
                }
                lore.set(i, loreEntry.replace(MessageUtil.getReplacement((String)"skills"), ChatUT.hexString(chanceSkills)));
            }
            lore.set(i, ChatUT.hexString(lore.get(i)));
        }
    }

    private String getValueFormat(String path, int min, int max) {
        if (min <= 1 && max <= 1) {
            return null;
        }
        if (min == max) {
            return ChatUT.hexString(this.getSingleValueFormat(path, min));
        }
        return ChatUT.hexString(this.getRangeValueFormat(path, min, max));
    }

    private String getSingleValueFormat(String path, int amount) {
        return this.config.getString("ItemGenerator.RecipeIcon.LoreFormatting.single." + path, path + " $<amount>").replace(MessageUtil.getReplacement((String)"amount"), String.valueOf(amount));
    }

    private String getRangeValueFormat(String path, int min, int max) {
        return this.config.getString("ItemGenerator.RecipeIcon.LoreFormatting.range." + path, path + " $<min> - $<max>").replace(MessageUtil.getReplacement((String)"min"), String.valueOf(min)).replace(MessageUtil.getReplacement((String)"max"), String.valueOf(max));
    }
}

