/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.hooks;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;
import studio.magemonkey.divinity.modules.list.itemgenerator.api.IAttributeGenerator;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.DamageAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DefenseAttribute;
import studio.magemonkey.divinity.stats.items.attributes.FabledAttribute;
import studio.magemonkey.divinity.stats.items.attributes.SocketAttribute;
import studio.magemonkey.divinity.stats.tiers.Tier;
import studio.magemonkey.fusion.cfg.hooks.divinity.DivinityUT;

public class ItemGenEntry {
    ItemGeneratorManager.GeneratorItem reference;
    private final int minLevel;
    private final int maxLevel;
    private final int minEnchantments;
    private final int maxEnchantments;
    private int minDamageTypes = -1;
    private int maxDamageTypes = -1;
    private int minDefenseTypes = -1;
    private int maxDefenseTypes = -1;
    private int minItemStats = -1;
    private int maxItemStats = -1;
    private int minGems = -1;
    private int maxGems = -1;
    private int minEssences = -1;
    private int maxEssences = -1;
    private int minRunes = -1;
    private int maxRunes = -1;
    private int minFabledAttributes = -1;
    private int maxFabledAttributes = -1;
    private final int minSkill;
    private final int maxSkill;
    private final Collection<ItemType> materials;
    private final Tier tier;

    public ItemGenEntry(ItemGeneratorManager.GeneratorItem entry) {
        this.reference = entry;
        this.minLevel = entry.getMinLevel();
        this.maxLevel = entry.getMaxLevel();
        this.minEnchantments = entry.getMinEnchantments();
        this.maxEnchantments = entry.getMaxEnchantments();
        for (IAttributeGenerator attribute : entry.getAttributeGenerators()) {
            if (attribute instanceof DamageAttribute) {
                this.minDamageTypes = attribute.getMinAmount();
                this.maxDamageTypes = attribute.getMaxAmount();
                continue;
            }
            if (attribute instanceof DefenseAttribute) {
                this.minDefenseTypes = attribute.getMinAmount();
                this.maxDefenseTypes = attribute.getMaxAmount();
                continue;
            }
            if (attribute instanceof ItemStats) {
                this.minItemStats = attribute.getMinAmount();
                this.maxItemStats = attribute.getMaxAmount();
                continue;
            }
            if (attribute instanceof SocketAttribute) {
                SocketAttribute socketAttribute = (SocketAttribute)attribute;
                switch (socketAttribute.getType()) {
                    case GEM: {
                        this.minGems = attribute.getMinAmount();
                        this.maxGems = attribute.getMaxAmount();
                        break;
                    }
                    case ESSENCE: {
                        this.minEssences = attribute.getMinAmount();
                        this.maxEssences = attribute.getMaxAmount();
                        break;
                    }
                    case RUNE: {
                        this.minRunes = attribute.getMinAmount();
                        this.maxRunes = attribute.getMaxAmount();
                    }
                }
                continue;
            }
            if (!(attribute instanceof FabledAttribute)) continue;
            this.minFabledAttributes = attribute.getMinAmount();
            this.maxFabledAttributes = attribute.getMaxAmount();
        }
        this.minSkill = entry.getAbilityGenerator().getMinAmount();
        this.maxSkill = entry.getAbilityGenerator().getMaxAmount();
        this.materials = entry.getMaterialsList();
        this.tier = entry.getTier();
    }

    public Map<ItemType, Set<String>> loadNames(ItemType type, int level) {
        LinkedHashMap<ItemType, Set<String>> names = new LinkedHashMap<ItemType, Set<String>>();
        if (type == null) {
            for (ItemType material : this.materials) {
                names.put(material, DivinityUT.getAllCombinations(this.reference, material.create().getType(), this.tier, level));
            }
        } else {
            names.put(type, DivinityUT.getAllCombinations(this.reference, type.create().getType(), this.tier, level));
        }
        return names;
    }

    @Generated
    public ItemGeneratorManager.GeneratorItem getReference() {
        return this.reference;
    }

    @Generated
    public int getMinLevel() {
        return this.minLevel;
    }

    @Generated
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Generated
    public int getMinEnchantments() {
        return this.minEnchantments;
    }

    @Generated
    public int getMaxEnchantments() {
        return this.maxEnchantments;
    }

    @Generated
    public int getMinDamageTypes() {
        return this.minDamageTypes;
    }

    @Generated
    public int getMaxDamageTypes() {
        return this.maxDamageTypes;
    }

    @Generated
    public int getMinDefenseTypes() {
        return this.minDefenseTypes;
    }

    @Generated
    public int getMaxDefenseTypes() {
        return this.maxDefenseTypes;
    }

    @Generated
    public int getMinItemStats() {
        return this.minItemStats;
    }

    @Generated
    public int getMaxItemStats() {
        return this.maxItemStats;
    }

    @Generated
    public int getMinGems() {
        return this.minGems;
    }

    @Generated
    public int getMaxGems() {
        return this.maxGems;
    }

    @Generated
    public int getMinEssences() {
        return this.minEssences;
    }

    @Generated
    public int getMaxEssences() {
        return this.maxEssences;
    }

    @Generated
    public int getMinRunes() {
        return this.minRunes;
    }

    @Generated
    public int getMaxRunes() {
        return this.maxRunes;
    }

    @Generated
    public int getMinFabledAttributes() {
        return this.minFabledAttributes;
    }

    @Generated
    public int getMaxFabledAttributes() {
        return this.maxFabledAttributes;
    }

    @Generated
    public int getMinSkill() {
        return this.minSkill;
    }

    @Generated
    public int getMaxSkill() {
        return this.maxSkill;
    }

    @Generated
    public Collection<ItemType> getMaterials() {
        return this.materials;
    }

    @Generated
    public Tier getTier() {
        return this.tier;
    }
}

