/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.editors.professions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.api.DelayedCommand;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.codex.util.messages.MessageUtil;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.YamlParser;
import studio.magemonkey.fusion.data.professions.ProfessionSettings;
import studio.magemonkey.fusion.data.recipes.Recipe;
import studio.magemonkey.fusion.util.ChatUT;

public class RecipeIconEditorCfg {
    private final YamlParser config = YamlParser.loadOrExtract((JavaPlugin)Fusion.getInstance(), "Editors/professions/RecipeIconEditor.yml");

    public String getTitle() {
        return ChatUT.hexString(this.config.getString("title", "&2Recipe Icon Editor"));
    }

    public Map<String, ItemStack> getIcons(Recipe recipe) {
        HashMap<String, ItemStack> icons = new HashMap<String, ItemStack>();
        for (String icon : this.config.getConfigurationSection("icons").getKeys(false)) {
            icons.put(icon, this.getIcon(recipe, icon));
        }
        return icons;
    }

    public ItemStack getIcon(Recipe recipe, String icon) {
        Material material = Material.valueOf((String)this.config.getString("icons." + icon + ".material", "STONE").toUpperCase());
        int amount = this.config.getInt("icons." + icon + ".amount", 1);
        int durability = this.config.getInt("icons." + icon + ".durability", 0);
        boolean unbreakable = this.config.getBoolean("icon." + icon + ".unbreakable", false);
        String name = this.config.getString("icons." + icon + ".name", "&cInvalid Item: &4" + icon);
        List<String> lore = this.config.getStringList("icons." + icon + ".lore");
        ProfessionSettings settings = recipe.getSettings();
        for (int i = 0; i < lore.size(); ++i) {
            int newLines;
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"lore"))) {
                lore.remove(i);
                if (settings.getLore().isEmpty()) continue;
                newLines = 1;
                for (String string : settings.getLore()) {
                    lore.add(i - 1 + newLines, ChatUT.hexString(string));
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"commands"))) {
                lore.remove(i);
                newLines = 1;
                for (DelayedCommand delayedCommand : settings.getCommandsOnClick()) {
                    lore.add(i - 1 + newLines, this.config.getString("subEditor.icons.commands.commandPrefix", "&7- &a$<command>").replace(MessageUtil.getReplacement((String)"command"), delayedCommand.getCmd()).replace(MessageUtil.getReplacement((String)"delay"), String.valueOf(delayedCommand.getDelay())).replace(MessageUtil.getReplacement((String)"caster"), delayedCommand.getAs().name()));
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"enchants"))) {
                lore.remove(i);
                newLines = 1;
                for (Enchantment enchantment : settings.getEnchantments().keySet()) {
                    lore.add(i - 1 + newLines, this.config.getString("subEditor.icons.enchants.enchantPrefix", "&7- &a$<enchant> $<level>").replace(MessageUtil.getReplacement((String)"enchant"), enchantment.getKey().getKey()).replace(MessageUtil.getReplacement((String)"level"), String.valueOf(settings.getEnchantments().get(enchantment))));
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"flags"))) {
                lore.remove(i);
                newLines = 1;
                for (ItemFlag itemFlag : settings.getFlags()) {
                    lore.add(i - 1 + newLines, this.config.getString("subEditor.icons.flags.flagPrefix", "&7- &a$<flag>").replace(MessageUtil.getReplacement((String)"flag"), itemFlag.name().toLowerCase()));
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            lore.set(i, ChatUT.hexString(lore.get(i).replace(MessageUtil.getReplacement((String)"name"), settings.getName() != null ? settings.getName() : "").replace(MessageUtil.getReplacement((String)"customModelData"), String.valueOf(settings.getCustomModelData())).replace(MessageUtil.getReplacement((String)"unbreakable"), String.valueOf(settings.isUnbreakable())).replace(MessageUtil.getReplacement((String)"color"), settings.getColor() != null ? settings.getColor() : "").replace(MessageUtil.getReplacement((String)"cancelDrop"), String.valueOf(settings.isCancelDrop()))));
        }
        Map<Enchantment, Integer> enchants = this.config.getEnchantmentSection("icons." + icon + ".enchants");
        List<ItemFlag> flags = this.config.getItemFlags("icons." + icon + ".flags");
        ItemFlag[] itemFlags = flags.toArray(new ItemFlag[0]);
        return ItemBuilder.newItem((Material)material).amount(amount).durability(durability).unbreakable(unbreakable).name(ChatUT.hexString(name)).lore(lore).enchant(enchants).flag(itemFlags).build();
    }
}

