/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.editors.professions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.api.DelayedCommand;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.codex.util.messages.MessageUtil;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.YamlParser;
import studio.magemonkey.fusion.data.professions.ProfessionConditions;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.data.recipes.Recipe;
import studio.magemonkey.fusion.data.recipes.RecipeItem;
import studio.magemonkey.fusion.util.ChatUT;

public class RecipeEditorCfg {
    private final YamlParser config = YamlParser.loadOrExtract((JavaPlugin)Fusion.getInstance(), "Editors/professions/RecipeEditor.yml");

    public String getTitle() {
        return ChatUT.hexString(this.config.getString("title", "&2Recipes"));
    }

    public Map<String, ItemStack> getIcons(CraftingTable table) {
        HashMap<String, ItemStack> icons = new HashMap<String, ItemStack>();
        for (String icon : this.config.getConfigurationSection("icons").getKeys(false)) {
            if (icon.equalsIgnoreCase("recipeItem")) continue;
            icons.put(icon, this.getIcon(table, icon));
        }
        return icons;
    }

    public ItemStack getIcon(CraftingTable table, String icon) {
        Material material = Material.valueOf((String)this.config.getString("icons." + icon + ".material", "STONE").toUpperCase());
        int amount = this.config.getInt("icons." + icon + ".amount", 1);
        int durability = this.config.getInt("icons." + icon + ".durability", 0);
        boolean unbreakable = this.config.getBoolean("icon." + icon + ".unbreakable", false);
        String name = this.config.getString("icons." + icon + ".name", "&cInvalid Item: &4" + icon);
        List<String> lore = this.config.getStringList("icons." + icon + ".lore");
        for (int i = 0; i < lore.size(); ++i) {
            lore.set(i, ChatUT.hexString(lore.get(i).replace(MessageUtil.getReplacement((String)"name"), table.getInventoryName()).replace(MessageUtil.getReplacement((String)"profession"), table.getName()).replace(MessageUtil.getReplacement((String)"masteryUnlock"), String.valueOf(table.getMasteryUnlock())).replace(MessageUtil.getReplacement((String)"masteryCost"), String.valueOf(table.getMasteryFee())).replace(MessageUtil.getReplacement((String)"useCategories"), String.valueOf(table.getUseCategories()))));
        }
        Map<Enchantment, Integer> enchants = this.config.getEnchantmentSection("icons." + icon + ".enchants");
        List<ItemFlag> flags = this.config.getItemFlags("icons." + icon + ".flags");
        ItemFlag[] itemFlags = flags.toArray(new ItemFlag[0]);
        return ItemBuilder.newItem((Material)material).amount(amount).durability(durability).unbreakable(unbreakable).name(ChatUT.hexString(name)).lore(lore).enchant(enchants).flag(itemFlags).build();
    }

    public ItemStack getRecipeIcon(Recipe recipe) {
        ItemStack result = recipe.getSettings().getRecipeItem().getItemStack();
        String name = this.config.getString("icons.recipeItem.name", "&9$<recipe.name>").replace(MessageUtil.getReplacement((String)"recipe.name"), recipe.getName());
        List<String> lore = this.config.getStringList("icons.recipeItem.lore");
        for (int i = 0; i < lore.size(); ++i) {
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"recipe.lore"))) {
                lore.remove(i);
                if (result == null || result.getItemMeta() == null || result.getItemMeta().getLore() == null) continue;
                int newLines = 1;
                for (String line : result.getItemMeta().getLore()) {
                    lore.add(i - 1 + newLines, ChatUT.hexString(line));
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            lore.set(i, ChatUT.hexString(lore.get(i).replace(MessageUtil.getReplacement((String)"recipe.result"), result != null && !result.getType().isAir() && result.hasItemMeta() ? result.getItemMeta().getDisplayName() : result.getType().name())).replace(MessageUtil.getReplacement((String)"conditions.permission"), recipe.getConditions().getPermission() == null ? this.getUnsetFormat() : recipe.getConditions().getPermission()));
        }
        return ItemBuilder.newItem((ItemStack)result).name(name).lore(lore).build();
    }

    public String getSubTitle(String recipeName) {
        String title = this.config.getString("subEditor.title", "&2Recipe Item &a$<recipe.name>");
        title = title.replace(MessageUtil.getReplacement((String)"recipe.name"), recipeName);
        return ChatUT.hexString(title);
    }

    public Map<String, ItemStack> getSubIcons(Recipe recipe) {
        HashMap<String, ItemStack> icons = new HashMap<String, ItemStack>();
        for (String icon : this.config.getConfigurationSection("subEditor.icons").getKeys(false)) {
            icons.put(icon, this.getSubIcon(recipe, icon));
        }
        return icons;
    }

    public ItemStack getSubIcon(Recipe recipe, String icon) {
        ItemStack result = recipe.getSettings().getRecipeItem().getItemStack();
        String resultName = recipe.getSettings().getIconNamespace();
        Material material = Material.valueOf((String)this.config.getString("subEditor.icons." + icon + ".material", "$<material>").replace(MessageUtil.getReplacement((String)"material"), recipe.getSettings().getRecipeItem().getItemStack().getType().name()).toUpperCase());
        int amount = this.config.getInt("subEditor.icons." + icon + ".amount", 1);
        int durability = this.config.getInt("subEditor.icons." + icon + ".durability", 0);
        boolean unbreakable = this.config.getBoolean("subEditor.icon." + icon + ".unbreakable", false);
        String name = this.config.getString("subEditor.icons." + icon + ".name", "&cInvalid Item: &4" + icon);
        List<String> lore = this.config.getStringList("subEditor.icons." + icon + ".lore");
        ProfessionConditions conditions = recipe.getConditions();
        for (int i = 0; i < lore.size(); ++i) {
            int newLines;
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"result.lore"))) {
                lore.remove(i);
                if (result.getItemMeta() == null || result.getItemMeta().getLore() == null) continue;
                newLines = 1;
                for (String string : result.getItemMeta().getLore()) {
                    lore.add(i - 1 + newLines, ChatUT.hexString(string));
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"commands"))) {
                lore.remove(i);
                newLines = 1;
                for (DelayedCommand delayedCommand : recipe.getResults().getCommands()) {
                    lore.add(i - 1 + newLines, this.config.getString("subEditor.icons.commands.commandPrefix", "&7- &a$<command>").replace(MessageUtil.getReplacement((String)"command"), delayedCommand.getCmd()).replace(MessageUtil.getReplacement((String)"delay"), String.valueOf(delayedCommand.getDelay())).replace(MessageUtil.getReplacement((String)"caster"), delayedCommand.getAs().name()));
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"items"))) {
                lore.remove(i);
                newLines = 1;
                for (String string : recipe.getResults().getItemNames()) {
                    lore.add(i - 1 + newLines, this.config.getString("subEditor.icons.items.itemPrefix", "&7- &a$<item>").replace(MessageUtil.getReplacement((String)"item"), string));
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"ingredients"))) {
                lore.remove(i);
                newLines = 1;
                for (RecipeItem recipeItem : recipe.getConditions().getRequiredItems()) {
                    ItemStack patternItem = recipeItem.getItemStack();
                    String itemName = patternItem.hasItemMeta() ? patternItem.getItemMeta().getDisplayName() : patternItem.getType().name();
                    lore.add(i - 1 + newLines, this.config.getString("subEditor.icons.ingredients.ingredientPrefix", "&7- &2$<ingredient.amount>x &a$<ingredient.name>").replace(MessageUtil.getReplacement((String)"ingredient.name"), itemName).replace(MessageUtil.getReplacement((String)"ingredient.amount"), String.valueOf(recipeItem.getItemStack().getAmount())));
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"conditions"))) {
                lore.remove(i);
                newLines = 1;
                for (Map.Entry entry : conditions.getFullConditions().entrySet()) {
                    for (Map.Entry condition : ((Map)entry.getValue()).entrySet()) {
                        lore.add(i - 1 + newLines, this.config.getString("subEditor.icons.conditions.conditionPrefix", "&7- &a$<condition>").replace(MessageUtil.getReplacement((String)"condition"), this.getConditionFormat((String)entry.getKey(), (String)condition.getKey(), (Integer)condition.getValue())));
                        ++newLines;
                    }
                }
                i += newLines;
                continue;
            }
            lore.set(i, ChatUT.hexString(lore.get(i).replace(MessageUtil.getReplacement((String)"name"), recipe.getName()).replace(MessageUtil.getReplacement((String)"results.resultItem"), resultName).replace(MessageUtil.getReplacement((String)"results.professionExp"), String.valueOf(recipe.getResults().getProfessionExp())).replace(MessageUtil.getReplacement((String)"results.vanillaExp"), String.valueOf(recipe.getResults().getVanillaExp())).replace(MessageUtil.getReplacement((String)"costs.money"), String.valueOf(conditions.getMoneyCost())).replace(MessageUtil.getReplacement((String)"costs.experience"), String.valueOf(conditions.getExpCost())).replace(MessageUtil.getReplacement((String)"craftingTime"), String.valueOf(recipe.getCraftingTime())).replace(MessageUtil.getReplacement((String)"craftingLimit"), String.valueOf(recipe.getCraftingLimit())).replace(MessageUtil.getReplacement((String)"craftingLimitCooldown"), String.valueOf(recipe.getCraftingLimitCooldown())).replace(MessageUtil.getReplacement((String)"conditions.professionLevel"), String.valueOf(recipe.getConditions().getProfessionLevel())).replace(MessageUtil.getReplacement((String)"conditions.mastery"), String.valueOf(recipe.getConditions().isMastery())).replace(MessageUtil.getReplacement((String)"conditions.permission"), String.valueOf(recipe.getConditions().getPermission())).replace(MessageUtil.getReplacement((String)"category"), recipe.getCategory() == null ? "master" : recipe.getCategory())).replace(MessageUtil.getReplacement((String)"hidings.noPermission"), recipe.getSettings().getHideNoPermission() == null ? this.getUnsetFormat() : String.valueOf(recipe.getSettings().getHideNoPermission())).replace(MessageUtil.getReplacement((String)"hidings.recipeLimitReached"), recipe.getSettings().getHideRecipeLimitReached() == null ? this.getUnsetFormat() : String.valueOf(recipe.getSettings().getHideRecipeLimitReached())));
        }
        Map<Enchantment, Integer> enchants = this.config.getEnchantmentSection("subEditor.icons." + icon + ".enchants");
        List<ItemFlag> flags = this.config.getItemFlags("subEditor.icons." + icon + ".flags");
        ItemFlag[] itemFlags = flags.toArray(new ItemFlag[0]);
        return ItemBuilder.newItem((Material)material).amount(icon.equals("resultItem") ? recipe.getSettings().getRecipeItem().getAmount() : amount).durability(durability).unbreakable(unbreakable).name(ChatUT.hexString(name)).lore(lore).enchant(enchants).flag(itemFlags).build();
    }

    private String getConditionFormat(String condition, String key, int value) {
        return this.config.getString("subEditor.icons.conditions.conditionFormatting." + condition, key + ": " + value).replace(MessageUtil.getReplacement((String)"condition.name"), key).replace(MessageUtil.getReplacement((String)"condition.amount"), String.valueOf(value));
    }

    private String getUnsetFormat() {
        return this.config.getString("unset", "&anot set");
    }
}

