/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.editors.professions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.codex.util.messages.MessageUtil;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.YamlParser;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.util.ChatUT;

public class ProfessionEditorCfg {
    private final YamlParser config = YamlParser.loadOrExtract((JavaPlugin)Fusion.getInstance(), "Editors/professions/ProfessionEditor.yml");

    public String getTitle(String profession) {
        String title = this.config.getString("title", "&2Profession &a$<profession>");
        title = title.replace(MessageUtil.getReplacement((String)"profession"), profession);
        return ChatUT.hexString(title);
    }

    public Map<String, ItemStack> getIcons(CraftingTable table) {
        HashMap<String, ItemStack> icons = new HashMap<String, ItemStack>();
        for (String icon : this.config.getConfigurationSection("icons").getKeys(false)) {
            icons.put(icon, this.getIcon(table, icon));
        }
        return icons;
    }

    public ItemStack getIcon(CraftingTable table, String icon) {
        Material material = Material.valueOf((String)this.config.getString("icons." + icon + ".material", "STONE").replace(MessageUtil.getReplacement((String)"material"), table.getIconItem().create().getType().name()).toUpperCase());
        int amount = this.config.getInt("icons." + icon + ".amount", 1);
        int durability = this.config.getInt("icons." + icon + ".durability", 0);
        boolean unbreakable = this.config.getBoolean("icon." + icon + ".unbreakable", false);
        String name = this.config.getString("icons." + icon + ".name", "&cInvalid Item: &4" + icon);
        List<String> lore = this.config.getStringList("icons." + icon + ".lore");
        for (int i = 0; i < lore.size(); ++i) {
            lore.set(i, ChatUT.hexString(lore.get(i).replace(MessageUtil.getReplacement((String)"name"), table.getInventoryName()).replace(MessageUtil.getReplacement((String)"icon"), table.getIconItem().getID()).replace(MessageUtil.getReplacement((String)"profession"), table.getName()).replace(MessageUtil.getReplacement((String)"masteryUnlock"), String.valueOf(table.getMasteryUnlock())).replace(MessageUtil.getReplacement((String)"maxLevel"), String.valueOf(table.getMaxLevel())).replace(MessageUtil.getReplacement((String)"masteryCost"), String.valueOf(table.getMasteryFee())).replace(MessageUtil.getReplacement((String)"useCategories"), String.valueOf(table.getUseCategories()))));
        }
        Map<Enchantment, Integer> enchants = this.config.getEnchantmentSection("icons." + icon + ".enchants");
        List<ItemFlag> flags = this.config.getItemFlags("icons." + icon + ".flags");
        ItemFlag[] itemFlags = flags.toArray(new ItemFlag[0]);
        return ItemBuilder.newItem((Material)material).amount(amount).durability(durability).unbreakable(unbreakable).name(name).lore(lore).enchant(enchants).flag(itemFlags).build();
    }
}

