/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.editors.professions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.codex.util.messages.MessageUtil;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.YamlParser;
import studio.magemonkey.fusion.data.professions.pattern.Category;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.util.ChatUT;

public class CategoryEditorCfg {
    private final YamlParser config = YamlParser.loadOrExtract((JavaPlugin)Fusion.getInstance(), "Editors/professions/CategoryEditor.yml");

    public String getTitle() {
        return ChatUT.hexString(this.config.getString("title", "&2Categories"));
    }

    public Map<String, ItemStack> getIcons(CraftingTable table) {
        HashMap<String, ItemStack> icons = new HashMap<String, ItemStack>();
        for (String icon : this.config.getConfigurationSection("icons").getKeys(false)) {
            if (icon.equalsIgnoreCase("categoryItem")) continue;
            icons.put(icon, this.getIcon(table, icon));
        }
        return icons;
    }

    public ItemStack getIcon(CraftingTable table, String icon) {
        Material material = Material.valueOf((String)this.config.getString("icons." + icon + ".material", "STONE").toUpperCase());
        int amount = this.config.getInt("icons." + icon + ".amount", 1);
        int durability = this.config.getInt("icons." + icon + ".durability", 0);
        boolean unbreakable = this.config.getBoolean("icon." + icon + ".unbreakable", false);
        String name = this.config.getString("icons." + icon + ".name", "&cInvalid Item: &4" + icon);
        List<String> lore = this.config.getStringList("icons." + icon + ".lore");
        for (int i = 0; i < lore.size(); ++i) {
            lore.set(i, ChatUT.hexString(lore.get(i).replace(MessageUtil.getReplacement((String)"name"), table.getInventoryName()).replace(MessageUtil.getReplacement((String)"profession"), table.getName()).replace(MessageUtil.getReplacement((String)"masteryUnlock"), String.valueOf(table.getMasteryUnlock())).replace(MessageUtil.getReplacement((String)"masteryCost"), String.valueOf(table.getMasteryFee())).replace(MessageUtil.getReplacement((String)"useCategories"), String.valueOf(table.getUseCategories()))));
        }
        Map<Enchantment, Integer> enchants = this.config.getEnchantmentSection("icons." + icon + ".enchants");
        List<ItemFlag> flags = this.config.getItemFlags("icons." + icon + ".flags");
        ItemFlag[] itemFlags = flags.toArray(new ItemFlag[0]);
        return ItemBuilder.newItem((Material)material).amount(amount).durability(durability).unbreakable(unbreakable).name(ChatUT.hexString(name)).lore(lore).enchant(enchants).flag(itemFlags).build();
    }

    public ItemStack getCategoryItemIcon(Category category) {
        ItemStack icon = category.getDisplayIcon();
        String itemName = VersionManager.getCompat().getItemName(icon);
        if (itemName == null) {
            itemName = icon.getType().name();
        }
        Material material = Material.valueOf((String)this.config.getString("icons.categoryItem.material", "STONE").replace(MessageUtil.getReplacement((String)"material"), icon.getType().name().toUpperCase()).toUpperCase());
        int amount = this.config.getInt("icons.categoryItem.amount", 1);
        int durability = this.config.getInt("icons.categoryItem.durability", 0);
        boolean unbreakable = this.config.getBoolean("icon.categoryItem.unbreakable", false);
        String name = this.config.getString("icons.categoryItem.name", "$<category>").replace(MessageUtil.getReplacement((String)"category"), category.getName()).replace(MessageUtil.getReplacement((String)"item"), itemName);
        List<String> lore = this.config.getStringList("icons.categoryItem.lore");
        for (int i = 0; i < lore.size(); ++i) {
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"lore"))) {
                lore.remove(i);
                if (icon.getItemMeta() == null || icon.getItemMeta().getLore() == null) continue;
                int newLines = 1;
                for (String line : icon.getItemMeta().getLore()) {
                    lore.add(i - 1 + newLines, ChatUT.hexString(line));
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            lore.set(i, ChatUT.hexString(lore.get(i).replace(MessageUtil.getReplacement((String)"category"), category.getName()).replace(MessageUtil.getReplacement((String)"item"), itemName).replace(MessageUtil.getReplacement((String)"order"), String.valueOf(category.getOrder()))));
        }
        Map<Enchantment, Integer> enchants = this.config.getEnchantmentSection("icons.categoryItem.enchants");
        List<ItemFlag> flags = this.config.getItemFlags("icons.categoryItem.flags");
        ItemFlag[] itemFlags = flags.toArray(new ItemFlag[0]);
        return ItemBuilder.newItem((Material)material).amount(amount).durability(durability).unbreakable(unbreakable).name(name).lore(lore).enchant(enchants).flag(itemFlags).build();
    }
}

