/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.editors.pattern;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.api.DelayedCommand;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.codex.util.messages.MessageUtil;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.YamlParser;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.gui.editors.browse.BrowseEditor;
import studio.magemonkey.fusion.util.ChatUT;

public class PatternItemEditorCfg {
    private final YamlParser config = YamlParser.loadOrExtract((JavaPlugin)Fusion.getInstance(), "Editors/pattern/PatternItemEditor.yml");

    public String getTitle() {
        return ChatUT.hexString(this.config.getString("title", "&2Pattern Item Editor"));
    }

    public Map<String, ItemStack> getIcons(CraftingTable table) {
        HashMap<String, ItemStack> icons = new HashMap<String, ItemStack>();
        for (String icon : this.config.getConfigurationSection("icons").getKeys(false)) {
            if (icon.equalsIgnoreCase("patternItem")) continue;
            icons.put(icon, this.getIcon(table, icon));
        }
        return icons;
    }

    public Map<String, ItemStack> getIcons(BrowseEditor browseEditor) {
        HashMap<String, ItemStack> icons = new HashMap<String, ItemStack>();
        for (String icon : this.config.getConfigurationSection("icons").getKeys(false)) {
            if (icon.equalsIgnoreCase("patternItem")) continue;
            icons.put(icon, this.getIcon(browseEditor, icon));
        }
        return icons;
    }

    public ItemStack getIcon(CraftingTable table, String icon) {
        Material material = Material.valueOf((String)this.config.getString("icons." + icon + ".material", "STONE").toUpperCase());
        int amount = this.config.getInt("icons." + icon + ".amount", 1);
        int durability = this.config.getInt("icons." + icon + ".durability", 0);
        boolean unbreakable = this.config.getBoolean("icon." + icon + ".unbreakable", false);
        String name = this.config.getString("icons." + icon + ".name", "&cInvalid Item: &4" + icon);
        List<String> lore = this.config.getStringList("icons." + icon + ".lore");
        for (int i = 0; i < lore.size(); ++i) {
            lore.set(i, ChatUT.hexString(lore.get(i).replace(MessageUtil.getReplacement((String)"name"), table.getInventoryName()).replace(MessageUtil.getReplacement((String)"profession"), table.getName()).replace(MessageUtil.getReplacement((String)"masteryUnlock"), String.valueOf(table.getMasteryUnlock())).replace(MessageUtil.getReplacement((String)"masteryCost"), String.valueOf(table.getMasteryFee())).replace(MessageUtil.getReplacement((String)"useCategories"), String.valueOf(table.getUseCategories()))));
        }
        Map<Enchantment, Integer> enchants = this.config.getEnchantmentSection("icons." + icon + ".enchants");
        List<ItemFlag> flags = this.config.getItemFlags("icons." + icon + ".flags");
        ItemFlag[] itemFlags = flags.toArray(new ItemFlag[0]);
        return ItemBuilder.newItem((Material)material).amount(amount).durability(durability).unbreakable(unbreakable).name(ChatUT.hexString(name)).lore(lore).enchant(enchants).flag(itemFlags).build();
    }

    public ItemStack getIcon(BrowseEditor browseEditor, String icon) {
        Material material = Material.valueOf((String)this.config.getString("icons." + icon + ".material", "STONE").toUpperCase());
        int amount = this.config.getInt("icons." + icon + ".amount", 1);
        int durability = this.config.getInt("icons." + icon + ".durability", 0);
        boolean unbreakable = this.config.getBoolean("icon." + icon + ".unbreakable", false);
        String name = this.config.getString("icons." + icon + ".name", "&cInvalid Item: &4" + icon);
        List<String> lore = this.config.getStringList("icons." + icon + ".lore");
        for (int i = 0; i < lore.size(); ++i) {
            lore.set(i, ChatUT.hexString(lore.get(i).replace(MessageUtil.getReplacement((String)"name"), browseEditor.getName())));
        }
        Map<Enchantment, Integer> enchants = this.config.getEnchantmentSection("icons." + icon + ".enchants");
        List<ItemFlag> flags = this.config.getItemFlags("icons." + icon + ".flags");
        ItemFlag[] itemFlags = flags.toArray(new ItemFlag[0]);
        return ItemBuilder.newItem((Material)material).amount(amount).durability(durability).unbreakable(unbreakable).name(ChatUT.hexString(name)).lore(lore).enchant(enchants).flag(itemFlags).build();
    }

    public ItemStack getPatternItemIcon(char c, ItemStack item) {
        String itemName = ItemBuilder.newItem((ItemStack)item).getName();
        Material material = Material.valueOf((String)this.config.getString("icons.patternItem.material", "STONE").replace(MessageUtil.getReplacement((String)"material"), item.getType().name().toUpperCase()).toUpperCase());
        int amount = this.config.getInt("icons.patternItem.amount", 1);
        int durability = this.config.getInt("icons.patternItem.durability", 0);
        boolean unbreakable = this.config.getBoolean("icon.patternItem.unbreakable", false);
        String name = this.config.getString("icons.patternItem.name", "$<id>").replace(MessageUtil.getReplacement((String)"id"), String.valueOf(c)).replace(MessageUtil.getReplacement((String)"pattern.name"), itemName);
        List<String> lore = this.config.getStringList("icons.patternItem.lore");
        for (int i = 0; i < lore.size(); ++i) {
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"pattern.lore"))) {
                lore.remove(i);
                if (item.getItemMeta() == null || item.getItemMeta().getLore() == null) continue;
                int newLines = 1;
                for (String line : item.getItemMeta().getLore()) {
                    lore.add(i - 1 + newLines, ChatUT.hexString(line));
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            lore.set(i, ChatUT.hexString(lore.get(i).replace(MessageUtil.getReplacement((String)"pattern.name"), itemName).replace(MessageUtil.getReplacement((String)"pattern.id"), String.valueOf(c))));
        }
        Map<Enchantment, Integer> enchants = this.config.getEnchantmentSection("icons.patternItem.enchants");
        List<ItemFlag> flags = this.config.getItemFlags("icons.patternItem.flags");
        ItemFlag[] itemFlags = flags.toArray(new ItemFlag[0]);
        return ItemBuilder.newItem((Material)material).amount(amount).durability(durability).unbreakable(unbreakable).name(name).lore(lore).enchant(enchants).flag(itemFlags).build();
    }

    public String getSubTitle(char c) {
        return ChatUT.hexString(this.config.getString("subEditor.title", "&2Pattern Item &a$<id>").replace(MessageUtil.getReplacement((String)"id"), String.valueOf(c)));
    }

    public Map<String, ItemStack> getSubIcons(char c, ItemBuilder builder, Collection<DelayedCommand> commands) {
        HashMap<String, ItemStack> icons = new HashMap<String, ItemStack>();
        for (String icon : this.config.getConfigurationSection("subEditor.icons").getKeys(false)) {
            icons.put(icon, this.getSubIcon(c, builder, commands, icon));
        }
        return icons;
    }

    public ItemStack getSubIcon(char c, ItemBuilder builder, Collection<DelayedCommand> commands, String icon) {
        Material material = Material.valueOf((String)this.config.getString("subEditor.icons." + icon + ".material", "STONE").replace(MessageUtil.getReplacement((String)"material"), builder.getMaterial().getID()).toUpperCase());
        int amount = this.config.getInt("subEditor.icons." + icon + ".amount", 1);
        int durability = this.config.isString("subEditor.icons." + icon + ".durability") ? Integer.parseInt(this.config.getString("subEditor.icons." + icon + ".durability", "$<durability>").replace(MessageUtil.getReplacement((String)"durability"), String.valueOf(builder.getDurability()))) : this.config.getInt("subEditor.icons." + icon + ".durability", 0);
        boolean unbreakable = this.config.getBoolean("subEditor.icon." + icon + ".unbreakable", false);
        String name = this.config.getString("subEditor.icons." + icon + ".name", "&cInvalid Item: &4" + icon).replace(MessageUtil.getReplacement((String)"id"), String.valueOf(c));
        List<String> lore = this.config.getStringList("subEditor.icons." + icon + ".lore");
        for (int i = 0; i < lore.size(); ++i) {
            int newLines;
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"lore"))) {
                lore.remove(i);
                newLines = 1;
                for (String string : builder.getLore()) {
                    lore.add(i - 1 + newLines, string);
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"commands"))) {
                lore.remove(i);
                newLines = 1;
                for (DelayedCommand delayedCommand : commands) {
                    lore.add(i - 1 + newLines, this.config.getString("subEditor.icons.commands.commandPrefix", "&7- &a$<command>").replace(MessageUtil.getReplacement((String)"command"), delayedCommand.getCmd()).replace(MessageUtil.getReplacement((String)"delay"), String.valueOf(delayedCommand.getDelay())).replace(MessageUtil.getReplacement((String)"caster"), delayedCommand.getAs().name()));
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"enchants"))) {
                lore.remove(i);
                newLines = 1;
                for (Enchantment enchantment : builder.getEnchants().keySet()) {
                    lore.add(i - 1 + newLines, this.config.getString("subEditor.icons.enchants.enchantPrefix", "&7- &a$<enchant> $<level>").replace(MessageUtil.getReplacement((String)"enchant"), enchantment.getKey().getKey()).replace(MessageUtil.getReplacement((String)"level"), String.valueOf(builder.getEnchants().get(enchantment))));
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"flags"))) {
                lore.remove(i);
                newLines = 1;
                for (ItemFlag itemFlag : builder.getFlags()) {
                    lore.add(i - 1 + newLines, this.config.getString("subEditor.icons.flags.flagPrefix", "&7- &a$<flag>").replace(MessageUtil.getReplacement((String)"flag"), itemFlag.name().toLowerCase()));
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            lore.set(i, ChatUT.hexString(lore.get(i).replace(MessageUtil.getReplacement((String)"id"), String.valueOf(c)).replace(MessageUtil.getReplacement((String)"name"), builder.getName()).replace(MessageUtil.getReplacement((String)"unbreakable"), String.valueOf(builder.isUnbreakable())).replace(MessageUtil.getReplacement((String)"durability"), String.valueOf(builder.getDurability())).replace(MessageUtil.getReplacement((String)"glowing"), String.valueOf(!builder.getEnchants().isEmpty()))).replace(MessageUtil.getReplacement((String)"material"), builder.getMaterial().getID()).replace(MessageUtil.getReplacement((String)"amount"), String.valueOf(builder.getAmount())));
        }
        Map<Enchantment, Integer> enchants = this.config.getEnchantmentSection("subEditor.icons." + icon + ".enchants");
        List<ItemFlag> flags = this.config.getItemFlags("subEditor.icons." + icon + ".flags");
        ItemFlag[] itemFlags = flags.toArray(new ItemFlag[0]);
        return ItemBuilder.newItem((Material)material).amount(amount).durability(durability).unbreakable(unbreakable).name(ChatUT.hexString(name)).lore(lore).enchant(enchants).flag(itemFlags).build();
    }
}

