/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.editors.browse;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.codex.util.messages.MessageUtil;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.YamlParser;
import studio.magemonkey.fusion.gui.editors.browse.BrowseEditor;
import studio.magemonkey.fusion.util.ChatUT;

public class BrowseEditorCfg {
    private final YamlParser config = YamlParser.loadOrExtract((JavaPlugin)Fusion.getInstance(), "Editors/browse/BrowseEditor.yml");

    public String getTitle() {
        return ChatUT.hexString(this.config.getString("title", "Browse Gui Editor"));
    }

    public Map<String, ItemStack> getIcons(BrowseEditor browseEditor) {
        HashMap<String, ItemStack> icons = new HashMap<String, ItemStack>();
        for (String icon : this.config.getConfigurationSection("icons").getKeys(false)) {
            icons.put(icon, this.getIcon(browseEditor, icon));
        }
        return icons;
    }

    public ItemStack getIcon(BrowseEditor browseEditor, String icon) {
        Material material = Material.valueOf((String)this.config.getString("icons." + icon + ".material", "STONE"));
        int amount = this.config.getInt("icons." + icon + ".amount", 1);
        int durability = this.config.getInt("icons." + icon + ".durability", 0);
        boolean unbreakable = this.config.getBoolean("icon." + icon + ".unbreakable", false);
        String name = this.config.getString("icons." + icon + ".name", "&cInvalid Item: &4" + icon);
        List<String> lore = this.config.getStringList("icons." + icon + ".lore");
        for (int i = 0; i < lore.size(); ++i) {
            lore.set(i, ChatUT.hexString(lore.get(i).replace(MessageUtil.getReplacement((String)"name"), browseEditor.getName())));
        }
        Map<Enchantment, Integer> enchants = this.config.getEnchantmentSection("icons." + icon + ".enchants");
        List<ItemFlag> flags = this.config.getItemFlags("icons." + icon + ".flags");
        ItemFlag[] itemFlags = flags.toArray(new ItemFlag[0]);
        return ItemBuilder.newItem((Material)material).amount(amount).durability(durability).unbreakable(unbreakable).name(name).lore(lore).enchant(enchants).flag(itemFlags).build();
    }
}

