/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.IValuesReloadable;
import studio.magemonkey.fusion.util.FileUT;

public class YamlParser
extends YamlConfiguration
implements IValuesReloadable {
    private static final Logger logger = Fusion.getInstance().getLogger();
    private final File file;
    private boolean isChanged = false;
    private static final List<IValuesReloadable> valuesReloadables = new LinkedList<IValuesReloadable>();

    public YamlParser(@NotNull File file) {
        FileUT.create(file);
        this.file = file;
        valuesReloadables.add(this);
        this.reload();
    }

    @NotNull
    public File getFile() {
        return this.file;
    }

    public void save() {
        try {
            this.save(this.file);
        }
        catch (IOException var2) {
            logger.warning("Could not save config: " + this.file.getName());
        }
    }

    public void set(@NotNull String path, @Nullable Object value) {
        super.set(path, value);
        this.isChanged = true;
    }

    public void saveChanges() {
        if (this.isChanged) {
            this.save();
            this.isChanged = false;
        }
    }

    public void reload() {
        try {
            this.load(this.file);
            this.isChanged = false;
        }
        catch (IOException | InvalidConfigurationException var3) {
            logger.warning("The reload went wrong: " + var3.getMessage());
        }
    }

    public static FileConfiguration getDefaultConfig(String filePath) {
        InputStreamReader fixReader = new InputStreamReader(Objects.requireNonNull(Fusion.getInstance().getResource(filePath)));
        return YamlConfiguration.loadConfiguration((Reader)fixReader);
    }

    @NotNull
    public static YamlParser loadOrExtract(JavaPlugin plugin, @NotNull String filePath) {
        File var10002;
        File file;
        if (!plugin.getDataFolder().exists()) {
            FileUT.mkdir(plugin.getDataFolder());
        }
        if (!((String)filePath).startsWith("/")) {
            filePath = "/" + (String)filePath;
        }
        if (!(file = new File(String.valueOf(var10002 = plugin.getDataFolder()) + (String)filePath)).exists()) {
            FileUT.create(file);
            try {
                Bukkit.getConsoleSender().sendMessage("Extracting default configuration from resource: " + (String)filePath);
                InputStream input = plugin.getClass().getResourceAsStream((String)filePath);
                if (input != null) {
                    logger.info("Extracting default configuration from resource: " + (String)filePath);
                    FileUT.copy(input, file);
                } else {
                    logger.warning("Failed to find resource: " + (String)filePath);
                }
            }
            catch (Exception var4) {
                logger.warning("The loading or extraction went wrong: " + var4.getMessage());
            }
        }
        return new YamlParser(file);
    }

    public void addMissing(@NotNull String path, @Nullable Object val) {
        if (!this.contains(path)) {
            this.set(path, val);
            this.isChanged = true;
        }
    }

    public boolean remove(@NotNull String path) {
        if (!this.contains(path)) {
            return false;
        }
        this.set(path, null);
        return true;
    }

    @NotNull
    public Set<String> getSection(@NotNull String path) {
        ConfigurationSection section = this.getConfigurationSection(path);
        return section == null ? Collections.emptySet() : section.getKeys(false);
    }

    public String getString(@NotNull String path) {
        if (!this.isSet(path)) {
            return "";
        }
        String str = super.getString(path);
        return str != null && !str.isEmpty() ? str.replace("&", "\u00a7") : "";
    }

    public String getString(@NotNull String path, @Nullable String def) {
        return Objects.requireNonNull(super.getString(path, def));
    }

    @NotNull
    public List<String> getStringList(@NotNull String path) {
        if (!this.isSet(path)) {
            return List.of();
        }
        return super.getStringList(path);
    }

    public List<String> getStringList(@NotNull String path, List<String> def) {
        if (!this.isSet(path)) {
            return def;
        }
        return super.getStringList(path);
    }

    public Map<Enchantment, Integer> getEnchantmentSection(@NotNull String path) {
        HashMap<Enchantment, Integer> entries = new HashMap<Enchantment, Integer>();
        ConfigurationSection section = this.getConfigurationSection(path);
        if (section != null) {
            for (String key : section.getKeys(false)) {
                Enchantment ench = Enchantment.getByKey((NamespacedKey)NamespacedKey.fromString((String)key));
                if (ench == null) continue;
                entries.put(ench, this.getInt(path + "." + key, 1));
            }
        }
        return entries;
    }

    public List<ItemFlag> getItemFlags(@NotNull String path) {
        ArrayList<ItemFlag> entries = new ArrayList<ItemFlag>();
        ConfigurationSection section = this.getConfigurationSection(path);
        if (section != null) {
            for (String key : section.getKeys(false)) {
                ItemFlag flag = ItemFlag.valueOf((String)key.toUpperCase());
                entries.add(flag);
            }
        }
        return entries;
    }

    @Override
    public String getConfig() {
        return this.file.getName();
    }

    @Override
    public void reloadValues() {
        this.reload();
    }

    public static void reload(String config) {
        for (IValuesReloadable reloadable : valuesReloadables) {
            if (!reloadable.getConfig().equals(config)) continue;
            reloadable.reloadValues();
            return;
        }
    }

    public static void reloadAll(boolean message) {
        if (message) {
            Bukkit.getConsoleSender().sendMessage("Reloading Configuration..");
        }
        for (IValuesReloadable reloadable : valuesReloadables) {
            reloadable.reloadValues();
        }
    }

    public static List<String> getConfigNames() {
        ArrayList<String> entries = new ArrayList<String>();
        for (IValuesReloadable reloadable : valuesReloadables) {
            entries.add(reloadable.getConfig());
        }
        return entries;
    }
}

