/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.ProfessionLevelCfg;
import studio.magemonkey.fusion.cfg.YamlParser;
import studio.magemonkey.fusion.cfg.migrations.ProfessionMigration;
import studio.magemonkey.fusion.data.professions.pattern.Category;
import studio.magemonkey.fusion.data.queue.QueueItem;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.gui.ProfessionGuiRegistry;
import studio.magemonkey.fusion.hook.NexoHook;
import studio.magemonkey.fusion.util.ChatUT;
import studio.magemonkey.fusion.util.Utils;

public class ProfessionsCfg {
    private static final Map<String, CraftingTable> map = new HashMap<String, CraftingTable>(4);
    private static final Map<String, ProfessionGuiRegistry> guiMap = new HashMap<String, ProfessionGuiRegistry>(4);
    private static final Map<String, FileConfiguration> cfgs = new HashMap<String, FileConfiguration>(4);
    private static final Map<String, File> files = new HashMap<String, File>(4);

    public static void init() {
        File professionFolder = new File(Fusion.getInstance().getDataFolder(), "professions");
        if (!professionFolder.exists()) {
            professionFolder.mkdirs();
        }
        if (professionFolder.listFiles() == null || Objects.requireNonNull(professionFolder.listFiles()).length == 0) {
            Fusion.getInstance().getLogger().warning("Professions folder is empty. Adding default professions.");
            YamlParser.loadOrExtract((JavaPlugin)Fusion.getInstance(), "professions/armor_smithing.yml");
            YamlParser.loadOrExtract((JavaPlugin)Fusion.getInstance(), "professions/weapon_smithing.yml");
        }
        if (Bukkit.getPluginManager().isPluginEnabled("Nexo")) {
            new NexoHook((JavaPlugin)Fusion.getInstance(), aVoid -> ProfessionsCfg.loadProfessions(professionFolder));
        } else {
            ProfessionsCfg.loadProfessions(professionFolder);
        }
    }

    public static boolean createNewProfession(String profession, String refProfession) {
        YamlConfiguration cfg = new YamlConfiguration();
        try {
            if (refProfession != null && files.containsKey(refProfession)) {
                cfg = YamlConfiguration.loadConfiguration((File)files.get(refProfession));
                files.put(profession, new File(String.valueOf(Fusion.getInstance().getDataFolder()) + File.separator + "professions", profession + ".yml"));
                File file = files.get(profession);
                if (!file.exists()) {
                    file.createNewFile();
                }
                cfg.set("name", (Object)profession);
                cfg.save(file);
                Map _map = cfg.getValues(true);
                CraftingTable ct = new CraftingTable(_map);
                map.put(ct.getName(), ct);
                cfgs.put(profession, (FileConfiguration)cfg);
                files.put(profession, file);
                return true;
            }
            if (refProfession == null) {
                files.put(profession, new File(String.valueOf(Fusion.getInstance().getDataFolder()) + File.separator + "professions", profession + ".yml"));
                File file = files.get(profession);
                if (!file.exists()) {
                    file.createNewFile();
                }
                cfg.load(file);
                cfg.set("name", (Object)profession);
                ProfessionsCfg.addDefs((FileConfiguration)cfg);
                cfg.save(file);
                cfg.load(file);
                Map _map = cfg.getValues(true);
                CraftingTable ct = new CraftingTable(_map);
                map.put(ct.getName(), ct);
                files.put(profession, file);
                cfgs.put(profession, (FileConfiguration)cfg);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Fusion.getInstance().getLogger().warning("Can't load crafting table: " + e.getMessage());
        }
        return false;
    }

    private static void loadProfessions(File root) {
        map.clear();
        guiMap.clear();
        for (File file : Objects.requireNonNull(root.listFiles())) {
            if (file.getName().endsWith(".yml")) {
                YamlConfiguration cfg = new YamlConfiguration();
                try {
                    Bukkit.getConsoleSender().sendMessage("Loading " + file.getName());
                    cfg.load(file);
                    ProfessionsCfg.addDefs((FileConfiguration)cfg);
                    ProfessionMigration.migrate((FileConfiguration)cfg, "1.3");
                    cfg.save(file);
                    cfg.load(file);
                    Map _map = cfg.getValues(true);
                    CraftingTable ct = new CraftingTable(_map);
                    map.put(ct.getName(), ct);
                    cfgs.put(ct.getName(), (FileConfiguration)cfg);
                    files.put(ct.getName(), file);
                    ProfessionsCfg.injectProfessionLevelConfig(ct, file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Fusion.getInstance().getLogger().warning("Can't load crafting table: " + e.getMessage());
                }
                continue;
            }
            if (!file.isDirectory()) continue;
            ProfessionsCfg.loadProfessions(file);
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            guiMap.put(key, new ProfessionGuiRegistry(key));
        }
    }

    public static CraftingTable getTable(String str) {
        return map.get(str);
    }

    public static ProfessionGuiRegistry getGUI(String str) {
        if (str == null) {
            return null;
        }
        return guiMap.get(str);
    }

    private static void addDefs(FileConfiguration cfg) {
        if (!cfg.isSet("icon")) {
            cfg.set("icon", (Object)"STONE");
        }
        if (!cfg.isSet("inventoryName")) {
            cfg.set("inventoryName", (Object)"Template Profession");
        }
        if (!cfg.isSet("useCategories")) {
            cfg.set("useCategories", (Object)false);
        }
        if (!cfg.isSet("recipePattern.pattern")) {
            ArrayList<String> pattern = new ArrayList<String>(Arrays.asList("fffffffff", "fooooooof", "fooooooof", "ff-----ff", "f{<f0f>}f"));
            cfg.set("recipePattern.pattern", pattern);
        }
        if (!cfg.isSet("recipePattern.items.}")) {
            cfg.set("recipePattern.items.}.material", (Object)"LIME_DYE");
            cfg.set("recipePattern.items.}.amount", (Object)1);
            cfg.set("recipePattern.items.}.durability", (Object)0);
            cfg.set("recipePattern.items.}.unbreakable", (Object)false);
            cfg.set("recipePattern.items.}.name", (Object)"Next queued items");
            cfg.set("recipePattern.items.}.lore", List.of());
            cfg.set("recipePattern.items.}.flags", List.of());
            cfg.set("recipePattern.items.}.enchants", Map.of());
        }
        if (!cfg.isSet("recipePattern.items.>")) {
            cfg.set("recipePattern.items.>.material", (Object)"GREEN_DYE");
            cfg.set("recipePattern.items.>.amount", (Object)1);
            cfg.set("recipePattern.items.>.durability", (Object)0);
            cfg.set("recipePattern.items.>.unbreakable", (Object)false);
            cfg.set("recipePattern.items.>.name", (Object)"Next recipes");
            cfg.set("recipePattern.items.>.lore", List.of());
            cfg.set("recipePattern.items.>.flags", List.of());
            cfg.set("recipePattern.items.>.enchants", Map.of());
        }
        if (!cfg.isSet("recipePattern.items.<")) {
            cfg.set("recipePattern.items.<.material", (Object)"GREEN_DYE");
            cfg.set("recipePattern.items.<.amount", (Object)1);
            cfg.set("recipePattern.items.<.durability", (Object)0);
            cfg.set("recipePattern.items.<.unbreakable", (Object)false);
            cfg.set("recipePattern.items.<.name", (Object)"Previous recipes");
            cfg.set("recipePattern.items.<.lore", List.of());
            cfg.set("recipePattern.items.<.flags", List.of());
            cfg.set("recipePattern.items.<.enchants", Map.of());
        }
        if (!cfg.isSet("recipePattern.items.{")) {
            cfg.set("recipePattern.items.{.material", (Object)"LIME_DYE");
            cfg.set("recipePattern.items.{.amount", (Object)1);
            cfg.set("recipePattern.items.{.durability", (Object)0);
            cfg.set("recipePattern.items.{.unbreakable", (Object)false);
            cfg.set("recipePattern.items.{.name", (Object)"Previous queued items");
            cfg.set("recipePattern.items.{.lore", List.of());
            cfg.set("recipePattern.items.{.flags", List.of());
            cfg.set("recipePattern.items.{.enchants", Map.of());
        }
        if (!cfg.isSet("recipePattern.items.queue-items.-")) {
            cfg.set("recipePattern.items.queue-items.-.material", (Object)"GRAY_STAINED_GLASS_PANE");
            cfg.set("recipePattern.items.queue-items.-.amount", (Object)1);
            cfg.set("recipePattern.items.queue-items.-.durability", (Object)0);
            cfg.set("recipePattern.items.queue-items.-.unbreakable", (Object)false);
            cfg.set("recipePattern.items.queue-items.-.name", (Object)"&cQueue Slot");
            cfg.set("recipePattern.items.queue-items.-.lore", List.of("&7This slot is empty."));
            cfg.set("recipePattern.items.queue-items.-.flags", List.of());
            cfg.set("recipePattern.items.queue-items.-.enchants", Map.of());
        }
        if (!cfg.isSet("recipePattern.items.queue-items.Unfinished")) {
            cfg.set("recipePattern.items.queue-items.Unfinished.material", (Object)"%material%");
            cfg.set("recipePattern.items.queue-items.Unfinished.amount", (Object)1);
            cfg.set("recipePattern.items.queue-items.Unfinished.durability", (Object)0);
            cfg.set("recipePattern.items.queue-items.Unfinished.unbreakable", (Object)false);
            cfg.set("recipePattern.items.queue-items.Unfinished.name", (Object)"&cQueue Slot");
            cfg.set("recipePattern.items.queue-items.Unfinished.lore", List.of("&7&oThis item is in the crafting queue", " ", "&7Time left: &c%time%", " ", "&eClick to cancel"));
            cfg.set("recipePattern.items.queue-items.Unfinished.flags", List.of());
            cfg.set("recipePattern.items.queue-items.Unfinished.enchants", Map.of());
        }
        if (!cfg.isSet("recipePattern.items.queue-items.Finished")) {
            cfg.set("recipePattern.items.queue-items.Finished.material", (Object)"%material%");
            cfg.set("recipePattern.items.queue-items.Finished.amount", (Object)1);
            cfg.set("recipePattern.items.queue-items.Finished.durability", (Object)0);
            cfg.set("recipePattern.items.queue-items.Finished.unbreakable", (Object)false);
            cfg.set("recipePattern.items.queue-items.Finished.name", (Object)"&cQueue Slot");
            cfg.set("recipePattern.items.queue-items.Finished.lore", List.of("&7&oThis item is in the crafting queue", " ", "&7The item is &afinished&7!", " ", "&eClick to obtain"));
            cfg.set("recipePattern.items.queue-items.Finished.flags", List.of());
            cfg.set("recipePattern.items.queue-items.Finished.enchants", Map.of());
        }
        if (!cfg.isSet("recipePattern.items.fillItem")) {
            cfg.set("recipePattern.items.fillItem.material", (Object)"BLACK_STAINED_GLASS_PANE");
            cfg.set("recipePattern.items.fillItem.amount", (Object)1);
            cfg.set("recipePattern.items.fillItem.durability", (Object)0);
            cfg.set("recipePattern.items.fillItem.unbreakable", (Object)false);
            cfg.set("recipePattern.items.fillItem.name", (Object)" ");
            cfg.set("recipePattern.items.fillItem.lore", List.of());
            cfg.set("recipePattern.items.fillItem.flags", List.of());
            cfg.set("recipePattern.items.fillItem.enchants", Map.of());
        }
        if (cfg.isSet("categoryPattern")) {
            if (!cfg.isSet("categoryPattern.items.queue-items.-")) {
                cfg.set("categoryPattern.items.queue-items.-", (Object)cfg.getConfigurationSection("recipePattern.items.queue-items.-").getValues(false));
            }
            if (!cfg.isSet("categoryPattern.items.queue-items.Unfinished")) {
                cfg.set("categoryPattern.items.queue-items.Unfinished", (Object)cfg.getConfigurationSection("recipePattern.items.queue-items.Unfinished").getValues(false));
            }
            if (!cfg.isSet("categoryPattern.items.queue-items.Finished")) {
                cfg.set("categoryPattern.items.queue-items.Finished", (Object)cfg.getConfigurationSection("recipePattern.items.queue-items.Finished").getValues(false));
            }
        }
        if (!cfg.isSet("categories")) {
            cfg.set("categories", List.of(new Category("First Category").serialize()));
        }
        if (cfg.isSet("recipes")) {
            List recipesSection = cfg.getMapList("recipes");
            if (recipesSection != null) {
                ArrayList modifiedRecipes = new ArrayList();
                for (Map recipeData : recipesSection) {
                    try {
                        LinkedHashMap<String, Object> mutableRecipeData = new LinkedHashMap<String, Object>(recipeData);
                        Map costs = mutableRecipeData.getOrDefault("costs", new HashMap());
                        Map results = mutableRecipeData.getOrDefault("results", new HashMap());
                        Map conditions = mutableRecipeData.getOrDefault("conditions", new HashMap());
                        if (mutableRecipeData.containsKey("cooldown")) {
                            int craftingTime = mutableRecipeData.getOrDefault("cooldown", 0);
                            mutableRecipeData.remove("cooldown");
                            mutableRecipeData.put("craftingTime", craftingTime);
                        }
                        if (mutableRecipeData.containsKey("price")) {
                            costs.put("money", mutableRecipeData.get("price") instanceof Number ? ((Number)mutableRecipeData.get("price")).doubleValue() : 0.0);
                            mutableRecipeData.remove("price");
                        }
                        if (mutableRecipeData.containsKey("costs") && mutableRecipeData.get("costs") instanceof Number) {
                            costs.put("exp", mutableRecipeData.get("costs") instanceof Number ? ((Number)mutableRecipeData.get("costs")).doubleValue() : 0.0);
                        }
                        if (mutableRecipeData.containsKey("pattern")) {
                            List pattern = (List)mutableRecipeData.get("pattern");
                            mutableRecipeData.remove("pattern");
                            costs.put("items", pattern);
                        }
                        if (mutableRecipeData.containsKey("mastery")) {
                            boolean mastery = mutableRecipeData.getOrDefault("mastery", false);
                            mutableRecipeData.remove("mastery");
                            conditions.put("mastery", mastery);
                        }
                        if (mutableRecipeData.containsKey("neededLevels")) {
                            int neededLevels = mutableRecipeData.getOrDefault("neededLevels", 0);
                            mutableRecipeData.remove("neededLevels");
                            conditions.put("professionLevel", neededLevels);
                        }
                        if (mutableRecipeData.containsKey("permission")) {
                            String permission = mutableRecipeData.getOrDefault("permission", null);
                            mutableRecipeData.remove("permission");
                            conditions.put("permission", permission);
                        }
                        if (mutableRecipeData.containsKey("result")) {
                            String item = mutableRecipeData.get("result").toString();
                            mutableRecipeData.remove("result");
                            results.put("item", item);
                        }
                        if (mutableRecipeData.containsKey("xpGain")) {
                            results.put("professionExp", mutableRecipeData.get("xpGain") instanceof Number ? ((Number)mutableRecipeData.get("xpGain")).intValue() : 0);
                            mutableRecipeData.remove("xpGain");
                        }
                        if (mutableRecipeData.containsKey("commands")) {
                            List commands = (List)mutableRecipeData.get("commands");
                            mutableRecipeData.remove("commands");
                            results.put("commands", commands);
                        }
                        mutableRecipeData.put("results", results);
                        mutableRecipeData.put("conditions", conditions);
                        mutableRecipeData.put("costs", costs);
                        modifiedRecipes.add(mutableRecipeData);
                    }
                    catch (Exception e) {
                        Fusion.getInstance().error("Exception when reading config, Invalid entry in config of " + String.valueOf(recipeData) + " crafting table. Value: " + String.valueOf(recipeData));
                        e.printStackTrace();
                    }
                }
                cfg.set("recipes", modifiedRecipes);
            } else {
                Fusion.getInstance().error("Recipes section is null in the config.");
            }
        } else {
            cfg.set("recipes", new ArrayList());
        }
    }

    public static boolean loadFrom(String key, Map<String, Object> map) {
        try {
            File file;
            File professionFolder = new File(Fusion.getInstance().getDataFolder(), "professions");
            if (!professionFolder.exists()) {
                professionFolder.mkdirs();
            }
            if ((file = new File(professionFolder, key + ".yml")).exists()) {
                Fusion.getInstance().getLogger().warning("Profession '" + key + "' was already migrated.");
                return true;
            }
            YamlConfiguration cfg = new YamlConfiguration();
            cfg.set("name", (Object)key);
            cfg.set("icon", map.get("icon"));
            cfg.set("inventoryName", map.get("inventoryName"));
            cfg.set("useCategories", map.get("useCategories"));
            cfg.set("pattern", map.get("pattern"));
            cfg.set("categoryPattern", map.get("categoryPattern"));
            cfg.set("masteryUnlock", map.get("masteryUnlock"));
            cfg.set("masteryFee", map.get("masteryFee"));
            cfg.set("categories", map.get("categories"));
            cfg.set("recipes", map.get("recipes"));
            cfg.save(file);
            Fusion.getInstance().getLogger().warning("Profession '" + key + "' migrated successfully.");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            Fusion.getInstance().getLogger().warning("Can't load crafting table: " + e.getMessage());
            return false;
        }
    }

    public static ItemStack getFillItem(String key) {
        String name = cfgs.get(key).getString("recipePattern.items.fillItem.name", " ");
        List lore = cfgs.get(key).getStringList("recipePattern.items.fillItem.lore");
        Material material = Material.getMaterial((String)cfgs.get(key).getString("recipePattern.items.fillItem.material", "BLACK_STAINED_GLASS_PANE").toUpperCase());
        return ItemBuilder.newItem((Material)material).name(name).lore(lore).build();
    }

    public static ItemStack getQueueSlot(String key) {
        FileConfiguration cfg = cfgs.get(key);
        if (!cfg.isSet("recipePattern.items.queue-items.-")) {
            Fusion.getInstance().getLogger().warning("Profession '" + key + "' does not have a queue slot. Using default.");
            return ItemBuilder.newItem((Material)Material.GRAY_STAINED_GLASS_PANE).name("&cQueue Slot").lore(List.of("&7This slot is empty.")).build();
        }
        Material material = Material.getMaterial((String)cfg.getString("recipePattern.items.queue-items.-.material", "GRAY_STAINED_GLASS_PANE").toUpperCase());
        return ItemBuilder.newItem((Material)material).name(cfg.getString("recipePattern.items.queue-items.-.name", "&cQueue Slot")).lore(cfg.getStringList("recipePattern.items.queue-items.-.lore")).build();
    }

    @NotNull
    public static ItemStack getQueueItem(String key, QueueItem item) {
        ItemMeta meta;
        String path;
        FileConfiguration cfg = cfgs.get(key);
        String string = path = item.isDone() ? "recipePattern.items.queue-items.Finished" : "recipePattern.items.queue-items.Unfinished";
        if (!cfg.isSet(path)) {
            Fusion.getInstance().getLogger().warning("Profession '" + key + "' is missing '" + path + "'.");
            return null;
        }
        ItemStack result = item.getRecipe().getDivinityRecipeMeta() == null ? item.getRecipe().getSettings().getRecipeItem().getItemStack() : item.getRecipe().getDivinityRecipeMeta().getIcon();
        String materialString = cfg.getString(path + ".material", "STONE").replace("%material%", result.getType().toString()).toUpperCase();
        Material material = Material.getMaterial((String)materialString);
        if (material == null) {
            Fusion.getInstance().getLogger().warning("Profession '" + key + "' has an unknown material: " + materialString);
            return new ItemStack(Material.AIR);
        }
        if (material != result.getType()) {
            result.setType(material);
        }
        if ((meta = result.getItemMeta()) != null) {
            List lore = cfg.getStringList(path + ".lore");
            lore.replaceAll(s -> ChatUT.hexString(s.replace("%time%", Utils.getFormattedTime(item.getVisualRemainingItemTime()))));
            meta.setLore(lore);
            result.setItemMeta(meta);
        }
        return result;
    }

    public static void closeAll() {
        for (ProfessionGuiRegistry gui : guiMap.values()) {
            gui.closeAll();
        }
    }

    private static void injectProfessionLevelConfig(CraftingTable table, File file) {
        File levelFile = new File(file.getPath().replace("professions", "levels"));
        ProfessionLevelCfg levelCfg = new ProfessionLevelCfg(table, levelFile.getPath().replace("plugins/Fusion", ""));
        table.setLevelFunction(levelCfg);
    }

    @Generated
    public static Map<String, CraftingTable> getMap() {
        return map;
    }

    @Generated
    public static Map<String, ProfessionGuiRegistry> getGuiMap() {
        return guiMap;
    }

    @Generated
    public static Map<String, FileConfiguration> getCfgs() {
        return cfgs;
    }

    @Generated
    public static Map<String, File> getFiles() {
        return files;
    }
}

