/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.Cfg;
import studio.magemonkey.fusion.cfg.YamlParser;
import studio.magemonkey.fusion.data.player.PlayerLoader;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.util.LevelFunction;

public class ProfessionLevelCfg {
    private final Map<Integer, Double> levelMap = new LinkedHashMap<Integer, Double>();
    private final CraftingTable table;
    private YamlParser config;

    public ProfessionLevelCfg(CraftingTable table, String filePath) {
        this.table = table;
        if (Cfg.useCustomFormula) {
            this.config = YamlParser.loadOrExtract((JavaPlugin)Fusion.getInstance(), filePath);
            if (this.config.getDoubleList("level-exp").isEmpty()) {
                Fusion.getInstance().getLogger().warning("No levels found in " + filePath + "! Generating default levels.");
                List<Integer> levels = List.of(Integer.valueOf(50), Integer.valueOf(300), Integer.valueOf(500), Integer.valueOf(750), Integer.valueOf(1300), Integer.valueOf(1600), Integer.valueOf(3500), Integer.valueOf(7000), Integer.valueOf(15000), Integer.valueOf(30000));
                this.config.set("level-exp", levels);
                this.config.save();
            }
            int i = 1;
            Iterator iterator = this.config.getDoubleList("level-exp").iterator();
            while (iterator.hasNext()) {
                double expAmount = (Double)iterator.next();
                this.levelMap.put(i++, expAmount);
            }
        } else {
            LevelFunction.copyLevelMap(this.levelMap);
        }
    }

    public double getXP(int level) {
        return this.levelMap.get(level);
    }

    public int getLevel(double xp) {
        boolean seen = false;
        Map.Entry<Integer, Double> acc = null;
        for (Map.Entry<Integer, Double> e : this.levelMap.entrySet()) {
            if (!(e.getValue() <= xp)) continue;
            if (!seen) {
                seen = true;
                acc = e;
                continue;
            }
            acc = e;
        }
        Optional<Object> val = seen ? Optional.of(acc) : Optional.empty();
        return val.isPresent() ? (Integer)((Map.Entry)val.get()).getKey() : 0;
    }

    public int getLevel(OfflinePlayer player) {
        return this.getLevel(PlayerLoader.getPlayer(player.getUniqueId()).getExperience(this.table));
    }

    public void reload() {
        if (Cfg.useCustomFormula) {
            this.config.reload();
            this.levelMap.clear();
            int i = 1;
            Iterator iterator = this.config.getDoubleList("level-exp").iterator();
            while (iterator.hasNext()) {
                double expAmount = (Double)iterator.next();
                this.levelMap.put(i++, expAmount);
            }
        } else {
            LevelFunction.copyLevelMap(this.levelMap);
        }
    }
}

