/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import studio.magemonkey.fusion.Fusion;

public class BukkitRecipeWrapper {
    public static List<NamespacedKey> getRecipeKeysForMaterials(List<Material> material) {
        ArrayList<NamespacedKey> entries = new ArrayList<NamespacedKey>();
        for (Material mat : material) {
            if (mat.isAir()) continue;
            ItemStack stack = new ItemStack(mat);
            List recipes = Bukkit.getRecipesFor((ItemStack)stack);
            if (recipes.isEmpty()) {
                Fusion.getInstance().error("No recipes found for material: " + String.valueOf(mat));
                continue;
            }
            for (Recipe recipe : recipes) {
                if (recipe instanceof Keyed) {
                    Keyed keyed = (Keyed)recipe;
                    NamespacedKey key = keyed.getKey();
                    entries.add(key);
                    continue;
                }
                Bukkit.getLogger().info("Recipe has no key (likely a custom non-keyed recipe).");
            }
        }
        return entries;
    }

    public static void enableBukkitRecipes(List<NamespacedKey> recipes) {
        for (NamespacedKey recipe : recipes) {
            Recipe bukkitRecipe = Fusion.getInstance().getServer().getRecipe(recipe);
            if (bukkitRecipe != null) {
                Fusion.getInstance().getServer().addRecipe(bukkitRecipe);
                Bukkit.getLogger().info("Enabled Bukkit recipe with key: " + String.valueOf(recipe));
                continue;
            }
            Fusion.getInstance().error("Bukkit recipe with key " + String.valueOf(recipe) + " not found.");
        }
    }

    public static void disableBukkitRecipes(List<NamespacedKey> recipes) {
        for (NamespacedKey recipe : recipes) {
            Recipe bukkitRecipe = Fusion.getInstance().getServer().getRecipe(recipe);
            if (bukkitRecipe != null) {
                Fusion.getInstance().getServer().removeRecipe(recipe);
                Bukkit.getLogger().info("Disabled Bukkit recipe with key: " + String.valueOf(recipe));
                continue;
            }
            Fusion.getInstance().error("Bukkit recipe with key " + String.valueOf(recipe) + " not found.");
        }
    }
}

