/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.api.events.services;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.api.FusionAPI;
import studio.magemonkey.fusion.api.events.ProfessionGainXpEvent;
import studio.magemonkey.fusion.api.events.ProfessionJoinEvent;
import studio.magemonkey.fusion.api.events.ProfessionLeaveEvent;
import studio.magemonkey.fusion.api.events.ProfessionLevelUpEvent;
import studio.magemonkey.fusion.api.events.ProfessionMasteryEvent;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.data.player.FusionPlayer;
import studio.magemonkey.fusion.data.professions.Profession;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.util.ChatUT;
import studio.magemonkey.fusion.util.ExperienceManager;
import studio.magemonkey.fusion.util.PlayerUtil;

public class ProfessionService {
    public void joinProfession(String professionName, Player player, double moneyCost, int expCost) {
        ProfessionJoinEvent event = new ProfessionJoinEvent(professionName, player);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (!event.getFusionPlayer().hasProfession(professionName)) {
                event.getFusionPlayer().addProfession(new Profession(-1L, player.getUniqueId(), professionName, 0L, false, true));
            } else {
                Objects.requireNonNull(event.getFusionPlayer().getProfession(professionName)).setJoined(true);
            }
            if (moneyCost > 0.0) {
                CodexEngine.get().getVault().take((OfflinePlayer)player, moneyCost);
            }
            if (expCost > 0) {
                ExperienceManager.setTotalExperience(player, ExperienceManager.getTotalExperience(player) - expCost);
            }
            MessageData[] data = new MessageData[]{new MessageData("profession", (Object)professionName), new MessageData("inventoryName", (Object)ChatUT.hexString(ProfessionsCfg.getTable(professionName).getInventoryName())), new MessageData("costs.money", (Object)moneyCost), new MessageData("costs.experience", (Object)expCost), new MessageData("unlocked", (Object)event.getFusionPlayer().getJoinedProfessions().size()), new MessageData("limit", (Object)PlayerUtil.getPermOption(player, "fusion.limit")), new MessageData("bal", (Object)CodexEngine.get().getVault().getBalance((OfflinePlayer)player))};
            CodexEngine.get().getMessageUtil().sendMessage("fusion.unlockedProfession", (CommandSender)player, data);
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        }
    }

    public void leaveProfession(CraftingTable table, Player player) {
        ProfessionLeaveEvent event = new ProfessionLeaveEvent(table.getName(), player);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            event.getFusionPlayer().setJoined(table, false);
            event.getFusionPlayer().removeProfession(table);
            CodexEngine.get().getMessageUtil().sendMessage("fusion.forgotten", (CommandSender)player, new MessageData[]{new MessageData("sender", (Object)player.getName()), new MessageData("craftingTable", (Object)table)});
        }
    }

    public void giveProfessionExp(Player player, CraftingTable table, long xp) {
        FusionPlayer fusionPlayer = FusionAPI.getPlayerManager().getPlayer(player);
        Profession profession = fusionPlayer.getProfession(table);
        if (profession == null) {
            Fusion.getInstance().getLogger().warning("Failed to give experience to player " + player.getName() + " for table " + table.getName() + " as they do not have the profession.");
            return;
        }
        if (table.getMaxLevel() > 0 && profession.getLevel() >= table.getMaxLevel()) {
            return;
        }
        ProfessionGainXpEvent event = new ProfessionGainXpEvent(table.getName(), player, xp);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            int previousLevel = profession.getLevel();
            FusionAPI.getPlayerManager().getPlayer(player).addExperience(table.getName(), event.getGainedExp());
            int newLevel = profession.getLevel();
            if (newLevel != previousLevel) {
                this.levelUpProfession(player, table, previousLevel, newLevel);
            }
        }
    }

    public void setProfessionExp(Player player, CraftingTable table, long xp) {
        FusionPlayer fusionPlayer = FusionAPI.getPlayerManager().getPlayer(player);
        Profession profession = fusionPlayer.getProfession(table);
        if (profession == null) {
            Fusion.getInstance().getLogger().warning("Failed to give experience to player " + player.getName() + " for table " + table.getName() + " as they do not have the profession.");
            return;
        }
        if (table.getMaxLevel() > 0 && table.getLevelFunction().getLevel(profession.getExp() + xp) >= table.getMaxLevel()) {
            return;
        }
        ProfessionGainXpEvent event = new ProfessionGainXpEvent(table.getName(), player, xp);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            int previousLevel = profession.getLevel();
            FusionAPI.getPlayerManager().getPlayer(player).setExperience(table.getName(), event.getGainedExp());
            int newLevel = profession.getLevel();
            if (newLevel != previousLevel) {
                this.levelUpProfession(player, table, previousLevel, newLevel);
            }
        }
    }

    public void levelUpProfession(Player player, CraftingTable table, int previousLevel, int newLevel) {
        if (newLevel < 0) {
            newLevel = 0;
        }
        ProfessionLevelUpEvent event = new ProfessionLevelUpEvent(table.getName(), player, previousLevel, newLevel);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.levelup", (CommandSender)player, new MessageData[]{new MessageData("craftingTable", (Object)table), new MessageData("level", (Object)event.getNewLevel())});
            if (event.isModified()) {
                FusionAPI.getPlayerManager().getPlayer(player).getProfession(table).setLevel(event.getNewLevel());
            }
        }
    }

    public void masterProfession(String professionName, Player player, boolean isMastered) {
        ProfessionMasteryEvent event = new ProfessionMasteryEvent(professionName, player, isMastered);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            event.getFusionPlayer().getProfession(professionName).setMastered(isMastered);
            if (event.isHasMastered()) {
                CodexEngine.get().getMessageUtil().sendMessage("fusion.mastered", (CommandSender)player, new MessageData[]{new MessageData("sender", (Object)player), new MessageData("craftingTable", (Object)event.getCraftingTable())});
            }
        }
    }
}

