/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.api;

import org.bukkit.entity.Player;
import studio.magemonkey.fusion.api.FusionAPI;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.gui.ProfessionGuiRegistry;

public class ProfessionManager {
    public CraftingTable getProfession(String profession) {
        CraftingTable table = ProfessionsCfg.getTable(profession);
        if (table == null) {
            FusionAPI.getInstance().getLogger().warning("Failed to get profession " + profession + " because it does not exist.");
            return null;
        }
        return table;
    }

    public ProfessionGuiRegistry getProfessionGui(String profession) {
        ProfessionGuiRegistry gui = ProfessionsCfg.getGUI(profession);
        if (gui == null) {
            FusionAPI.getInstance().getLogger().warning("Failed to get profession gui for " + profession + " because it does not exist.");
            return null;
        }
        return gui;
    }

    public ProfessionGuiRegistry openProfessionGui(String profession, Player player) {
        ProfessionGuiRegistry gui = this.getProfessionGui(profession);
        if (gui == null) {
            FusionAPI.getInstance().getLogger().warning("Failed to open profession gui for " + profession + "(" + String.valueOf(player.getUniqueId()) + ") because it does not exist.");
            return null;
        }
        gui.open(player);
        return gui;
    }

    public void closeProfessionGui(String professionName) {
        ProfessionGuiRegistry gui = ProfessionsCfg.getGUI(professionName);
        if (gui == null) {
            FusionAPI.getInstance().getLogger().warning("Failed to close profession gui for " + professionName + " because it does not exist.");
            return;
        }
        gui.closeAll();
    }
}

