/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.config.legacy.LegacyConfigManager;
import studio.magemonkey.codex.legacy.RisePlugin;
import studio.magemonkey.codex.legacy.placeholder.PlaceholderRegistry;
import studio.magemonkey.codex.legacy.placeholder.PlaceholderType;
import studio.magemonkey.codex.util.ItemUtils;
import studio.magemonkey.fusion.FusionPlaceholders;
import studio.magemonkey.fusion.api.FusionAPI;
import studio.magemonkey.fusion.cfg.BrowseConfig;
import studio.magemonkey.fusion.cfg.Cfg;
import studio.magemonkey.fusion.cfg.CraftingRequirementsCfg;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.cfg.ShowRecipesCfg;
import studio.magemonkey.fusion.cfg.editors.EditorRegistry;
import studio.magemonkey.fusion.cfg.hooks.HookManager;
import studio.magemonkey.fusion.cfg.hooks.HookType;
import studio.magemonkey.fusion.cfg.hooks.divinity.DivinityService;
import studio.magemonkey.fusion.cfg.migrations.PConfigManager;
import studio.magemonkey.fusion.cfg.sql.SQLManager;
import studio.magemonkey.fusion.commands.Commands;
import studio.magemonkey.fusion.commands.FusionEditorCommand;
import studio.magemonkey.fusion.data.player.PlayerLoader;
import studio.magemonkey.fusion.data.recipes.CalculatedRecipe;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.data.recipes.Recipe;
import studio.magemonkey.fusion.data.recipes.RecipeEconomyItem;
import studio.magemonkey.fusion.data.recipes.RecipeItem;
import studio.magemonkey.fusion.gui.BrowseGUI;
import studio.magemonkey.fusion.gui.recipe.RecipeGuiEventRouter;
import studio.magemonkey.fusion.util.ExperienceManager;
import studio.magemonkey.fusion.util.LevelFunction;

public class Fusion
extends RisePlugin
implements Listener {
    public static final PlaceholderType<RecipeItem> RECIPE_ITEM = PlaceholderType.create((String)"recipeItem", RecipeItem.class, (PlaceholderType[])new PlaceholderType[0]);
    public static final PlaceholderType<Recipe> RECIPE = PlaceholderType.create((String)"recipe", Recipe.class, (PlaceholderType[])new PlaceholderType[0]);
    public static final PlaceholderType<CraftingTable> CRAFTING_TABLE = PlaceholderType.create((String)"craftingTable", CraftingTable.class, (PlaceholderType[])new PlaceholderType[0]);
    public static final PlaceholderType<CalculatedRecipe> CALCULATED_RECIPE = PlaceholderType.create((String)"calculatedRecipe", CalculatedRecipe.class, (PlaceholderType[])new PlaceholderType[0]);
    private static Fusion instance;
    private static HookManager hookManager;
    private final HashMap<UUID, Double> cachedCooldowns;

    public Fusion() {
        instance = this;
        this.cachedCooldowns = new HashMap();
    }

    public void reloadConfig() {
        super.reloadConfig();
        FileConfiguration lang = LegacyConfigManager.loadConfigFile((File)new File(String.valueOf(this.getDataFolder()) + File.separator + "lang", "lang_en.yml"), (InputStream)this.getResource("lang/lang_en.yml"));
        CodexEngine.get().getMessageUtil().reload(lang, (JavaPlugin)this);
        CraftingRequirementsCfg.init();
        hookManager = new HookManager();
        Cfg.init();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            ProfessionsCfg.init();
            EditorRegistry.reload();
            SQLManager.init();
            BrowseConfig.load();
            ShowRecipesCfg.load();
            DivinityService.init();
        });
    }

    public void onLoad() {
        RECIPE_ITEM.registerItem("amount", RecipeItem::getAmount);
        RECIPE_ITEM.registerItem("itemName", i -> i instanceof RecipeEconomyItem ? ((RecipeEconomyItem)i).getItemName() : null);
        RECIPE.registerItem("name", Recipe::getName);
        RECIPE.registerItem("costs.money", Recipe::getMoneyCost);
        RECIPE.registerItem("costs.exp", Recipe::getExpCost);
        RECIPE.registerItem("results", Recipe::getResults);
        RECIPE.registerItem("professionLevel", entry -> entry.getConditions().getProfessionLevel());
        RECIPE.registerItem("conditions", Recipe::getConditions);
        CRAFTING_TABLE.registerItem("name", CraftingTable::getName);
        CRAFTING_TABLE.registerItem("inventoryName", CraftingTable::getInventoryName);
        CRAFTING_TABLE.registerItem("masteryUnlock", CraftingTable::getMasteryUnlock);
        CRAFTING_TABLE.registerItem("masteryFee", CraftingTable::getMasteryFee);
        if (!Bukkit.getPluginManager().isPluginEnabled("Sapphire")) {
            RECIPE_ITEM.registerChild("customItem", ItemUtils.ITEM_TYPE, i -> {
                if (i instanceof RecipeEconomyItem) {
                    return ((RecipeEconomyItem)i).asItemType();
                }
                return null;
            });
        }
        RECIPE_ITEM.registerChild("item", PlaceholderRegistry.ITEM, RecipeItem::getItemStack);
        RECIPE.registerChild("results", RECIPE_ITEM, entry -> entry.getSettings().getRecipeItem());
        CALCULATED_RECIPE.registerChild("recipe", RECIPE, CalculatedRecipe::getRecipe);
        CALCULATED_RECIPE.registerChild("icon", PlaceholderRegistry.ITEM, CalculatedRecipe::getIcon);
        super.onLoad();
    }

    public void onEnable() {
        super.onEnable();
        this.reloadConfig();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            Fusion.getInstance().getLogger().info("Attempting to migrate data into SQL [ExperienceManager].");
            ExperienceManager.migrateIntoSQL();
            Fusion.getInstance().getLogger().info("Attempting to migrate data into SQL [PConfigManager].");
            PConfigManager.migrateIntoSQL();
        });
        LevelFunction.generate(200);
        this.getCommand("craft").setExecutor((CommandExecutor)new Commands());
        this.getCommand("fusion-editor").setExecutor((CommandExecutor)new FusionEditorCommand());
        Fusion.registerListener(this);
        Fusion.registerListener(new RecipeGuiEventRouter());
        this.runQueueTask();
        if (hookManager.isHooked(HookType.PlaceholderAPI)) {
            new FusionPlaceholders().register();
        }
        FusionAPI.init();
    }

    public void closeAll() {
        ProfessionsCfg.closeAll();
        BrowseGUI.closeAll();
    }

    public void onDisable() {
        super.onDisable();
        PlayerLoader.clearCache();
        this.closeAll();
    }

    public double getPlayerCooldown(Player player) {
        if (this.cachedCooldowns.containsKey(player.getUniqueId())) {
            return this.cachedCooldowns.get(player.getUniqueId());
        }
        double num = 0.0;
        for (PermissionAttachmentInfo permission : player.getEffectivePermissions()) {
            String perm = permission.getPermission();
            if (!perm.startsWith("fusion.cooldown")) continue;
            String mod = perm.substring(perm.lastIndexOf(".") + 1);
            if (mod.equals("*")) {
                num = 1.0;
                continue;
            }
            try {
                num = (double)Integer.parseInt(mod) / 100.0;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.cachedCooldowns.put(player.getUniqueId(), num);
        return num;
    }

    private void notifyForQueue(Player player) {
        int finishedQueueAmount = PlayerLoader.getPlayer(player.getUniqueId()).getFinishedSize();
        if (finishedQueueAmount > 0) {
            Cfg.notifyForQueue(player, finishedQueueAmount);
        }
    }

    private void runQueueTask() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> Bukkit.getOnlinePlayers().forEach(this::notifyForQueue), 0L, (long)Cfg.finishedMessageInterval * 20L);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            PlayerLoader.getPlayerBlocking(player, 5000L);
            Bukkit.getScheduler().runTask((Plugin)this, () -> {
                if (!Cfg.autoJoinProfessions.isEmpty()) {
                    Cfg.autoJoinProfessions(player);
                }
                if (Cfg.craftingQueue) {
                    this.notifyForQueue(player);
                }
            });
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        PlayerLoader.unloadPlayer(event.getPlayer());
    }

    public static void registerListener(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)Fusion.getInstance());
    }

    @Generated
    public static Fusion getInstance() {
        return instance;
    }

    @Generated
    public static HookManager getHookManager() {
        return hookManager;
    }
}

