/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.fusion.Fusion;

public class FileUT {
    public static void copy(@NotNull InputStream inputStream, @NotNull File file) {
        try {
            int read;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] array = new byte[1024];
            while ((read = inputStream.read(array)) > 0) {
                fileOutputStream.write(array, 0, read);
            }
            fileOutputStream.close();
            inputStream.close();
        }
        catch (IOException e) {
            Fusion.getInstance().getLogger().warning("Couldn't copy file properly: " + e.getMessage());
        }
    }

    public static void mkdir(@NotNull File file) {
        try {
            file.mkdir();
        }
        catch (Exception var2) {
            var2.printStackTrace();
        }
    }

    public static void create(@NotNull File file) {
        File parent;
        if (!file.exists() && (parent = file.getParentFile()) != null) {
            parent.mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException var3) {
                var3.printStackTrace();
            }
        }
    }

    @NotNull
    public static List<File> getFiles(@NotNull String path) {
        ArrayList<File> names = new ArrayList<File>();
        File folder = new File(path);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                if (file.isFile()) {
                    names.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                names.addAll(FileUT.getFiles(file.getPath()));
            }
        }
        return names;
    }

    @NotNull
    public static List<File> getFolders(@NotNull String path) {
        ArrayList<File> dirs = new ArrayList<File>();
        File folder = new File(path);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (File f : listOfFiles) {
                if (!f.isDirectory()) continue;
                dirs.add(f);
            }
        }
        return dirs;
    }

    public static boolean deleteRecursive(@NotNull String path) {
        File dir = new File(path);
        return dir.exists() && FileUT.deleteRecursive(dir);
    }

    public static boolean deleteRecursive(@NotNull File dir) {
        File[] inside = dir.listFiles();
        if (inside != null) {
            for (File file : inside) {
                FileUT.deleteRecursive(file);
            }
        }
        return dir.delete();
    }
}

