/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.util;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.cfg.sql.SQLManager;
import studio.magemonkey.fusion.data.professions.Profession;
import studio.magemonkey.fusion.data.recipes.CraftingTable;

public final class ExperienceManager {
    private static final File file = new File(Fusion.getInstance().getDataFolder(), "data.yml");

    public static void migrateIntoSQL() {
        if (!file.exists()) {
            return;
        }
        YamlConfiguration cfg = new YamlConfiguration();
        try {
            cfg.load(file);
        }
        catch (Exception e) {
            Fusion.getInstance().getLogger().warning("Can't load exp data file: " + String.valueOf(file));
            e.printStackTrace();
            return;
        }
        List typesSection = cfg.getMapList("data");
        for (Map typeData : typesSection) {
            PlayerData playerData = new PlayerData(typeData);
            for (Map.Entry<CraftingTable, Integer> table : playerData.data.entrySet()) {
                SQLManager.professions().setProfession(playerData.uuid, new Profession(-1L, playerData.getUuid(), table.getKey().getName(), playerData.getExperience(table.getKey()).intValue(), false, false));
                Fusion.getInstance().getLogger().info("Migrated " + String.valueOf(playerData.getUuid()) + " with " + table.getKey().getName());
            }
            if (!playerData.data.isEmpty()) continue;
            typesSection.remove(typeData);
        }
        if (typesSection.isEmpty()) {
            ExperienceManager.backup();
            if (file.delete()) {
                Fusion.getInstance().getLogger().info("Deleted data.yml");
            }
        } else {
            cfg.set("data", (Object)typesSection);
        }
    }

    public static void backup() {
        if (!file.exists()) {
            return;
        }
        YamlConfiguration cfg = new YamlConfiguration();
        try {
            cfg.load(file);
            File backupFile = new File(Fusion.getInstance().getDataFolder(), "backup/data.yml");
            cfg.save(backupFile);
            Fusion.getInstance().getLogger().info("Backup saved to " + String.valueOf(backupFile));
        }
        catch (Exception e) {
            Fusion.getInstance().getLogger().warning("Can't load exp data file: " + String.valueOf(file));
            e.printStackTrace();
        }
    }

    @Deprecated
    public static int getTotalExperience(Player player) {
        int level = player.getLevel();
        if (level >= 0 && level <= 15) {
            int experience = (int)Math.ceil(Math.pow(level, 2.0) + (double)(6 * level));
            int requiredExperience = 2 * level + 7;
            double currentExp = Double.parseDouble(Float.toString(player.getExp()));
            return experience += (int)Math.ceil(currentExp * (double)requiredExperience);
        }
        if (level > 15 && level <= 30) {
            int experience = (int)Math.ceil(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
            int requiredExperience = 5 * level - 38;
            double currentExp = Double.parseDouble(Float.toString(player.getExp()));
            return experience += (int)Math.ceil(currentExp * (double)requiredExperience);
        }
        int experience = (int)Math.ceil(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
        int requiredExperience = 9 * level - 158;
        double currentExp = Double.parseDouble(Float.toString(player.getExp()));
        return experience += (int)Math.ceil(currentExp * (double)requiredExperience);
    }

    @Deprecated
    public static void setTotalExperience(Player player, int xp) {
        if (xp >= 0 && xp < 351) {
            int a = 1;
            int b = 6;
            int c = -xp;
            int level = (int)((double)(-b) + Math.sqrt(Math.pow(b, 2.0) - (double)(4 * a * c))) / (2 * a);
            int xpForLevel = (int)(Math.pow(level, 2.0) + (double)(6 * level));
            int remainder = xp - xpForLevel;
            int experienceNeeded = 2 * level + 7;
            float experience = (float)remainder / (float)experienceNeeded;
            experience = ExperienceManager.round(experience, 2);
            player.setLevel(level);
            player.setExp(experience);
        } else if (xp >= 352 && xp < 1507) {
            double a = 2.5;
            double b = -40.5;
            int c = -xp + 360;
            double dLevel = (-b + Math.sqrt(Math.pow(b, 2.0) - 4.0 * a * (double)c)) / (2.0 * a);
            int level = (int)Math.floor(dLevel);
            int xpForLevel = (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
            int remainder = xp - xpForLevel;
            int experienceNeeded = 5 * level - 38;
            float experience = (float)remainder / (float)experienceNeeded;
            experience = ExperienceManager.round(experience, 2);
            player.setLevel(level);
            player.setExp(experience);
        } else {
            double a = 4.5;
            double b = -162.5;
            int c = -xp + 2220;
            double dLevel = (-b + Math.sqrt(Math.pow(b, 2.0) - 4.0 * a * (double)c)) / (2.0 * a);
            int level = (int)Math.floor(dLevel);
            int xpForLevel = (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
            int remainder = xp - xpForLevel;
            int experienceNeeded = 9 * level - 158;
            float experience = (float)remainder / (float)experienceNeeded;
            experience = ExperienceManager.round(experience, 2);
            player.setLevel(level);
            player.setExp(experience);
        }
    }

    private static float round(float d, int decimalPlace) {
        BigDecimal bd = new BigDecimal(Float.toString(d));
        bd = bd.setScale(decimalPlace, RoundingMode.HALF_DOWN);
        return bd.floatValue();
    }

    public static class PlayerData {
        private final UUID uuid;
        private final Map<CraftingTable, Integer> data = new HashMap<CraftingTable, Integer>();

        public PlayerData(Map<String, Object> map) {
            this.uuid = UUID.fromString((String)map.get("uuid"));
            ((Map)map.get("data")).forEach((key, value) -> this.data.put(ProfessionsCfg.getTable(key), (Integer)value));
        }

        public Integer getExperience(CraftingTable craftingTable) {
            return this.data.getOrDefault(craftingTable, 0);
        }

        public void remove(String craftingTable) {
            this.data.remove(ProfessionsCfg.getTable(craftingTable));
        }

        @Generated
        public UUID getUuid() {
            return this.uuid;
        }
    }
}

