/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui.recipe;

import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import studio.magemonkey.fusion.data.player.FusionPlayer;
import studio.magemonkey.fusion.data.player.PlayerLoader;
import studio.magemonkey.fusion.gui.ProfessionGuiRegistry;
import studio.magemonkey.fusion.gui.RecipeGui;

public class RecipeGuiEventRouter
implements Listener {
    private RecipeGui findGuiFor(Player player, Inventory inv) {
        if (!ProfessionGuiRegistry.getLatestRecipeGui().containsKey(player.getUniqueId())) {
            return null;
        }
        RecipeGui gui = ProfessionGuiRegistry.getLatestRecipeGui().get(player.getUniqueId());
        if (gui.getInventory().equals((Object)inv)) {
            return gui;
        }
        return null;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        Inventory inv = event.getInventory();
        RecipeGui gui = this.findGuiFor(p, inv);
        if (gui == null) {
            return;
        }
        if (!inv.equals((Object)gui.getInventory())) {
            return;
        }
        if (event.getRawSlot() < 0) {
            return;
        }
        gui.click(event);
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        Inventory inv = event.getInventory();
        RecipeGui gui = this.findGuiFor(p, inv);
        if (gui == null) {
            return;
        }
        if (!inv.equals((Object)gui.getInventory())) {
            return;
        }
        gui.onDrag(event);
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        Inventory inv = event.getInventory();
        RecipeGui gui = this.findGuiFor(p, inv);
        if (gui == null) {
            return;
        }
        gui.close(p, inv);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDrop(PlayerDropItemEvent event) {
        Player p = event.getPlayer();
        RecipeGui gui = this.findGuiFor(p, p.getOpenInventory().getTopInventory());
        if (gui == null) {
            return;
        }
        gui.drop(event);
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemPickup(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player p = (Player)livingEntity;
        RecipeGui gui = this.findGuiFor(p, p.getOpenInventory().getTopInventory());
        if (gui == null) {
            return;
        }
        gui.reloadRecipesTask();
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player p = event.getPlayer();
        FusionPlayer fp = PlayerLoader.getPlayer(p);
        if (fp == null) {
            return;
        }
        RecipeGui gui = ProfessionGuiRegistry.getLatestRecipeGui().get(p.getUniqueId());
        if (gui == null) {
            return;
        }
        gui.close(p, gui.getInventory());
        ProfessionGuiRegistry.getLatestRecipeGui().remove(p.getUniqueId());
    }
}

