/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui.editors.professions.recipes;

import java.util.ArrayList;
import lombok.Generated;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import studio.magemonkey.codex.api.DelayedCommand;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.editors.EditorCriteria;
import studio.magemonkey.fusion.cfg.editors.EditorRegistry;
import studio.magemonkey.fusion.commands.FusionEditorCommand;
import studio.magemonkey.fusion.data.recipes.Recipe;
import studio.magemonkey.fusion.gui.editors.Editor;
import studio.magemonkey.fusion.util.InventoryUtils;

public class RecipeIconEditor
extends Editor
implements Listener {
    private final Player player;
    private final Recipe recipe;

    public RecipeIconEditor(Editor parentEditor, Player player, Recipe recipe) {
        super(parentEditor, EditorRegistry.getRecipeIconEditorCfg().getTitle(), 45);
        this.player = player;
        this.recipe = recipe;
        this.setIcons(EditorRegistry.getRecipeIconEditorCfg().getIcons(recipe));
        this.initialize();
        Fusion.registerListener(this);
    }

    private void initialize() {
        InventoryUtils.fillInventory(this.getInventory(), this.getIcons().get("fill"));
        this.setItem(10, this.getIcons().get("name"));
        this.setItem(11, this.getIcons().get("lore"));
        this.setItem(15, this.getIcons().get("customModelData"));
        this.setItem(16, this.getIcons().get("commands"));
        this.setItem(29, this.getIcons().get("color"));
        this.setItem(30, this.getIcons().get("unbreakable"));
        this.setItem(32, this.getIcons().get("enchants"));
        this.setItem(33, this.getIcons().get("flags"));
        this.setItem(44, this.getIcons().get("back"));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory() != this.getInventory()) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        boolean hasChanges = false;
        switch (event.getSlot()) {
            case 10: {
                if (event.isLeftClick()) {
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.RecipeIcon_Edit_Name, "/fusion-editor " + this.recipe.getSettings().getName());
                    break;
                }
                if (!event.isRightClick()) break;
                this.recipe.getSettings().setName(null);
                hasChanges = true;
                break;
            }
            case 11: {
                if (event.isLeftClick()) {
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.RecipeIcon_Edit_Lore, "/fusion-editor <lore>");
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.recipe.getSettings().getLore().isEmpty()) {
                    return;
                }
                this.recipe.getSettings().getLore().remove(this.recipe.getSettings().getLore().size() - 1);
                hasChanges = true;
                break;
            }
            case 15: {
                int amount;
                int n = amount = event.isShiftClick() ? 10 : 1;
                if (event.isLeftClick()) {
                    this.recipe.getSettings().setCustomModelData(this.recipe.getSettings().getCustomModelData() + amount);
                } else if (event.isRightClick()) {
                    if (this.recipe.getSettings().getCustomModelData() == -1) {
                        return;
                    }
                    this.recipe.getSettings().setCustomModelData(Math.max(this.recipe.getSettings().getCustomModelData() - amount, -1));
                }
                hasChanges = true;
                break;
            }
            case 16: {
                if (event.isLeftClick()) {
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.RecipeIcon_Add_Commands, "/fusion-editor <caster> <delay> <command without />");
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.recipe.getSettings().getCommandsOnClick().isEmpty()) {
                    return;
                }
                DelayedCommand command = new ArrayList<DelayedCommand>(this.recipe.getSettings().getCommandsOnClick()).get(this.recipe.getSettings().getCommandsOnClick().size() - 1);
                this.recipe.getSettings().getCommandsOnClick().remove(command);
                hasChanges = true;
                break;
            }
            case 26: {
                this.reload(false);
                this.openParent(player);
                return;
            }
            case 29: {
                if (event.isLeftClick()) {
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.RecipeIcon_Edit_Color, "/fusion-editor " + this.recipe.getSettings().getColor());
                    break;
                }
                if (!event.isRightClick()) break;
                this.recipe.getSettings().setColor(null);
                hasChanges = true;
                break;
            }
            case 30: {
                this.recipe.getSettings().setUnbreakable(!this.recipe.getSettings().isUnbreakable());
                hasChanges = true;
                break;
            }
            case 32: {
                if (event.isLeftClick()) {
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.RecipeIcon_Add_Enchants, "/fusion-editor <enchantment> [level]");
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.recipe.getSettings().getEnchantments().isEmpty()) {
                    return;
                }
                Enchantment lastEnchantment = new ArrayList<Enchantment>(this.recipe.getSettings().getEnchantments().keySet()).get(this.recipe.getSettings().getEnchantments().size() - 1);
                this.recipe.getSettings().getEnchantments().remove(lastEnchantment);
                hasChanges = true;
                break;
            }
            case 33: {
                if (event.isLeftClick()) {
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.RecipeIcon_Add_Flags, "/fusion-editor <flag>");
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.recipe.getSettings().getFlags().isEmpty()) {
                    return;
                }
                ItemFlag lastFlag = new ArrayList<ItemFlag>(this.recipe.getSettings().getFlags()).get(this.recipe.getSettings().getFlags().size() - 1);
                this.recipe.getSettings().getFlags().remove(lastFlag);
                hasChanges = true;
                break;
            }
            case 44: {
                this.getParentEditor().open(player);
                return;
            }
        }
        if (hasChanges) {
            this.reload(true);
        }
    }

    public void reload(boolean open) {
        this.setIcons(EditorRegistry.getRecipeIconEditorCfg().getIcons(this.recipe));
        this.initialize();
        if (open) {
            this.open(this.player);
        }
    }

    public void addCommand(DelayedCommand command) {
        this.recipe.getSettings().getCommandsOnClick().add(command);
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public Recipe getRecipe() {
        return this.recipe;
    }
}

