/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui.editors.professions;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.editors.EditorCriteria;
import studio.magemonkey.fusion.cfg.editors.EditorRegistry;
import studio.magemonkey.fusion.commands.FusionEditorCommand;
import studio.magemonkey.fusion.data.professions.pattern.Category;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.gui.editors.Editor;
import studio.magemonkey.fusion.util.InventoryUtils;

public class CategoryEditor
extends Editor
implements Listener {
    private final Player player;
    private final CraftingTable table;
    private String lastEditedCategoryName;
    private final Map<Integer, Category> slots = new HashMap<Integer, Category>();

    public CategoryEditor(Editor parentEditor, Player player, CraftingTable table) {
        super(parentEditor, EditorRegistry.getCategoryEditorCfg().getTitle(), 54);
        this.player = player;
        this.table = table;
        this.setIcons(EditorRegistry.getCategoryEditorCfg().getIcons(table));
        this.initialize();
        Fusion.registerListener(this);
    }

    public void initialize() {
        this.slots.clear();
        InventoryUtils.fillInventory(this.getInventory(), this.getIcons().get("fill"));
        int slot = 9;
        for (Map.Entry<String, Category> entry : this.table.getCategories().entrySet()) {
            ItemStack icon = entry.getValue().getDisplayIcon();
            if (icon.getType().isAir()) continue;
            this.slots.put(slot, entry.getValue());
            ++slot;
        }
        this.setItem(4, this.getIcons().get("add"));
        this.setItem(53, this.getIcons().get("back"));
        for (int i = 9; i < 45; ++i) {
            if (this.slots.containsKey(i)) {
                this.setItem(i, EditorRegistry.getCategoryEditorCfg().getCategoryItemIcon(this.slots.get(i)));
                continue;
            }
            this.setItem(i, new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE));
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory() != this.getInventory()) {
            return;
        }
        boolean hasChanges = false;
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        if (event.getClickedInventory() == this.getInventory()) {
            event.setCancelled(true);
            block0 : switch (event.getSlot()) {
                case 4: {
                    FusionEditorCommand.suggestUsage(player, EditorCriteria.Profession_Category_Add, "/fusion-editor <categoryName> <categoryIcon>");
                    break;
                }
                case 53: {
                    this.openParent(player);
                    break;
                }
                default: {
                    if (!this.slots.containsKey(event.getSlot())) break;
                    if (!event.isShiftClick()) {
                        if (event.isLeftClick()) {
                            this.lastEditedCategoryName = this.slots.get(event.getSlot()).getName();
                            FusionEditorCommand.suggestUsage(player, EditorCriteria.Profession_Category_Edit, "/fusion-editor " + this.slots.get(event.getSlot()).getName() + " <categoryIcon>");
                            break;
                        }
                        if (!event.isRightClick()) break;
                        this.table.getCategories().remove(this.slots.get(event.getSlot()).getName());
                        hasChanges = true;
                        break;
                    }
                    if (event.isLeftClick()) {
                        int order = this.slots.get(event.getSlot()).getOrder();
                        if (order <= 0) break;
                        for (Category category : this.table.getCategories().values()) {
                            if (category.getOrder() != order - 1) continue;
                            category.setOrder(order);
                            this.table.getCategories().get(this.slots.get(event.getSlot()).getName()).setOrder(order - 1);
                            this.table.updateCategoryOrder();
                            hasChanges = true;
                            break block0;
                        }
                    } else {
                        int order;
                        if (!event.isRightClick() || (order = this.slots.get(event.getSlot()).getOrder()) > this.table.getCategories().size() - 1) break;
                        for (Category category : this.table.getCategories().values()) {
                            if (category.getOrder() != order + 1) continue;
                            category.setOrder(order);
                            this.table.getCategories().get(this.slots.get(event.getSlot()).getName()).setOrder(order + 1);
                            this.table.updateCategoryOrder();
                            hasChanges = true;
                            break block0;
                        }
                    }
                }
            }
        }
        if (hasChanges) {
            this.reload(true);
        }
    }

    public void reload(boolean open) {
        this.setIcons(EditorRegistry.getPatternItemEditorCfg().getIcons(this.table));
        this.initialize();
        if (open) {
            this.open(this.player);
        }
    }

    @Generated
    public String getLastEditedCategoryName() {
        return this.lastEditedCategoryName;
    }
}

