/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui.editors.pattern;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.editors.EditorRegistry;
import studio.magemonkey.fusion.data.professions.pattern.InventoryPattern;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.gui.editors.Editor;
import studio.magemonkey.fusion.gui.editors.browse.BrowseEditor;
import studio.magemonkey.fusion.gui.editors.pattern.PatternItemEditor;
import studio.magemonkey.fusion.util.InventoryUtils;

public class PatternItemsEditor
extends Editor
implements Listener {
    private final Player player;
    private InventoryPattern pattern;
    private final CraftingTable table;
    private final boolean isCategoryPattern;
    private final BrowseEditor browseEditor;
    private PatternItemEditor patternItemEditor;
    private final Map<Integer, Character> slots = new HashMap<Integer, Character>();
    private final Map<Character, ItemStack> visualPatternItems = new HashMap<Character, ItemStack>();
    List<Map.Entry<Boolean, Map.Entry<Character, ItemStack>>> clipboardUndo = new ArrayList<Map.Entry<Boolean, Map.Entry<Character, ItemStack>>>();
    List<Map.Entry<Boolean, Map.Entry<Character, ItemStack>>> clipboardRedo = new ArrayList<Map.Entry<Boolean, Map.Entry<Character, ItemStack>>>();

    public PatternItemsEditor(Editor parentEditor, Player player, CraftingTable table, boolean isCategoryPattern) {
        super(parentEditor, EditorRegistry.getPatternItemEditorCfg().getTitle(), 54);
        this.player = player;
        this.table = table;
        this.isCategoryPattern = isCategoryPattern;
        this.browseEditor = null;
        this.setIcons(EditorRegistry.getPatternItemEditorCfg().getIcons(table));
        InventoryPattern inventoryPattern = this.pattern = isCategoryPattern ? table.getCatPattern() : table.getRecipePattern();
        if (this.pattern == null) {
            table.setCatPattern(InventoryPattern.copy(table.getRecipePattern()));
            this.pattern = table.getCatPattern();
            player.sendMessage("\u00a7cNo category pattern found. Using default pattern as reference.");
        }
        this.initialize();
        Fusion.registerListener(this);
    }

    public PatternItemsEditor(BrowseEditor browseEditor, Player player) {
        super(browseEditor, EditorRegistry.getPatternItemEditorCfg().getTitle(), 54);
        this.player = player;
        this.browseEditor = browseEditor;
        this.table = null;
        this.isCategoryPattern = false;
        this.setIcons(EditorRegistry.getPatternItemEditorCfg().getIcons(browseEditor));
        this.pattern = browseEditor.getBrowsePattern();
        this.initialize();
        Fusion.registerListener(this);
    }

    private void initialize() {
        this.slots.clear();
        this.visualPatternItems.clear();
        InventoryUtils.fillInventory(this.getInventory(), this.getIcons().get("fill"));
        ArrayList<Map.Entry> visualPatternItemsList = new ArrayList<Map.Entry>();
        for (Map.Entry<Character, ItemStack> entry : this.pattern.getItems().entrySet()) {
            if (entry.getValue() == null || entry.getValue().getType().isAir()) continue;
            this.visualPatternItems.put((Character)entry.getKey(), EditorRegistry.getPatternItemEditorCfg().getPatternItemIcon(((Character)entry.getKey()).charValue(), (ItemStack)entry.getValue()));
            visualPatternItemsList.add(Map.entry((Character)entry.getKey(), this.visualPatternItems.get(entry.getKey())));
        }
        visualPatternItemsList.sort(Comparator.comparing(e -> ((ItemStack)e.getValue()).getType()));
        int slot = 9;
        for (Map.Entry entry : visualPatternItemsList) {
            this.slots.put(slot, (Character)entry.getKey());
            ++slot;
        }
        this.setItem(3, this.getIcons().get("undo"));
        this.setItem(4, this.getIcons().get("add"));
        this.setItem(5, this.getIcons().get("redo"));
        this.setItem(53, this.getIcons().get("back"));
        for (int i = 9; i < 45; ++i) {
            if (this.slots.containsKey(i)) {
                this.setItem(i, this.visualPatternItems.get(this.slots.get(i)));
                continue;
            }
            this.setItem(i, new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE));
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory() != this.getInventory()) {
            return;
        }
        boolean hasChanges = false;
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        if (event.getClickedInventory() == this.getInventory()) {
            event.setCancelled(true);
            switch (event.getSlot()) {
                case 3: {
                    if (this.clipboardUndo.isEmpty()) {
                        return;
                    }
                    Map.Entry<Boolean, Map.Entry<Character, ItemStack>> entry = this.clipboardUndo.get(this.clipboardUndo.size() - 1);
                    if (entry.getKey().booleanValue()) {
                        this.pattern.getItems().put(entry.getValue().getKey(), entry.getValue().getValue());
                    } else {
                        this.pattern.getItems().remove(entry.getValue().getKey());
                    }
                    this.clipboardRedo.add(entry);
                    this.clipboardUndo.remove(this.clipboardUndo.size() - 1);
                    hasChanges = true;
                    break;
                }
                case 5: {
                    if (this.clipboardRedo.isEmpty()) {
                        return;
                    }
                    Map.Entry<Boolean, Map.Entry<Character, ItemStack>> entry = this.clipboardRedo.get(0);
                    if (!entry.getKey().booleanValue()) {
                        this.pattern.getItems().put(entry.getValue().getKey(), entry.getValue().getValue());
                    } else {
                        this.pattern.getItems().remove(entry.getValue().getKey());
                    }
                    this.clipboardUndo.add(entry);
                    this.clipboardRedo.remove(0);
                    hasChanges = true;
                    break;
                }
                case 53: {
                    this.openParent(player);
                    break;
                }
                default: {
                    if (this.slots.containsKey(event.getSlot())) {
                        if (event.isLeftClick()) {
                            if (this.patternItemEditor == null) {
                                if (this.table != null) {
                                    this.patternItemEditor = new PatternItemEditor(this, player, this.table, this.slots.get(event.getSlot()).charValue(), this.isCategoryPattern);
                                } else if (this.browseEditor != null) {
                                    this.patternItemEditor = new PatternItemEditor(this, this.browseEditor, player, this.slots.get(event.getSlot()).charValue());
                                }
                            }
                            this.patternItemEditor.open(player);
                            break;
                        }
                        char c = this.slots.get(event.getSlot()).charValue();
                        switch (c) {
                            case '-': 
                            case '<': 
                            case '>': 
                            case 'f': 
                            case 'o': 
                            case '{': 
                            case '}': {
                                CodexEngine.get().getMessageUtil().sendMessage("editor.patternItemPredefined", (CommandSender)player, new MessageData[0]);
                                return;
                            }
                        }
                        if (this.pattern.isUsed(c)) {
                            CodexEngine.get().getMessageUtil().sendMessage("editor.patternItemUsed", (CommandSender)player, new MessageData[0]);
                            return;
                        }
                        this.clipboardUndo.add(Map.entry(true, Map.entry(Character.valueOf(c), this.pattern.getItems().get(Character.valueOf(c)))));
                        this.pattern.getItems().remove(Character.valueOf(c));
                        hasChanges = true;
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (event.getClickedInventory() == player.getInventory()) {
            ItemStack item = player.getInventory().getItem(event.getSlot());
            if (item == null || item.getType() == Material.AIR) {
                return;
            }
            char c = this.getFreeChar();
            if (c == ' ') {
                player.sendMessage("\u00a7cNo more free slots available");
                return;
            }
            this.pattern.getItems().put(Character.valueOf(c), item);
            this.clipboardUndo.add(Map.entry(false, Map.entry(Character.valueOf(c), item)));
            hasChanges = true;
        }
        if (hasChanges) {
            this.reload(false);
        }
    }

    public void reload(boolean open) {
        if (this.table != null) {
            this.setIcons(EditorRegistry.getPatternItemEditorCfg().getIcons(this.table));
        } else {
            this.setIcons(EditorRegistry.getPatternItemEditorCfg().getIcons(this.browseEditor));
        }
        this.initialize();
        if (open) {
            this.open(this.player);
        }
    }

    private char getFreeChar() {
        String chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        for (int i = 0; i < chars.length(); ++i) {
            if (this.pattern.getItems().size() == 37) {
                return ' ';
            }
            char c = chars.charAt(i);
            if (this.pattern.getItems().containsKey(Character.valueOf(c))) continue;
            return c;
        }
        return ' ';
    }

    @Generated
    public PatternItemEditor getPatternItemEditor() {
        return this.patternItemEditor;
    }
}

