/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.DelayedCommand;
import studio.magemonkey.codex.api.Replacer;
import studio.magemonkey.codex.util.ItemUtils;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.api.FusionAPI;
import studio.magemonkey.fusion.cfg.Cfg;
import studio.magemonkey.fusion.cfg.CraftingRequirementsCfg;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.data.player.PlayerLoader;
import studio.magemonkey.fusion.data.professions.pattern.Category;
import studio.magemonkey.fusion.data.professions.pattern.InventoryPattern;
import studio.magemonkey.fusion.data.queue.CraftingQueue;
import studio.magemonkey.fusion.data.queue.QueueItem;
import studio.magemonkey.fusion.data.recipes.CalculatedRecipe;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.data.recipes.Recipe;
import studio.magemonkey.fusion.data.recipes.RecipeItem;
import studio.magemonkey.fusion.gui.ProfessionGuiRegistry;
import studio.magemonkey.fusion.gui.recipe.IngredientFingerprint;
import studio.magemonkey.fusion.gui.recipe.InventoryFingerprint;
import studio.magemonkey.fusion.gui.recipe.RecipeCacheKey;
import studio.magemonkey.fusion.gui.slot.Slot;
import studio.magemonkey.fusion.hook.VaultHook;
import studio.magemonkey.fusion.util.ChatUT;
import studio.magemonkey.fusion.util.ExperienceManager;
import studio.magemonkey.fusion.util.PlayerUtil;

public class RecipeGui
implements Listener {
    private final Player player;
    private final CraftingTable table;
    protected final String name;
    private final String inventoryName;
    private final Category category;
    private InventoryPattern pattern;
    private final HashMap<Integer, CalculatedRecipe> recipes;
    private int page = 0;
    private int nextPage;
    private int prevPage;
    private boolean isLoaded = false;
    private int queuePage = 0;
    private int prevQueuePage;
    private int nextQueuePage;
    private CraftingQueue queue;
    private int lastQueueSecond = -1;
    private int lastQueueSize = 0;
    private BukkitTask craftingTask;
    private BukkitTask barTask;
    private BossBar bar;
    private final Collection<ItemStack> refund = new ArrayList<ItemStack>();
    private ItemStack previousCursor;
    private boolean craftingSuccess = true;
    private Recipe craftingRecipe = null;
    private Inventory inventory;
    private Slot[] slots;
    private final ArrayList<Integer> resultSlots = new ArrayList(20);
    private final ArrayList<Integer> blockedSlots = new ArrayList(20);
    private final ArrayList<Integer> queuedSlots = new ArrayList(20);
    private static final Map<RecipeCacheKey, CalculatedRecipe> recipeCache = Collections.synchronizedMap(new LinkedHashMap<RecipeCacheKey, CalculatedRecipe>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<RecipeCacheKey, CalculatedRecipe> eldest) {
            return this.size() > 100;
        }
    });
    private byte[] lastInventoryHash = new byte[0];
    private int lastSeenLevel = -1;
    private double lastSeenMoney = -1.0;
    private int lastPageCount = -1;
    private int lastQueuePageCount = -1;

    public RecipeGui(Player player, CraftingTable table, Category category) {
        this.player = player;
        this.table = table;
        this.name = table.getName();
        this.inventoryName = ChatUT.hexString(table.getInventoryName());
        this.recipes = new HashMap(20);
        Category category2 = this.category = category != null ? category : new Category("master", "PAPER", this.table.getRecipePattern(), 1);
        if (this.category.getPattern() == null) {
            this.category.setPattern(table.getRecipePattern());
        }
        if (this.category.getName().equals("master")) {
            this.category.getRecipes().addAll(this.table.getRecipes().values());
        }
        this.setPattern();
        if (Cfg.craftingQueue && this.pattern != null) {
            this.queue = FusionAPI.getPlayerManager().getPlayer(player).getQueue(table.getName(), this.category);
        }
        Fusion.registerListener(this);
        this.initialize();
    }

    private void mapSlots() {
        this.resultSlots.clear();
        this.queuedSlots.clear();
        this.slots = new Slot[this.pattern.getPattern().length * 9];
        int k = -1;
        int prevPage = -1;
        int nextPage = -1;
        int prevQueuePage = -1;
        int nextQueuePage = -1;
        for (String row : this.pattern.getPattern()) {
            block9: for (char c : row.toCharArray()) {
                ++k;
                switch (c) {
                    case '=': 
                    case 'o': {
                        this.slots[k] = Slot.BASE_RESULT_SLOT;
                        this.resultSlots.add(k);
                        continue block9;
                    }
                    case '>': {
                        this.slots[k] = Slot.BLOCKED_SLOT;
                        nextPage = k;
                        continue block9;
                    }
                    case '<': {
                        this.slots[k] = Slot.BLOCKED_SLOT;
                        prevPage = k;
                        continue block9;
                    }
                    case '-': {
                        this.slots[k] = Slot.QUEUED_SLOT;
                        this.queuedSlots.add(k);
                        continue block9;
                    }
                    case '}': {
                        this.slots[k] = Slot.BLOCKED_SLOT;
                        nextQueuePage = k;
                        continue block9;
                    }
                    case '{': {
                        this.slots[k] = Slot.BLOCKED_SLOT;
                        prevQueuePage = k;
                        continue block9;
                    }
                    default: {
                        this.slots[k] = Slot.BLOCKED_SLOT;
                        this.blockedSlots.add(k);
                    }
                }
            }
        }
        this.nextPage = nextPage;
        this.prevPage = prevPage;
        this.nextQueuePage = nextQueuePage;
        this.prevQueuePage = prevQueuePage;
    }

    public void updateBlockedSlots(MessageData[] data) {
        int totalItems = this.category.getRecipes().size();
        int queuedTotalItems = this.queue != null ? this.queue.getQueue().size() : 0;
        int fullPages = totalItems / this.resultSlots.size();
        int rest = totalItems % this.resultSlots.size();
        int pages = rest == 0 ? fullPages : fullPages + 1;
        boolean includeBack = this.category.hasPrevious();
        int queuedPages = -1;
        if (!this.queuedSlots.isEmpty()) {
            int queuedFullPages = queuedTotalItems / this.queuedSlots.size();
            int queuedRest = queuedTotalItems % this.queuedSlots.size();
            queuedPages = queuedRest == 0 ? queuedFullPages : queuedFullPages + 1;
        }
        int k = -1;
        HashMap<Character, ItemStack> items = this.pattern.getItems();
        ArrayList<Integer> leaveBlank = new ArrayList<Integer>();
        ArrayList<Integer> fill = new ArrayList<Integer>();
        for (String row : this.pattern.getPattern()) {
            for (char c : row.toCharArray()) {
                ++k;
                ItemStack item = ItemUtils.replaceText((ItemStack)items.get(Character.valueOf(c)), (MessageData[])data);
                if (!includeBack && c == '<' && this.page <= 0) {
                    leaveBlank.add(k);
                    continue;
                }
                if (c == '>' && this.page + 1 >= pages) {
                    leaveBlank.add(k);
                    continue;
                }
                if (c == '{' && Cfg.craftingQueue && this.queuePage <= 0) {
                    fill.add(k);
                    continue;
                }
                if (c == '}' && Cfg.craftingQueue && queuedPages > -1 && this.queuePage + 1 >= queuedPages) {
                    fill.add(k);
                    continue;
                }
                if (item != null && c != '-') {
                    this.inventory.setItem(k, item.clone());
                    continue;
                }
                if (item == null) continue;
                if (this.queue != null && this.queue.getQueuedItems().containsKey(k)) {
                    this.inventory.setItem(k, this.queue.getQueuedItems().get(k).getIcon());
                    continue;
                }
                this.inventory.setItem(k, ProfessionsCfg.getQueueSlot(this.name));
            }
        }
        for (Integer index : leaveBlank) {
            if (this.inventory.getSize() > index + 1) {
                this.inventory.setItem(index.intValue(), this.inventory.getItem(index + 1));
                continue;
            }
            this.inventory.setItem(index.intValue(), this.inventory.getItem(index - 1));
        }
        for (Integer index : fill) {
            this.inventory.setItem(index.intValue(), ProfessionsCfg.getFillItem(this.name));
        }
    }

    public void initialize() {
        this.inventory = Bukkit.createInventory(null, (int)this.pattern.getInventorySize(), (String)this.inventoryName);
        this.mapSlots();
    }

    public void reloadRecipes() {
        if (!this.player.isOnline()) {
            return;
        }
        try {
            int nowSec;
            int slotIndex;
            Integer[] recipe;
            Integer[] resultSlotArray;
            int queuePages;
            int pages;
            byte[] newHash = InventoryFingerprint.fingerprint(this.player);
            int newLevel = this.table.getLevelFunction().getLevel((OfflinePlayer)this.player);
            double newMoney = VaultHook.getBalance(this.player);
            boolean invChanged = !Arrays.equals(newHash, this.lastInventoryHash);
            boolean levelChanged = newLevel != this.lastSeenLevel;
            boolean moneyChanged = newMoney != this.lastSeenMoney;
            this.lastInventoryHash = newHash;
            this.lastSeenLevel = newLevel;
            this.lastSeenMoney = newMoney;
            this.setPattern();
            ItemStack fill = this.table.getFillItem();
            ArrayList<Recipe> allRecipesCollection = new ArrayList<Recipe>(this.category.getRecipes());
            allRecipesCollection.removeIf(r -> r.isHidden(this.player));
            int pageSize = this.resultSlots.size();
            int totalItems = allRecipesCollection.size();
            int page = this.page;
            int fullPages = pageSize == 0 ? 0 : totalItems / pageSize;
            int rest = pageSize == 0 ? 0 : totalItems % pageSize;
            int n = pages = rest == 0 ? fullPages : fullPages + 1;
            if (page >= pages && pages > 0) {
                this.page = pages - 1;
                if (this.page != page) {
                    this.reloadRecipes();
                }
                return;
            }
            ArrayList<QueueItem> allQueuedItems = Cfg.craftingQueue && this.queue != null ? new ArrayList<QueueItem>(this.queue.getQueue()) : Collections.emptyList();
            int queueSize = allQueuedItems.size();
            int queuePageSize = this.queuedSlots.size();
            int fullQueuePages = queuePageSize == 0 ? 0 : queueSize / queuePageSize;
            int restQueue = queuePageSize == 0 ? 0 : queueSize % queuePageSize;
            int n2 = queuePages = restQueue == 0 ? fullQueuePages : fullQueuePages + 1;
            if (this.queuePage >= queuePages && queuePages > 0) {
                this.queuePage = queuePages - 1;
                this.reloadRecipes();
                return;
            }
            boolean hasUnfinishedQueue = Cfg.craftingQueue && this.queue != null && !this.queue.getQueuedItems().isEmpty();
            boolean queueSizeChanged = queueSize != this.lastQueueSize;
            this.lastQueueSize = queueSize;
            if (!(invChanged || levelChanged || moneyChanged || this.lastPageCount != page || this.lastQueuePageCount != this.queuePage || hasUnfinishedQueue || queueSizeChanged)) {
                return;
            }
            this.lastPageCount = page;
            this.lastQueuePageCount = this.queuePage;
            HashMap<IngredientFingerprint, Integer> invCounts = new HashMap<IngredientFingerprint, Integer>();
            for (ItemStack is : this.player.getInventory().getContents()) {
                if (is == null || is.getType() == Material.AIR) continue;
                IngredientFingerprint fp = IngredientFingerprint.of(is);
                invCounts.merge(fp, is.getAmount(), Integer::sum);
            }
            for (Integer slotIndex2 : resultSlotArray = this.resultSlots.toArray(new Integer[0])) {
                if (slotIndex2 == null) continue;
                this.inventory.setItem(slotIndex2.intValue(), null);
            }
            this.recipes.clear();
            Recipe[] allRecipesArray = allRecipesCollection.toArray(new Recipe[0]);
            int startIndex = page * pageSize;
            int endIndex = Math.min(startIndex + pageSize, totalItems);
            int i = startIndex;
            int idx = 0;
            while (i < endIndex) {
                CalculatedRecipe calc;
                recipe = allRecipesArray[i];
                slotIndex = resultSlotArray[idx];
                RecipeCacheKey cacheKey = new RecipeCacheKey(recipe.getRecipePath(), newHash, newLevel, newMoney);
                if (recipeCache.containsKey(cacheKey)) {
                    calc = recipeCache.get(cacheKey);
                } else {
                    CalculatedRecipe fresh = CalculatedRecipe.create((Recipe)recipe, new HashMap<IngredientFingerprint, Integer>(invCounts), this.player, this.table);
                    recipeCache.put(cacheKey, fresh);
                    calc = fresh;
                }
                this.recipes.put(slotIndex, calc);
                this.inventory.setItem(slotIndex, calc.getIcon().clone());
                ++i;
                ++idx;
            }
            for (int k = 0; k < this.inventory.getSize(); ++k) {
                ItemStack it = this.inventory.getItem(k);
                if (it != null && it.getType() != Material.AIR) continue;
                this.inventory.setItem(k, fill.clone());
            }
            if (Cfg.craftingQueue && this.queue != null && ((nowSec = (int)(System.currentTimeMillis() / 1000L)) != this.lastQueueSecond || queueSizeChanged)) {
                Integer[] queuedIndices;
                this.lastQueueSecond = nowSec;
                recipe = queuedIndices = this.queuedSlots.toArray(new Integer[0]);
                slotIndex = recipe.length;
                for (int cacheKey = 0; cacheKey < slotIndex; ++cacheKey) {
                    int qIndex = recipe[cacheKey];
                    this.inventory.setItem(qIndex, ProfessionsCfg.getQueueSlot(this.table.getName()));
                }
                this.queue.getQueuedItems().clear();
                if (!allQueuedItems.isEmpty() && queuePageSize > 0) {
                    int j = 0;
                    int qStart = this.queuePage * queuePageSize;
                    int qEnd = Math.min(qStart + queuePageSize, queueSize);
                    QueueItem[] allQueueItemsArray = allQueuedItems.toArray(new QueueItem[0]);
                    Integer[] qSlots = queuedIndices;
                    for (int q = qStart; q < qEnd && j < qSlots.length; ++q, ++j) {
                        QueueItem qi = allQueueItemsArray[q];
                        int slot = qSlots[j];
                        this.queue.getQueuedItems().put(slot, qi);
                        qi.updateIcon();
                        this.inventory.setItem(slot, qi.getIcon().clone());
                    }
                }
            }
            this.updateBlockedSlots(new MessageData[]{new MessageData("level", (Object)this.table.getLevelFunction().getLevel((OfflinePlayer)this.player)), new MessageData("category", (Object)this.category), new MessageData("gui", (Object)this.getName()), new MessageData("player", (Object)this.player.getName()), new MessageData("bal", (Object)(CodexEngine.get().getVault() == null ? 0.0 : CodexEngine.get().getVault().getBalance((OfflinePlayer)this.player)))});
            this.isLoaded = true;
        }
        catch (Exception e) {
            this.inventory.clear();
            Bukkit.getScheduler().runTask((Plugin)Fusion.getInstance(), () -> ((Player)this.player).closeInventory());
            throw new RuntimeException("Exception was thrown when reloading recipes for: " + this.player.getName(), e);
        }
        finally {
            if (Cfg.craftingQueue && this.queue != null && !this.queue.getQueuedItems().isEmpty()) {
                boolean requiresUpdate = false;
                for (Map.Entry<Integer, QueueItem> entry : this.queue.getQueuedItems().entrySet()) {
                    if (entry.getValue().isDone()) continue;
                    requiresUpdate = true;
                    break;
                }
                if (requiresUpdate) {
                    Bukkit.getScheduler().runTaskLater((Plugin)Fusion.getInstance(), this::reloadRecipes, 20L);
                }
                this.isLoaded = true;
            }
        }
    }

    public void reloadRecipesTask() {
        Bukkit.getScheduler().runTaskLater((Plugin)Fusion.getInstance(), this::reloadRecipes, 1L);
    }

    private boolean validatePageCount() {
        int pages;
        if (this.page <= 0) {
            this.reloadRecipesTask();
            return false;
        }
        Collection<Recipe> allRecipes = this.table.getRecipes().values();
        int pageSize = this.resultSlots.size();
        int allRecipeCount = allRecipes.size();
        int page = this.page;
        int fullPages = allRecipeCount / pageSize;
        int rest = allRecipeCount % pageSize;
        int n = pages = rest == 0 ? fullPages : fullPages + 1;
        if (page >= pages) {
            this.page = pages;
            this.reloadRecipesTask();
            return false;
        }
        return true;
    }

    private void prevPage() {
        if (this.page <= 0) {
            this.cancel(true);
            ProfessionsCfg.getGUI(this.name).open(this.player);
            return;
        }
        --this.page;
        if (this.validatePageCount()) {
            this.reloadRecipesTask();
        }
    }

    private void nextPage() {
        ++this.page;
        if (this.validatePageCount()) {
            this.reloadRecipesTask();
        }
    }

    private boolean validateQueuePageCount() {
        int pages;
        if (this.queuePage <= 0) {
            this.reloadRecipesTask();
            return false;
        }
        List<QueueItem> allQueuedItems = this.queue.getQueue();
        int pageSize = this.queuedSlots.size();
        int count = allQueuedItems.size();
        int page = this.queuePage;
        int fullPages = count / pageSize;
        int rest = count % pageSize;
        int n = pages = rest == 0 ? fullPages : fullPages + 1;
        if (page >= pages) {
            this.queuePage = pages;
            this.reloadRecipesTask();
            return false;
        }
        return true;
    }

    private void prevQueuePage() {
        if (this.queuePage <= 0) {
            return;
        }
        --this.queuePage;
        if (this.validateQueuePageCount()) {
            this.reloadRecipesTask();
        }
    }

    private void nextQueuePage() {
        ++this.queuePage;
        if (this.validateQueuePageCount()) {
            this.reloadRecipesTask();
        }
    }

    public void setPattern() {
        this.pattern = this.category.getPattern();
        if (!this.pattern.getItems().containsKey(Character.valueOf('<')) || this.pattern.getItems().containsKey(Character.valueOf('>')) || this.pattern.getItems().containsKey(Character.valueOf('{')) || this.pattern.getItems().containsKey(Character.valueOf('}'))) {
            this.pattern.setItems(this.table.getRecipePattern().getItems());
        }
        this.mapSlots();
    }

    public void resetPattern() {
        this.pattern = this.category.getPattern();
        this.mapSlots();
    }

    public void setSlot(int i, Slot slot) {
        this.slots[i] = slot;
    }

    public Slot getSlot(int i) {
        return this.slots[i];
    }

    public void open(Player player) {
        ProfessionGuiRegistry.getLatestRecipeGui().put(player.getUniqueId(), this);
        if (!this.isLoaded) {
            this.reloadRecipes();
        }
        player.openInventory(this.inventory);
    }

    private boolean canCraft(CalculatedRecipe calculatedRecipe, int slot) {
        Recipe recipe = calculatedRecipe.getRecipe();
        if (calculatedRecipe.getRecipe().getConditions().isMastery() && !PlayerLoader.getPlayer(this.player).hasMastered(this.table.getName())) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.error.noMastery", (CommandSender)this.player, new MessageData[]{new MessageData("craftingTable", (Object)ProfessionsCfg.getTable(this.table.getName()))});
            return false;
        }
        if (!calculatedRecipe.isCanCraft()) {
            this.player.sendMessage(CraftingRequirementsCfg.getCanCraft(false));
            return false;
        }
        if (!Objects.equals(this.recipes.get(slot), calculatedRecipe)) {
            return false;
        }
        if (this.table.getLevelFunction().getLevel((OfflinePlayer)this.player) < recipe.getConditions().getProfessionLevel()) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.error.noLevel", (CommandSender)this.player, new MessageData[]{new MessageData("recipe", (Object)recipe)});
            return false;
        }
        if (ExperienceManager.getTotalExperience(this.player) < recipe.getConditions().getExpCost()) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.error.noXP", (CommandSender)this.player, new MessageData[]{new MessageData("recipe", (Object)recipe)});
            return false;
        }
        if (recipe.getConditions().getMoneyCost() != 0.0 && CodexEngine.get().getVault() != null && !CodexEngine.get().getVault().canPay((OfflinePlayer)this.player, recipe.getConditions().getMoneyCost())) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.error.noFunds", (CommandSender)this.player, new MessageData[]{new MessageData("recipe", (Object)recipe)});
            return false;
        }
        return true;
    }

    private boolean craft(int slot, boolean addToCursor) {
        ItemStack cursor;
        if (!this.recipes.containsKey(slot)) {
            return false;
        }
        CalculatedRecipe calculatedRecipe = this.recipes.get(slot);
        Recipe recipe = calculatedRecipe.getRecipe();
        if (this.craftingRecipe != null && this.craftingRecipe.equals(recipe)) {
            this.cancel(true);
            return false;
        }
        this.cancel(true);
        if (!this.canCraft(calculatedRecipe, slot)) {
            return false;
        }
        RecipeItem recipeResult = recipe.getSettings().getRecipeItem();
        ItemStack resultItem = recipeResult.getItemStack();
        if (this.player.hasPermission("fusion.craftedby." + recipe.getName())) {
            ItemMeta meta = resultItem.getItemMeta();
            ArrayList<CallSite> lore = meta != null && meta.hasLore() ? meta.getLore() : new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.WHITE) + " - " + String.valueOf(ChatColor.YELLOW) + "Crafted by: " + String.valueOf(ChatColor.WHITE) + this.player.getName())));
            meta.setLore(lore);
            resultItem.setItemMeta(meta);
        }
        if (addToCursor && (resultItem.isSimilar(cursor = this.player.getItemOnCursor()) ? resultItem.getAmount() + cursor.getAmount() > resultItem.getMaxStackSize() : cursor.getType() != Material.AIR)) {
            return false;
        }
        ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>(recipe.getItemsToTake());
        ArrayList<ItemStack> removedSoFar = new ArrayList<ItemStack>();
        PlayerInventory inv = this.player.getInventory();
        boolean missingSomething = false;
        for (ItemStack required : requiredItems) {
            int need = required.getAmount();
            IngredientFingerprint neededFingerprint = IngredientFingerprint.of(required);
            for (int slotIndex = 0; slotIndex < inv.getSize() && need > 0; ++slotIndex) {
                IngredientFingerprint slotFingerprint;
                ItemStack slotStack = inv.getItem(slotIndex);
                if (slotStack == null || slotStack.getType() == Material.AIR || !neededFingerprint.equals(slotFingerprint = IngredientFingerprint.of(slotStack))) continue;
                int available = slotStack.getAmount();
                int take = Math.min(available, need);
                slotStack.setAmount(available - take);
                if (slotStack.getAmount() <= 0) {
                    inv.setItem(slotIndex, null);
                } else {
                    inv.setItem(slotIndex, slotStack);
                }
                ItemStack actuallyTaken = required.clone();
                actuallyTaken.setAmount(take);
                removedSoFar.add(actuallyTaken);
                need -= take;
            }
            if (need <= 0) continue;
            missingSomething = true;
            for (ItemStack alreadyRemoved : removedSoFar) {
                HashMap overflow = inv.addItem(new ItemStack[]{alreadyRemoved.clone()});
                for (ItemStack drop : overflow.values()) {
                    this.player.getWorld().dropItemNaturally(this.player.getLocation(), drop);
                }
            }
        }
        if (missingSomething) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.error.insufficientItems", (CommandSender)this.player, new MessageData[]{new MessageData("recipe", (Object)recipe)});
            this.cancel(true);
            return false;
        }
        this.refund.addAll(removedSoFar);
        if (!Cfg.craftingQueue) {
            double modifier = Fusion.getInstance().getPlayerCooldown(this.player);
            int cooldown = modifier == 0.0 ? recipe.getCraftingTime() : (int)Math.round((double)recipe.getCraftingTime() - (double)recipe.getCraftingTime() * modifier);
            this.showBossBar(this.player, recipe.getSettings().getRecipeItem().getItemStack(), cooldown);
            if (cooldown != 0) {
                this.previousCursor = this.player.getOpenInventory().getCursor();
                this.player.getOpenInventory().setCursor(new ItemStack(Material.BARRIER));
            }
            this.craftingSuccess = false;
            this.craftingRecipe = recipe;
            this.craftingTask = Fusion.getInstance().runTaskLater(cooldown, () -> {
                this.craftingSuccess = true;
                if (recipe.getResults().getCommands().isEmpty()) {
                    if (addToCursor) {
                        ItemStack cursor = this.player.getItemOnCursor();
                        if (cursor.isSimilar(recipe.getSettings().getRecipeItem().getItemStack())) {
                            if (cursor.getAmount() < cursor.getMaxStackSize() && cursor.getAmount() + recipe.getSettings().getRecipeItem().getAmount() <= cursor.getMaxStackSize()) {
                                cursor.setAmount(cursor.getAmount() + recipe.getSettings().getRecipeItem().getAmount());
                                this.player.setItemOnCursor(cursor);
                            } else {
                                this.craftingSuccess = false;
                            }
                        } else if (cursor.getType() == Material.AIR) {
                            this.player.setItemOnCursor(resultItem);
                        } else {
                            this.craftingSuccess = false;
                        }
                    } else {
                        boolean fits = this.calcWillFit(resultItem);
                        if (fits) {
                            HashMap notAdded = inv.addItem(new ItemStack[]{resultItem});
                            if (!notAdded.isEmpty()) {
                                for (ItemStack stack : notAdded.values()) {
                                    this.player.getWorld().dropItemNaturally(this.player.getLocation(), stack);
                                }
                            }
                        } else {
                            this.craftingSuccess = false;
                        }
                    }
                }
                if (this.craftingSuccess) {
                    this.cancel(false);
                    CodexEngine.get().getVault().take((OfflinePlayer)this.player, recipe.getConditions().getMoneyCost());
                    DelayedCommand.invoke((Plugin)Fusion.getInstance(), (CommandSender)this.player, recipe.getResults().getCommands(), (Replacer[])new Replacer[0]);
                    long professionExp = recipe.getResults().getProfessionExp() + (long)((double)recipe.getResults().getProfessionExp() * PlayerUtil.getProfessionExpBonusThroughPermissions(this.player, this.table.getName()));
                    if (professionExp > 0L) {
                        FusionAPI.getEventServices().getProfessionService().giveProfessionExp(this.player, this.table, professionExp);
                    }
                    if (recipe.getResults().getVanillaExp() > 0) {
                        this.player.giveExp(recipe.getResults().getVanillaExp());
                    }
                    if (PlayerLoader.getPlayer(this.player).isAutoCrafting() && !this.recipes.isEmpty()) {
                        this.reloadRecipesTask();
                        boolean success = this.craft(slot, addToCursor);
                        if (!success) {
                            CodexEngine.get().getMessageUtil().sendMessage("fusion.autoCancelled", (CommandSender)this.player, new MessageData[0]);
                        }
                    }
                } else {
                    this.cancel(true);
                }
            });
        } else {
            if (recipe.getConditions().getMoneyCost() != 0.0 && CodexEngine.get().getVault() != null) {
                CodexEngine.get().getVault().take((OfflinePlayer)this.player, recipe.getConditions().getMoneyCost());
            }
            this.queue.addRecipe(this.recipes.get(slot).getRecipe());
        }
        return true;
    }

    private boolean calcWillFit(ItemStack item) {
        Inventory inv = Bukkit.createInventory(null, (InventoryType)InventoryType.PLAYER);
        inv.setContents(this.inventory.getContents());
        return inv.addItem(new ItemStack[]{item}).isEmpty();
    }

    public void executeCommands(Character c, HumanEntity player) {
        List<DelayedCommand> patternCommands = this.getPattern().getCommands(c.charValue());
        if (patternCommands != null && !patternCommands.isEmpty()) {
            DelayedCommand.invoke((Plugin)Fusion.getInstance(), (CommandSender)player, patternCommands, (Replacer[])new Replacer[]{Replacer.replacer((String)"{crafting}", (String)this.getName()), Replacer.replacer((String)"{inventoryName}", (String)this.getInventoryName())});
        }
    }

    private void showBossBar(Player target, ItemStack item, final double cooldown) {
        if (cooldown == 0.0) {
            return;
        }
        this.bar = Bukkit.createBossBar((String)CraftingRequirementsCfg.getBossBarTitle(item), (BarColor)BarColor.BLUE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[]{BarFlag.PLAY_BOSS_MUSIC});
        this.bar.setProgress(0.0);
        this.bar.addPlayer(target);
        this.barTask = new BukkitRunnable(this){
            int count = 0;
            final /* synthetic */ RecipeGui this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if ((double)this.count >= cooldown * 20.0) {
                    this.cancel();
                    this.this$0.bar.removeAll();
                }
                this.this$0.bar.setProgress(Math.min(1.0, (double)this.count / (cooldown * 20.0)));
                ++this.count;
            }
        }.runTaskTimer((Plugin)Fusion.getInstance(), 1L, 1L);
    }

    private void cancel(boolean refundAll) {
        if (!Cfg.craftingQueue) {
            if (this.craftingTask == null) {
                return;
            }
            this.craftingRecipe = null;
            if (this.barTask != null) {
                this.barTask.cancel();
                this.barTask = null;
                this.bar.removeAll();
                this.bar = null;
            }
            if (!this.craftingSuccess && PlayerLoader.getPlayer(this.player).isAutoCrafting()) {
                CodexEngine.get().getMessageUtil().sendMessage("fusion.autoCancelled", (CommandSender)this.player, new MessageData[0]);
            }
            if (this.player.getOpenInventory().getCursor() != null && this.player.getOpenInventory().getCursor().getType() == Material.BARRIER) {
                if (this.previousCursor != null) {
                    this.player.getOpenInventory().setCursor(this.previousCursor);
                    this.previousCursor = null;
                } else {
                    this.player.getOpenInventory().setCursor(new ItemStack(Material.AIR));
                }
            }
            if (this.craftingTask != null) {
                this.craftingTask.cancel();
            }
            this.craftingTask = null;
            if (!refundAll || this.craftingSuccess) {
                return;
            }
            PlayerInventory inventory = this.player.getInventory();
            Collection notAdded = inventory.addItem(this.refund.toArray(new ItemStack[0])).values();
            if (!notAdded.isEmpty()) {
                for (ItemStack item : notAdded) {
                    this.player.getLocation().getWorld().dropItem(this.player.getLocation(), item);
                }
            }
            this.refund.clear();
        }
    }

    public void click(InventoryClickEvent event) {
        event.setCancelled(true);
        if (event.getRawSlot() >= this.slots.length) {
            if (event.getCursor().getType() == Material.BARRIER) {
                event.setCancelled(true);
            }
            return;
        }
        if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
            return;
        }
        Character c = this.pattern.getSlot(event.getRawSlot());
        this.executeCommands(c, event.getWhoClicked());
        if (this.pattern.getCloseOnClickSlots().contains(c)) {
            Bukkit.getScheduler().runTask((Plugin)Fusion.getInstance(), () -> event.getWhoClicked().closeInventory());
        }
        if (this.slots[event.getRawSlot()].equals(Slot.BLOCKED_SLOT)) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
            if (this.nextPage != -1 && event.getSlot() == this.nextPage) {
                this.nextPage();
                return;
            }
            if (this.prevPage != -1 && event.getSlot() == this.prevPage) {
                this.prevPage();
                return;
            }
            if (this.nextQueuePage != -1 && event.getSlot() == this.nextQueuePage) {
                this.nextQueuePage();
                return;
            }
            if (this.prevQueuePage != -1 && event.getSlot() == this.prevQueuePage) {
                this.prevQueuePage();
            }
            return;
        }
        if (this.slots[event.getRawSlot()].equals(Slot.BASE_RESULT_SLOT)) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
            Fusion.getInstance().runSync(() -> {
                this.reloadRecipes();
                this.craft(event.getRawSlot(), false);
                this.reloadRecipesTask();
            });
            return;
        }
        if (this.slots[event.getRawSlot()].equals(Slot.QUEUED_SLOT)) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
            if (this.queuedSlots.contains(event.getSlot())) {
                QueueItem item = this.queue.getQueuedItems().get(event.getSlot());
                if (item == null) {
                    return;
                }
                if (item.isDone()) {
                    if (event.isLeftClick()) {
                        this.queue.finishRecipe(item);
                        this.reloadRecipes();
                    } else if (event.isRightClick()) {
                        int queueSize = this.queue.getQueue().size();
                        this.queue.finishAllRecipes();
                        Bukkit.getScheduler().runTaskLater((Plugin)Fusion.getInstance(), this::reloadRecipes, (long)(queueSize + 1));
                    }
                } else {
                    this.queue.removeRecipe(item, true);
                }
            }
            return;
        }
        if (event.getCursor().getType() != Material.AIR && Slot.SPECIAL_CRAFTING_SLOT.canHoldItem(event.getCursor()) == null) {
            event.setResult(Event.Result.DENY);
            return;
        }
        this.reloadRecipesTask();
    }

    public void close(Player p, Inventory inv) {
        if (inv == null) {
            return;
        }
        PlayerInventory pInventory = p.getInventory();
        if (inv.equals((Object)this.inventory)) {
            for (int i = 0; i < this.slots.length; ++i) {
                ItemStack it;
                if (this.slots[i].equals(Slot.BLOCKED_SLOT) || this.slots[i].equals(Slot.BASE_RESULT_SLOT) || this.slots[i].equals(Slot.QUEUED_SLOT) || (it = inv.getItem(i)) == null) continue;
                pInventory.addItem(new ItemStack[]{it}).values().stream().filter(Objects::nonNull).forEach(itemStack -> p.getWorld().dropItem(p.getLocation(), itemStack));
            }
            this.cancel(true);
            inv.clear();
        }
    }

    public void onDrag(InventoryDragEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        if (e.getInventory().equals((Object)this.inventory) && !Cfg.craftingQueue) {
            if (e.getOldCursor().getType() == Material.BARRIER) {
                e.setCancelled(true);
            }
            if (e.getRawSlots().stream().anyMatch(i -> i < this.slots.length && !Objects.equals(this.slots[i], Slot.SPECIAL_CRAFTING_SLOT))) {
                e.setResult(Event.Result.DENY);
                return;
            }
            if (e.getNewItems().values().stream().anyMatch(i -> Slot.SPECIAL_CRAFTING_SLOT.canHoldItem((ItemStack)i) == null)) {
                e.setResult(Event.Result.DENY);
            }
            this.reloadRecipesTask();
        }
    }

    public void drop(PlayerDropItemEvent event) {
        ItemStack stack;
        Player player = event.getPlayer();
        if (this.getInventory().getViewers().contains(player) && !Cfg.craftingQueue && (stack = event.getItemDrop().getItemStack()).getType() == Material.BARRIER) {
            event.getItemDrop().remove();
            if (player.getOpenInventory().getCursor() == null || player.getOpenInventory().getCursor().getType() == Material.AIR) {
                player.getOpenInventory().setCursor(stack);
            }
            this.cancel(true);
        }
    }

    public static void resetRecipeHashes() {
        recipeCache.clear();
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public CraftingTable getTable() {
        return this.table;
    }

    @Generated
    public Category getCategory() {
        return this.category;
    }

    @Generated
    public InventoryPattern getPattern() {
        return this.pattern;
    }

    @Generated
    public HashMap<Integer, CalculatedRecipe> getRecipes() {
        return this.recipes;
    }

    @Generated
    public int getPage() {
        return this.page;
    }

    @Generated
    public int getNextPage() {
        return this.nextPage;
    }

    @Generated
    public int getPrevPage() {
        return this.prevPage;
    }

    @Generated
    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Generated
    public int getQueuePage() {
        return this.queuePage;
    }

    @Generated
    public int getPrevQueuePage() {
        return this.prevQueuePage;
    }

    @Generated
    public int getNextQueuePage() {
        return this.nextQueuePage;
    }

    @Generated
    public CraftingQueue getQueue() {
        return this.queue;
    }

    @Generated
    public int getLastQueueSecond() {
        return this.lastQueueSecond;
    }

    @Generated
    public int getLastQueueSize() {
        return this.lastQueueSize;
    }

    @Generated
    public BukkitTask getCraftingTask() {
        return this.craftingTask;
    }

    @Generated
    public BukkitTask getBarTask() {
        return this.barTask;
    }

    @Generated
    public BossBar getBar() {
        return this.bar;
    }

    @Generated
    public Collection<ItemStack> getRefund() {
        return this.refund;
    }

    @Generated
    public ItemStack getPreviousCursor() {
        return this.previousCursor;
    }

    @Generated
    public boolean isCraftingSuccess() {
        return this.craftingSuccess;
    }

    @Generated
    public Recipe getCraftingRecipe() {
        return this.craftingRecipe;
    }

    @Generated
    public Slot[] getSlots() {
        return this.slots;
    }

    @Generated
    public ArrayList<Integer> getResultSlots() {
        return this.resultSlots;
    }

    @Generated
    public ArrayList<Integer> getBlockedSlots() {
        return this.blockedSlots;
    }

    @Generated
    public ArrayList<Integer> getQueuedSlots() {
        return this.queuedSlots;
    }

    @Generated
    public byte[] getLastInventoryHash() {
        return this.lastInventoryHash;
    }

    @Generated
    public int getLastSeenLevel() {
        return this.lastSeenLevel;
    }

    @Generated
    public double getLastSeenMoney() {
        return this.lastSeenMoney;
    }

    @Generated
    public int getLastPageCount() {
        return this.lastPageCount;
    }

    @Generated
    public int getLastQueuePageCount() {
        return this.lastQueuePageCount;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getInventoryName() {
        return this.inventoryName;
    }

    @Generated
    public Inventory getInventory() {
        return this.inventory;
    }

    @Generated
    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }
}

