/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.data.professions.pattern.Category;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.gui.CategoryGui;
import studio.magemonkey.fusion.gui.RecipeGui;

public class ProfessionGuiRegistry {
    private final String profession;
    private final Map<UUID, CategoryGui> categoryGuis = new TreeMap<UUID, CategoryGui>();
    private final Map<UUID, RecipeGui> recipeGuis = new TreeMap<UUID, RecipeGui>();
    public static final Map<UUID, RecipeGui> latestRecipeGui = new TreeMap<UUID, RecipeGui>();

    public ProfessionGuiRegistry(String profession) {
        this.profession = profession;
    }

    public void open(Player player) {
        CraftingTable table = ProfessionsCfg.getTable(this.profession);
        if (table.getUseCategories() && !table.getCategories().isEmpty()) {
            this.categoryGuis.put(player.getUniqueId(), new CategoryGui(player, table));
            this.categoryGuis.get(player.getUniqueId()).open(player);
        } else {
            RecipeGui gui = new RecipeGui(player, table, new Category("master", "PAPER", table.getRecipePattern(), 1));
            this.recipeGuis.put(player.getUniqueId(), gui);
            this.recipeGuis.get(player.getUniqueId()).open(player);
        }
    }

    public void open(Player player, Category category) {
        CraftingTable table = ProfessionsCfg.getTable(this.profession);
        if (table.getUseCategories() && !table.getCategories().isEmpty()) {
            if (table.getCategories().containsKey(category.getName())) {
                this.categoryGuis.put(player.getUniqueId(), new CategoryGui(player, table));
                this.categoryGuis.get(player.getUniqueId()).open(player, category);
            } else {
                CodexEngine.get().getMessageUtil().sendMessage("fusion.error.categoryNotAvailable", (CommandSender)player, new MessageData[]{new MessageData("sender", (Object)player.getPlayer())});
            }
        } else {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.error.noCategories", (CommandSender)player, new MessageData[]{new MessageData("sender", (Object)player.getPlayer())});
        }
    }

    public void closeAll() {
        ArrayList toClose = new ArrayList();
        for (CategoryGui categoryGui : new ArrayList<CategoryGui>(this.categoryGuis.values())) {
            categoryGui.getInventory().getViewers().forEach(HumanEntity::closeInventory);
            for (RecipeGui recipeGui : categoryGui.getCategories().values()) {
                toClose.addAll(recipeGui.getInventory().getViewers());
            }
        }
        for (RecipeGui recipeGui : new ArrayList<RecipeGui>(this.recipeGuis.values())) {
            toClose.addAll(recipeGui.getInventory().getViewers());
        }
        toClose.forEach(HumanEntity::closeInventory);
    }

    public static void clearLatestRecipeGui() {
        latestRecipeGui.clear();
    }

    @Generated
    public String getProfession() {
        return this.profession;
    }

    @Generated
    public static Map<UUID, RecipeGui> getLatestRecipeGui() {
        return latestRecipeGui;
    }
}

