/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.DelayedCommand;
import studio.magemonkey.codex.api.Replacer;
import studio.magemonkey.codex.util.ItemUtils;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.data.professions.pattern.Category;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.gui.RecipeGui;
import studio.magemonkey.fusion.gui.slot.Slot;
import studio.magemonkey.fusion.util.ChatUT;

public class CategoryGui
implements Listener {
    private final Player player;
    private final CraftingTable table;
    private Inventory inventory;
    private final Map<String, RecipeGui> allCategoriesMap = new HashMap<String, RecipeGui>();
    private final Map<Integer, RecipeGui> categories = new HashMap<Integer, RecipeGui>();
    private int page = 0;
    private int nextPage = -1;
    private int prevPage = -1;
    private Slot[] slots;
    private final ArrayList<Integer> resultSlots = new ArrayList(20);
    private final ArrayList<Integer> blockedSlots = new ArrayList(20);

    public CategoryGui(Player player, CraftingTable table) {
        this.player = player;
        this.table = table;
        this.initialize();
        Fusion.registerListener(this);
    }

    public void initialize() {
        this.categories.clear();
        this.resultSlots.clear();
        this.inventory = Bukkit.createInventory(null, (int)this.table.getCatPattern().getInventorySize(), (String)ChatUT.hexString(this.table.getInventoryName()));
        this.mapSlots();
        this.reloadCategories();
    }

    public void reloadCategories() {
        if (!this.player.isOnline()) {
            return;
        }
        try {
            int k;
            int slot;
            Integer[] slots;
            int pages;
            ItemStack fill = this.table.getFillItem();
            ArrayList<Category> allCategories = new ArrayList<Category>(this.table.getCategories().values());
            int pageSize = this.resultSlots.size();
            int allCategoryCount = allCategories.size();
            int i = 0;
            int page = this.page;
            int fullPages = allCategoryCount / pageSize;
            int rest = allCategoryCount % pageSize;
            int n = pages = rest == 0 ? fullPages : fullPages + 1;
            if (this.player.isOnline() && page >= pages) {
                if (page > 0) {
                    this.page = pages - 1;
                }
                if (this.page != page) {
                    this.reloadCategories();
                }
                return;
            }
            Category[] allCategoryArray = allCategories.toArray(new Category[allCategoryCount]);
            Integer[] integerArray = slots = this.resultSlots.toArray(new Integer[0]);
            int n2 = integerArray.length;
            for (int j = 0; j < n2; ++j) {
                slot = integerArray[j];
                this.inventory.setItem(slot, null);
            }
            this.updateBlockedSlots(new MessageData[]{new MessageData("level", (Object)this.table.getLevelFunction().getLevel((OfflinePlayer)this.player)), new MessageData("gui", (Object)this.table.getName()), new MessageData("player", (Object)this.player.getName()), new MessageData("bal", (Object)(CodexEngine.get().getVault() == null ? 0.0 : CodexEngine.get().getVault().getBalance((OfflinePlayer)this.player)))});
            allCategories.forEach(category -> this.allCategoriesMap.putIfAbsent(category.getName(), new RecipeGui(this.player, this.table, (Category)category)));
            int e = Math.min(slots.length, allCategoryArray.length);
            for (k = page * pageSize; k < allCategoryArray.length && i < e; ++k, ++i) {
                Category category2 = allCategoryArray[k];
                slot = slots[i];
                this.categories.put(slot, new RecipeGui(this.player, this.table, category2));
                this.inventory.setItem(slot, category2.getDisplayIcon());
            }
            for (k = 0; k < this.inventory.getSize(); ++k) {
                if (this.inventory.getItem(k) != null && this.inventory.getItem(k).getType() != Material.AIR) continue;
                this.inventory.setItem(k, fill);
            }
        }
        catch (Exception e) {
            this.inventory.clear();
            this.player.closeInventory();
            throw new RuntimeException("Exception was thrown when reloading categories for: " + this.player.getName(), e);
        }
    }

    public void reloadCategoriesTask() {
        Bukkit.getScheduler().runTaskLater((Plugin)Fusion.getInstance(), this::reloadCategories, 1L);
    }

    public void updateBlockedSlots(MessageData[] data) {
        int totalItems = this.table.getCategories().size();
        int fullPages = totalItems / this.resultSlots.size();
        int rest = totalItems % this.resultSlots.size();
        int pages = rest == 0 ? fullPages : fullPages + 1;
        boolean includeBack = false;
        int k = -1;
        HashMap<Character, ItemStack> items = this.table.getCatPattern().getItems();
        ArrayList<Integer> leaveBlank = new ArrayList<Integer>();
        ArrayList<Integer> fill = new ArrayList<Integer>();
        for (String row : this.table.getCatPattern().getPattern()) {
            for (char c : row.toCharArray()) {
                ++k;
                ItemStack item = ItemUtils.replaceText((ItemStack)items.get(Character.valueOf(c)), (MessageData[])data);
                if (!includeBack && c == '<' && this.page <= 0) {
                    leaveBlank.add(k);
                    continue;
                }
                if (c == '>' && this.page + 1 >= pages) {
                    leaveBlank.add(k);
                    continue;
                }
                if (c == '{' || c == '}' || c == '-') {
                    fill.add(k);
                    continue;
                }
                if (item == null) continue;
                this.inventory.setItem(k, item.clone());
            }
        }
        for (Integer index : leaveBlank) {
            if (this.inventory.getSize() > index + 1) {
                this.inventory.setItem(index.intValue(), this.inventory.getItem(index + 1));
                continue;
            }
            this.inventory.setItem(index.intValue(), this.inventory.getItem(index - 1));
        }
        for (Integer index : fill) {
            this.inventory.setItem(index.intValue(), ProfessionsCfg.getFillItem(this.table.getName()));
        }
    }

    private void mapSlots() {
        this.resultSlots.clear();
        this.slots = new Slot[this.table.getCatPattern().getPattern().length * 9];
        int k = -1;
        int prevPage = -1;
        int nextPage = -1;
        for (String row : this.table.getCatPattern().getPattern()) {
            block7: for (char c : row.toCharArray()) {
                ++k;
                switch (c) {
                    case '=': 
                    case 'o': {
                        this.slots[k] = Slot.BASE_RESULT_SLOT;
                        this.resultSlots.add(k);
                        continue block7;
                    }
                    case '>': {
                        this.slots[k] = Slot.BLOCKED_SLOT;
                        nextPage = k;
                        continue block7;
                    }
                    case '<': {
                        this.slots[k] = Slot.BLOCKED_SLOT;
                        prevPage = k;
                        continue block7;
                    }
                    case '-': 
                    case '{': 
                    case '}': {
                        continue block7;
                    }
                    default: {
                        this.slots[k] = Slot.BLOCKED_SLOT;
                        this.blockedSlots.add(k);
                    }
                }
            }
        }
        this.nextPage = nextPage;
        this.prevPage = prevPage;
    }

    private boolean validatePageCount() {
        int pages;
        if (this.page <= 0) {
            this.reloadCategoriesTask();
            return false;
        }
        Collection<Category> allCategories = this.table.getCategories().values();
        int pageSize = this.resultSlots.size();
        int fullCount = allCategories.size();
        int page = this.page;
        int fullPages = fullCount / pageSize;
        int rest = fullCount % pageSize;
        int n = pages = rest == 0 ? fullPages : fullPages + 1;
        if (page >= pages) {
            this.page = pages;
            this.reloadCategoriesTask();
            return false;
        }
        return true;
    }

    private void prevPage() {
        if (this.page <= 0) {
            this.player.closeInventory();
            return;
        }
        --this.page;
        if (this.validatePageCount()) {
            Bukkit.getConsoleSender().sendMessage("[-] Validated: " + this.page);
            this.reloadCategoriesTask();
        }
    }

    private void nextPage() {
        ++this.page;
        if (this.validatePageCount()) {
            Bukkit.getConsoleSender().sendMessage("[+] Validated: " + this.page);
            this.reloadCategoriesTask();
        }
    }

    public void open(Player player, Category category) {
        if (category == null) {
            this.open(player);
        } else {
            for (RecipeGui gui : this.allCategoriesMap.values()) {
                if (!gui.getCategory().equals(category)) continue;
                gui.open(player);
                return;
            }
        }
    }

    public void open(Player player) {
        player.openInventory(this.inventory);
    }

    public void executeCommands(Character c, HumanEntity player) {
        List<DelayedCommand> patternCommands = this.table.getCatPattern().getCommands(c.charValue());
        if (patternCommands != null && !patternCommands.isEmpty()) {
            DelayedCommand.invoke((Plugin)Fusion.getInstance(), (CommandSender)player, patternCommands, (Replacer[])new Replacer[]{Replacer.replacer((String)"{crafting}", (String)this.table.getName()), Replacer.replacer((String)"{inventoryName}", (String)this.table.getInventoryName())});
        }
    }

    public void click(InventoryClickEvent event) {
        event.setCancelled(true);
        if (event.getRawSlot() >= this.slots.length) {
            if (event.getCursor().getType() == Material.BARRIER) {
                event.setCancelled(true);
            }
            return;
        }
        if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
            return;
        }
        Character c = this.table.getCatPattern().getSlot(event.getRawSlot());
        this.executeCommands(c, event.getWhoClicked());
        if (this.table.getCatPattern().getCloseOnClickSlots().contains(c)) {
            Bukkit.getScheduler().runTask((Plugin)Fusion.getInstance(), () -> event.getWhoClicked().closeInventory());
        }
        if (this.slots[event.getRawSlot()].equals(Slot.BLOCKED_SLOT)) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
            if (this.nextPage != -1 && event.getSlot() == this.nextPage) {
                this.nextPage();
                return;
            }
            if (this.prevPage != -1 && event.getSlot() == this.prevPage) {
                this.prevPage();
                return;
            }
            return;
        }
        if (this.slots[event.getRawSlot()].equals(Slot.BASE_RESULT_SLOT)) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
            Fusion.getInstance().runSync(() -> this.categories.get(event.getRawSlot()).open((Player)event.getWhoClicked()));
            return;
        }
        this.reloadCategoriesTask();
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        if (event.getInventory() != this.getInventory()) {
            return;
        }
        event.setCancelled(true);
        event.setResult(Event.Result.DENY);
        Player player = (Player)event.getWhoClicked();
        int slot = event.getSlot();
        if (slot < 0) {
            return;
        }
        Character c = this.table.getCatPattern().getSlot(slot);
        this.executeCommands(c, event.getWhoClicked());
        if (this.table.getCatPattern().getCloseOnClickSlots().contains(c)) {
            Bukkit.getScheduler().runTask((Plugin)Fusion.getInstance(), () -> event.getWhoClicked().closeInventory());
        }
        if (this.nextPage != -1 && event.getSlot() == this.nextPage) {
            this.nextPage();
            return;
        }
        if (this.prevPage != -1 && event.getSlot() == this.prevPage) {
            this.prevPage();
            return;
        }
        if (this.categories.containsKey(slot)) {
            this.categories.get(slot).open(player);
        }
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public CraftingTable getTable() {
        return this.table;
    }

    @Generated
    public Inventory getInventory() {
        return this.inventory;
    }

    @Generated
    public Map<String, RecipeGui> getAllCategoriesMap() {
        return this.allCategoriesMap;
    }

    @Generated
    public Map<Integer, RecipeGui> getCategories() {
        return this.categories;
    }

    @Generated
    public int getPage() {
        return this.page;
    }

    @Generated
    public int getNextPage() {
        return this.nextPage;
    }

    @Generated
    public int getPrevPage() {
        return this.prevPage;
    }

    @Generated
    public Slot[] getSlots() {
        return this.slots;
    }

    @Generated
    public ArrayList<Integer> getResultSlots() {
        return this.resultSlots;
    }

    @Generated
    public ArrayList<Integer> getBlockedSlots() {
        return this.blockedSlots;
    }
}

