/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.data.recipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.CraftingRequirementsCfg;
import studio.magemonkey.fusion.data.player.PlayerLoader;
import studio.magemonkey.fusion.data.player.PlayerRecipeLimit;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.data.recipes.Recipe;
import studio.magemonkey.fusion.data.recipes.RecipeItem;
import studio.magemonkey.fusion.gui.recipe.IngredientFingerprint;
import studio.magemonkey.fusion.util.ExperienceManager;
import studio.magemonkey.fusion.util.InvalidPatternItemException;
import studio.magemonkey.fusion.util.Utils;

public class CalculatedRecipe {
    private final Recipe recipe;
    private final ItemStack icon;
    private final boolean canCraft;

    public CalculatedRecipe(Recipe recipe, ItemStack icon, boolean canCraft) {
        this.recipe = recipe;
        this.icon = icon;
        this.canCraft = canCraft;
    }

    public static CalculatedRecipe create(Recipe recipe, Map<IngredientFingerprint, Integer> invCounts, Player player, CraftingTable craftingTable) throws InvalidPatternItemException {
        try {
            StringBuilder lore = new StringBuilder(512);
            ItemStack iconResult = recipe.getSettings().getRecipeItem().getItemStack();
            ItemMeta baseMeta = iconResult.getItemMeta();
            List resultLore = baseMeta == null ? Collections.emptyList() : baseMeta.getLore();
            String requirementLine = CraftingRequirementsCfg.getCraftingRequirementLine("recipes");
            if (!requirementLine.isEmpty()) {
                lore.append(requirementLine).append('\n');
            }
            boolean canCraft = true;
            String recipePermissionLine = null;
            if (!Utils.hasCraftingPermission((Permissible)player, recipe.getName())) {
                canCraft = false;
            }
            recipePermissionLine = CraftingRequirementsCfg.getLearned("recipes", Utils.hasCraftingPermission((Permissible)player, recipe.getName()));
            String moneyLine = null;
            if (recipe.getConditions().getMoneyCost() != 0.0) {
                if (CodexEngine.get().getVault() == null || !CodexEngine.get().getVault().canPay((OfflinePlayer)player, recipe.getConditions().getMoneyCost())) {
                    canCraft = false;
                }
                double balance = CodexEngine.get().getVault() == null ? 0.0 : CodexEngine.get().getVault().getBalance((OfflinePlayer)player);
                moneyLine = CraftingRequirementsCfg.getMoney("recipes", (int)balance, recipe.getConditions().getMoneyCost());
            }
            String expLine = null;
            if (recipe.getConditions().getExpCost() != 0) {
                int totalExp = ExperienceManager.getTotalExperience(player);
                if (totalExp < recipe.getConditions().getExpCost()) {
                    canCraft = false;
                }
                expLine = CraftingRequirementsCfg.getExp("recipes", totalExp, recipe.getConditions().getExpCost());
            }
            String levelsLine = null;
            if (recipe.getConditions().getProfessionLevel() != 0) {
                int profLevel = recipe.getTable().getLevelFunction().getLevel((OfflinePlayer)player);
                if (profLevel < recipe.getConditions().getProfessionLevel()) {
                    canCraft = false;
                }
                levelsLine = CraftingRequirementsCfg.getProfessionLevel("recipes", profLevel, recipe.getConditions().getProfessionLevel());
            }
            String masteryLine = null;
            if (recipe.getConditions().isMastery()) {
                boolean hasMastery = PlayerLoader.getPlayer(player).hasMastered(craftingTable.getName());
                if (!hasMastery) {
                    canCraft = false;
                }
                masteryLine = CraftingRequirementsCfg.getMastery("recipes", hasMastery, recipe.getConditions().isMastery());
            }
            String limitLine = null;
            if (recipe.getCraftingLimit() > 0) {
                PlayerRecipeLimit limit = PlayerLoader.getPlayer(player).getRecipeLimit(recipe);
                if (limit.getLimit() > 0 && limit.getCooldownTimestamp() > 0L && !limit.hasCooldown()) {
                    limit.resetLimit();
                    Bukkit.getConsoleSender().sendMessage("\u00a7aResetting limit for " + player.getName() + " on " + recipe.getRecipePath());
                }
                if (limit.getLimit() >= recipe.getCraftingLimit()) {
                    canCraft = false;
                }
                limitLine = CraftingRequirementsCfg.getLimit("recipes", limit.getLimit(), recipe.getCraftingLimit());
            }
            List<Map.Entry<Boolean, String>> conditionLines = recipe.getConditions().getConditionLines(player);
            for (Map.Entry<Boolean, String> entry : conditionLines) {
                if (entry.getKey().booleanValue()) continue;
                canCraft = false;
                break;
            }
            LinkedHashSet<RecipeItem> localPattern = new LinkedHashSet<RecipeItem>(recipe.getConditions().getRequiredItems());
            for (RecipeItem required : localPattern) {
                ItemStack single = required.getItemStack().clone();
                single.setAmount(1);
                IngredientFingerprint ingredientFingerprint = IngredientFingerprint.of(single);
                int have = invCounts.getOrDefault(ingredientFingerprint, 0);
                int need = required.getAmount();
                if (have < need) {
                    canCraft = false;
                    lore.append(CraftingRequirementsCfg.getIngredientLine("recipes", required, have, need)).append('\n');
                    continue;
                }
                invCounts.put(ingredientFingerprint, have - need);
                lore.append(CraftingRequirementsCfg.getIngredientLine("recipes", required, have, need)).append('\n');
            }
            String canCraftLine = CraftingRequirementsCfg.getCanCraft(canCraft);
            lore.append('\n');
            if (moneyLine != null) {
                lore.append(moneyLine).append('\n');
            }
            if (levelsLine != null) {
                lore.append(levelsLine).append('\n');
            }
            if (expLine != null) {
                lore.append(expLine).append('\n');
            }
            if (masteryLine != null) {
                lore.append(masteryLine).append('\n');
            }
            if (limitLine != null) {
                lore.append(limitLine).append('\n');
            }
            if (!conditionLines.isEmpty()) {
                String conditionLine = CraftingRequirementsCfg.getCraftingConditionLine("recipes");
                if (!conditionLine.isEmpty()) {
                    lore.append(conditionLine).append('\n');
                }
                for (Map.Entry entry : conditionLines) {
                    lore.append('\n').append((String)entry.getValue());
                }
            }
            lore.append('\n').append(recipePermissionLine);
            lore.append('\n').append(canCraftLine);
            ItemStack icon = iconResult.clone();
            ItemMeta im = icon.getItemMeta();
            im.setLore(Arrays.asList(StringUtils.split((String)lore.toString(), (char)'\n')));
            icon.setItemMeta(im);
            return new CalculatedRecipe(recipe, icon, canCraft);
        }
        catch (Exception e) {
            Fusion.getInstance().error("Error creating CalculatedRecipe for '" + recipe.getName() + "': " + e.getMessage());
            throw new InvalidPatternItemException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CalculatedRecipe)) {
            return false;
        }
        CalculatedRecipe that = (CalculatedRecipe)o;
        return new EqualsBuilder().append((Object)this.recipe, (Object)that.recipe).append((Object)this.icon, (Object)that.icon).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.recipe).append((Object)this.icon).toHashCode();
    }

    public static boolean isSimilar(ItemStack is1, ItemStack is2) {
        if (is1.getType() != is2.getType()) {
            return false;
        }
        ItemMeta im1 = is1.getItemMeta();
        ItemMeta im2 = is2.getItemMeta();
        if (im1 == null && im2 != null || im1 != null && im2 == null) {
            return false;
        }
        if (im1 == null) {
            return true;
        }
        if (im1.hasDisplayName()) {
            String displayName2;
            String displayName1 = im1.getDisplayName().trim();
            String string = displayName2 = im2.hasDisplayName() ? im2.getDisplayName().trim() : "";
            if (!displayName1.equals(displayName2)) {
                return false;
            }
        } else if (!im1.hasDisplayName() && im2.hasDisplayName()) {
            return false;
        }
        boolean isValid = true;
        if (im1.hasLore()) {
            List lore2;
            List lore1 = im1.getLore();
            List list = lore2 = im2.hasLore() ? im2.getLore() : new ArrayList();
            if (lore1 == null || lore2 == null) {
                isValid = false;
            } else if (lore1.isEmpty() || lore1.size() != lore2.size()) {
                isValid = false;
            } else {
                for (int i = 0; i < lore1.size(); ++i) {
                    if (((String)lore1.get(i)).equals(lore2.get(i))) continue;
                    isValid = false;
                    break;
                }
            }
        }
        if (im1 instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta storage1 = (EnchantmentStorageMeta)im1;
            EnchantmentStorageMeta storage2 = (EnchantmentStorageMeta)im2;
            Map ench1 = storage1.getStoredEnchants();
            Map ench2 = storage2.getStoredEnchants();
            if (ench1.size() != ench2.size()) {
                isValid = false;
            }
            for (Map.Entry entry : ench1.entrySet()) {
                if (ench2.containsKey(entry.getKey()) && ((Integer)ench2.get(entry.getKey())).equals(entry.getValue())) continue;
                isValid = false;
            }
        } else if (im1.hasEnchants()) {
            Map ench1 = im1.getEnchants();
            Map ench2 = im2.getEnchants();
            if (ench1.size() != ench2.size()) {
                isValid = false;
            }
            for (Map.Entry entry : ench1.entrySet()) {
                if (ench2.containsKey(entry.getKey()) && ((Integer)ench2.get(entry.getKey())).equals(entry.getValue())) continue;
                isValid = false;
            }
        }
        if (im1.hasCustomModelData() && im2.hasCustomModelData()) {
            if (im1.getCustomModelData() != im2.getCustomModelData()) {
                isValid = false;
            }
        } else if (im1.hasCustomModelData() || im2.hasCustomModelData()) {
            isValid = false;
        }
        if (im1.isUnbreakable() && im2.isUnbreakable()) {
            isValid = false;
        }
        return isValid || is1.isSimilar(is2);
    }

    @Generated
    public Recipe getRecipe() {
        return this.recipe;
    }

    @Generated
    public ItemStack getIcon() {
        return this.icon;
    }

    @Generated
    public boolean isCanCraft() {
        return this.canCraft;
    }
}

