/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.data.queue;

import lombok.Generated;
import lombok.NonNull;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.data.professions.pattern.Category;
import studio.magemonkey.fusion.data.queue.CraftingQueue;
import studio.magemonkey.fusion.data.recipes.Recipe;

public class QueueItem {
    private long id;
    private String profession;
    private Category category;
    @NonNull
    private Recipe recipe;
    private ItemStack icon;
    private long timestamp;
    private boolean done;
    private int savedSeconds;
    private boolean isRunning = false;
    private CraftingQueue craftingQueue;
    private int visualRemainingItemTime;

    public QueueItem(int id, String profession, Category category, @NotNull Recipe recipe, long timestamp, int savedSeconds) {
        this.id = id;
        this.profession = profession;
        this.category = category;
        this.recipe = recipe;
        this.timestamp = timestamp;
        this.savedSeconds = savedSeconds;
        this.visualRemainingItemTime = recipe.getCraftingTime() - savedSeconds;
    }

    public QueueItem(int id, String profession, Category category, @NotNull Recipe recipe) {
        this(id, profession, category, recipe, System.currentTimeMillis(), 0);
    }

    public void setCraftinQueue(CraftingQueue craftingQueue) {
        this.craftingQueue = craftingQueue;
    }

    public void update() {
        if (this.isDone()) {
            return;
        }
        if (this.craftingQueue != null) {
            this.visualRemainingItemTime = this.craftingQueue.getVisualRemainingTotalTime();
            int reconstructedCooldown = this.visualRemainingItemTime + this.savedSeconds;
            if (this.visualRemainingItemTime == this.recipe.getCraftingTime() + 1) {
                return;
            }
            if (reconstructedCooldown <= this.recipe.getCraftingTime()) {
                if (!this.isRunning) {
                    this.isRunning = true;
                    this.timestamp = System.currentTimeMillis();
                    return;
                }
                ++this.savedSeconds;
                this.timestamp = System.currentTimeMillis();
                if (this.savedSeconds >= this.recipe.getCraftingTime()) {
                    this.done = true;
                    this.timestamp = System.currentTimeMillis();
                }
                this.icon = ProfessionsCfg.getQueueItem(this.profession, this);
                if (this.savedSeconds > 0) {
                    --this.visualRemainingItemTime;
                }
            }
        } else {
            this.icon = ProfessionsCfg.getQueueItem(this.profession, this);
        }
    }

    public void updateIcon() {
        this.icon = ProfessionsCfg.getQueueItem(this.profession, this);
    }

    public String getRecipePath() {
        return this.recipe.getRecipePath();
    }

    public void progressOffline(int offlineSeconds) {
        if (this.done || offlineSeconds <= 0) {
            return;
        }
        int remaining = this.recipe.getCraftingTime() - this.savedSeconds;
        if (offlineSeconds >= remaining) {
            this.savedSeconds = this.recipe.getCraftingTime();
            this.done = true;
        } else {
            this.savedSeconds += offlineSeconds;
        }
        this.visualRemainingItemTime = this.recipe.getCraftingTime() - this.savedSeconds;
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getProfession() {
        return this.profession;
    }

    @Generated
    public Category getCategory() {
        return this.category;
    }

    @NonNull
    @Generated
    public Recipe getRecipe() {
        return this.recipe;
    }

    @Generated
    public ItemStack getIcon() {
        return this.icon;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public boolean isDone() {
        return this.done;
    }

    @Generated
    public int getSavedSeconds() {
        return this.savedSeconds;
    }

    @Generated
    public boolean isRunning() {
        return this.isRunning;
    }

    @Generated
    public CraftingQueue getCraftingQueue() {
        return this.craftingQueue;
    }

    @Generated
    public QueueItem(long id, String profession, Category category, @NonNull Recipe recipe, ItemStack icon, long timestamp, boolean done, int savedSeconds, boolean isRunning, CraftingQueue craftingQueue, int visualRemainingItemTime) {
        if (recipe == null) {
            throw new NullPointerException("recipe is marked non-null but is null");
        }
        this.id = id;
        this.profession = profession;
        this.category = category;
        this.recipe = recipe;
        this.icon = icon;
        this.timestamp = timestamp;
        this.done = done;
        this.savedSeconds = savedSeconds;
        this.isRunning = isRunning;
        this.craftingQueue = craftingQueue;
        this.visualRemainingItemTime = visualRemainingItemTime;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public int getVisualRemainingItemTime() {
        return this.visualRemainingItemTime;
    }
}

