/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.data.professions.pattern;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.codex.api.items.exception.CodexItemException;
import studio.magemonkey.codex.api.items.providers.VanillaProvider;
import studio.magemonkey.codex.util.DeserializationWorker;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.data.professions.pattern.InventoryPattern;
import studio.magemonkey.fusion.data.recipes.Recipe;
import studio.magemonkey.fusion.util.ChatUT;

public class Category
implements ConfigurationSerializable {
    private String name;
    private String displayName = null;
    private List<String> displayLore = null;
    private ItemType iconItem;
    private final Collection<Recipe> recipes = new ArrayList<Recipe>();
    private InventoryPattern pattern;
    private int order;
    private boolean hasPrevious = true;
    private final String iconName;

    public Category(String name) {
        this.name = name;
        this.order = 0;
        this.iconItem = new VanillaProvider.VanillaItemType(Material.PAPER);
        this.iconName = "PAPER";
    }

    public Category(String name, String iconName, InventoryPattern pattern, int order) {
        this.name = name;
        this.iconName = iconName;
        try {
            this.iconItem = CodexEngine.get().getItemManager().getItemType(iconName);
        }
        catch (CodexItemException e) {
            Fusion.getInstance().getLogger().severe("Invalid category icon for: " + name);
            Fusion.getInstance().getLogger().warning(e.getMessage());
            Fusion.getInstance().getLogger().warning("Using default icon instead.");
            this.iconItem = new VanillaProvider.VanillaItemType(Material.PAPER);
        }
        this.pattern = pattern;
        this.order = order;
    }

    public Category(Map<String, Object> map) {
        DeserializationWorker dw = DeserializationWorker.start(map);
        this.name = dw.getString("name");
        this.order = dw.getInt("order");
        this.iconName = dw.getString("icon");
        try {
            this.iconItem = CodexEngine.get().getItemManager().getItemType(this.iconName);
        }
        catch (CodexItemException e) {
            Fusion.getInstance().getLogger().severe("Invalid category icon for: " + this.name);
            Fusion.getInstance().getLogger().warning(e.getMessage());
            Fusion.getInstance().getLogger().warning("Using default icon instead.");
            this.iconItem = new VanillaProvider.VanillaItemType(Material.PAPER);
        }
        Map displaySection = dw.getSection("display");
        if (displaySection != null) {
            this.displayName = displaySection.getOrDefault("name", null);
            this.displayLore = displaySection.getOrDefault("lore", null);
        }
        this.pattern = dw.getSection("pattern") != null ? new InventoryPattern(dw.getSection("pattern")) : null;
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("order", this.order);
        map.put("icon", this.iconName);
        if (this.pattern != null) {
            map.put("pattern", this.pattern.serialize());
        }
        return map;
    }

    public void hasPrevious(boolean b) {
        this.hasPrevious = b;
    }

    public boolean hasPrevious() {
        return this.hasPrevious;
    }

    @Nullable
    public Recipe getRecipe(String name) {
        ArrayList<Recipe> possibleRecipes = new ArrayList<Recipe>();
        for (Recipe recipe : this.recipes) {
            if (recipe.getName().equals(name)) {
                return recipe;
            }
            if (!recipe.getName().startsWith(name + "::")) continue;
            possibleRecipes.add(recipe);
        }
        if (possibleRecipes.size() == 1) {
            return (Recipe)possibleRecipes.get(0);
        }
        if (possibleRecipes.size() > 1) {
            Fusion.getInstance().getLogger().warning("Multiple recipes found for: " + name);
        }
        return null;
    }

    public ItemStack getDisplayIcon() {
        Object translated;
        ItemStack item = this.iconItem.create();
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        if (this.displayName != null) {
            translated = ChatUT.hexString(this.displayName);
            meta.setDisplayName((String)translated);
            try {
                meta.setItemName((String)translated);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        if (this.displayLore != null) {
            translated = new ArrayList();
            for (String line : this.displayLore) {
                translated.add(ChatUT.hexString(line));
            }
            meta.setLore((List)translated);
        }
        item.setItemMeta(meta);
        return item;
    }

    public static Category copy(Category category) {
        return new Category(category.getName(), category.getIconName(), InventoryPattern.copy(category.getPattern()), category.getOrder());
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public List<String> getDisplayLore() {
        return this.displayLore;
    }

    @Generated
    public void setDisplayLore(List<String> displayLore) {
        this.displayLore = displayLore;
    }

    @Generated
    public ItemType getIconItem() {
        return this.iconItem;
    }

    @Generated
    public void setIconItem(ItemType iconItem) {
        this.iconItem = iconItem;
    }

    @Generated
    public Collection<Recipe> getRecipes() {
        return this.recipes;
    }

    @Generated
    public void setPattern(InventoryPattern pattern) {
        this.pattern = pattern;
    }

    @Generated
    public InventoryPattern getPattern() {
        return this.pattern;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public String getIconName() {
        return this.iconName;
    }
}

