/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.data.professions;

import java.util.UUID;
import lombok.Generated;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.cfg.sql.SQLManager;

public class Profession {
    private final long id;
    private final UUID uuid;
    private final String name;
    private long exp;
    private boolean mastered;
    private boolean joined;

    public Profession(long id, UUID uuid, String name, long exp, boolean mastered, boolean joined) {
        this.id = id;
        this.uuid = uuid;
        this.name = name;
        this.exp = exp;
        this.mastered = mastered;
        this.joined = joined;
    }

    public void addExp(long exp) {
        this.exp += exp;
    }

    public void removeExp(long exp) {
        this.exp -= exp;
    }

    public void resetExp() {
        this.exp = 0L;
    }

    public void resetMastered() {
        this.mastered = false;
    }

    public void resetJoined() {
        this.joined = false;
    }

    public void reset() {
        this.resetExp();
        this.resetMastered();
        this.resetJoined();
    }

    public void update() {
        SQLManager.professions().setProfession(this.uuid, this);
    }

    public int getLevel() {
        return ProfessionsCfg.getGuiMap().containsKey(this.name) ? ProfessionsCfg.getTable(this.name).getLevelFunction().getLevel(this.exp) : 0;
    }

    public void setLevel(int level) {
        if (level < this.getLevel()) {
            long diffExp = (long)((double)this.exp - ProfessionsCfg.getTable(this.name).getLevelFunction().getXP(level));
            this.removeExp(diffExp);
        } else {
            long requiredExp = (long)(ProfessionsCfg.getTable(this.name).getLevelFunction().getXP(level) - (double)this.exp);
            this.addExp(requiredExp);
        }
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public long getExp() {
        return this.exp;
    }

    @Generated
    public boolean isMastered() {
        return this.mastered;
    }

    @Generated
    public boolean isJoined() {
        return this.joined;
    }

    @Generated
    public void setExp(long exp) {
        this.exp = exp;
    }

    @Generated
    public void setMastered(boolean mastered) {
        this.mastered = mastered;
    }

    @Generated
    public void setJoined(boolean joined) {
        this.joined = joined;
    }
}

